/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.session.external;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Cast;
import coldfusion.util.CaseInsensitiveHashtable;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;

public class RedisConfig {
    private String host;
    private int port = 6379;
    private String password;
    private int database = 0;
    private int timeout = 2000;
    private int maxConnections = 8;
    private long maxwaitMillis = -1L;
    private boolean blockWhenExhausted = true;
    private boolean validateConnection = true;
    private boolean validateConnectionOnCheckout;
    private boolean jmxEnabled;
    private boolean isSSL;
    private int maxIdle = 8;
    private int minIdle = 1;
    public static String jmxPrefix = "cf-redis-session";

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean isSSL) {
        this.isSSL = isSSL;
    }

    public RedisConfig(String host, int port, String libPath) {
        this.host = host;
        this.port = port;
        this.loadConnectionDefaults(libPath);
    }

    private void loadConnectionDefaults(final String libPath) {
        if (System.getSecurityManager() == null) {
            this._loadConnectionDefaults(libPath);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        RedisConfig.this._loadConnectionDefaults(libPath);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    private void _loadConnectionDefaults(String libPath) {
        File redisPropsFile = new File(libPath, "redisstorage.properties");
        try {
            if (redisPropsFile.exists()) {
                FileInputStream stream = new FileInputStream(redisPropsFile);
                Properties properties = new Properties();
                properties.load(stream);
                CaseInsensitiveHashtable props = new CaseInsensitiveHashtable((Map)properties);
                if (props.containsKey((Object)"MAXCONNECTIONS")) {
                    this.maxConnections = Cast._int((Object)props.get((Object)"MAXCONNECTIONS"), (boolean)false);
                }
                if (props.containsKey((Object)"MAXWAITMILLIS")) {
                    this.maxwaitMillis = Cast._long((Object)props.get((Object)"MAXWAITMILLIS"), (boolean)false);
                }
                if (props.containsKey((Object)"MAXIDLE")) {
                    this.maxIdle = Cast._int((Object)props.get((Object)"MAXIDLE"), (boolean)false);
                }
                if (props.containsKey((Object)"MINIDLE")) {
                    this.minIdle = Cast._int((Object)props.get((Object)"MINIDLE"), (boolean)false);
                }
                if (props.containsKey((Object)"BLOCKWHENEXHAUSTED")) {
                    this.blockWhenExhausted = Cast._boolean((Object)props.get((Object)"BLOCKWHENEXHAUSTED"));
                }
                if (props.containsKey((Object)"VALIDATECONNECTION")) {
                    this.validateConnection = Cast._boolean((Object)props.get((Object)"VALIDATECONNECTION"));
                }
                if (props.containsKey((Object)"VALIDATEONCONNECTIONCHECKOUT")) {
                    this.validateConnectionOnCheckout = Cast._boolean((Object)props.get((Object)"VALIDATEONCONNECTIONCHECKOUT"));
                }
                if (props.containsKey((Object)"JMXENABLED")) {
                    this.jmxEnabled = Cast._boolean((Object)props.get((Object)"JMXENABLED"));
                }
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null && !password.trim().equals("")) {
            this.password = password;
        }
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public long getMaxwaitMillis() {
        return this.maxwaitMillis;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public boolean isValidateConnectionOnCheckout() {
        return this.validateConnectionOnCheckout;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.database;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisConfig other = (RedisConfig)obj;
        if (this.database != other.database) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.port == other.port;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }
}

