/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.statistic;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.communityevents.CommunityEventsService;
import com.lotus.sametime.communityevents.ServiceAvailableEvent;
import com.lotus.sametime.communityevents.ServiceAvailableListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.statistic.StatisticEvent;
import com.lotus.sametime.statistic.StatisticListener;
import com.lotus.sametime.statistic.StatisticService;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticComp
extends STComp
implements LoginListener,
ChannelListener,
StatisticService,
ServiceAvailableListener {
    private static final Level DEBUG_LEVEL_STATISTICS = Level.FINER;
    private static final int REQUEST_STATISTICS = 0;
    private static final int RESPONSE_STATISTICS = 1;
    private CommunityService m_comm;
    private CommunityEventsService m_communityEventsService;
    private ChannelService m_channelService;
    private Vector m_listeners = new Vector();
    private byte[] m_msgRequest;
    private Vector m_channelsVec;
    private Timer m_timer;
    private Hashtable m_statisticProviders;
    private STId m_localServerId;
    private int m_statisticType;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.statistic");

    public StatisticComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.statistic.StatisticComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_communityEventsService = (CommunityEventsService)sTSession.getCompApi("com.lotus.sametime.communityevents.CommunityEventsComp");
        this.m_communityEventsService.addServiceAvailableListener((ServiceAvailableListener)this);
        this.m_comm.addLoginListener(this);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_msgRequest = ndrOutputStream.toByteArray();
        this.m_statisticProviders = new Hashtable();
        this.m_channelsVec = new Vector();
    }

    public void addStatisticListener(StatisticListener statisticListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(statisticListener);
        this.m_listeners = vector;
    }

    public void removeStatisticListener(StatisticListener statisticListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(statisticListener);
        this.m_listeners = vector;
    }

    public void startCollectStatistics(int n, int n2) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "startCollectStatistics", "StatisticComp.startCollectStatistics()");
        }
        this.m_statisticType = n2;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new statisticCollectionReminder(), new Date(), (long)(n * 1000));
    }

    public void stopCollectStatistics() {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "stopCollectStatistics", "StatisticComp.stopCollectStatistics()");
        }
        this.m_timer.cancel();
    }

    public void channelOpened(ChannelEvent channelEvent) {
        this.m_channelsVec.add(channelEvent.getChannel());
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "channelOpenFailed", "StatisticComp.channelOpenFailed()");
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "channelClosed", "StatisticComp.channelClosed()");
        }
        for (int i = 0; i < this.m_channelsVec.size(); ++i) {
            if (this.m_channelsVec.elementAt(i) != channelEvent.getChannel()) continue;
            this.m_channelsVec.remove(i);
            break;
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "channelMsgReceived", "StatisticComp.channelMsgReceived()");
        }
        Channel channel = channelEvent.getChannel();
        NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
        int n = 0;
        try {
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        switch (channelEvent.getMessageType()) {
            case 1: {
                String string = "";
                String string2 = "";
                try {
                    while (ndrInputStream.available() > 0) {
                        string = ndrInputStream.readUTF();
                        string2 = ndrInputStream.readUTF();
                        hashMap.put(string, string2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
                StatisticEvent statisticEvent = new StatisticEvent(hashMap);
                Enumeration enumeration = this.m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    StatisticListener statisticListener = (StatisticListener)enumeration.nextElement();
                    statisticListener.statisticDataReceived(statisticEvent);
                }
                break;
            }
        }
    }

    public void servicesAvailable(ServiceAvailableEvent serviceAvailableEvent) {
        if ((serviceAvailableEvent.getLoginInfo().getServerId().getId().equals(this.m_localServerId) && this.m_statisticType == 0 || this.m_statisticType == 1) && this.m_statisticProviders.get(serviceAvailableEvent.getLoginInfo().getLoginId()) == null) {
            Channel channel = this.m_channelService.createChannel(52, 52, 1, EncLevel.ENC_LEVEL_NONE, this.m_msgRequest, serviceAvailableEvent.getLoginInfo().getLoginId());
            channel.addChannelListener(this);
            channel.open();
            this.m_statisticProviders.put(serviceAvailableEvent.getLoginInfo().getLoginId(), "");
        }
    }

    public void servicesUnavailable(ServiceAvailableEvent serviceAvailableEvent) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "servicesUnavailable", "StatisticComp.servicesUnavailable()");
        }
        if (this.m_statisticProviders.get(serviceAvailableEvent.getLoginInfo().getLoginId()) != null) {
            this.m_statisticProviders.remove(serviceAvailableEvent.getLoginInfo().getLoginId());
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_localServerId = loginEvent.getLogin().getServer().getId();
    }

    public void loggedOut(LoginEvent loginEvent) {
        if (this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
            this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "loggedOut", "StatisticComp.loggedOut()");
        }
        this.m_channelsVec.clear();
    }

    class statisticCollectionReminder
    extends TimerTask {
        statisticCollectionReminder() {
        }

        public void run() {
            try {
                Object[] objectArray = new Channel[StatisticComp.this.m_channelsVec.size()];
                StatisticComp.this.m_channelsVec.copyInto(objectArray);
                if (StatisticComp.this.m_logger.isLoggable(DEBUG_LEVEL_STATISTICS)) {
                    StatisticComp.this.m_logger.logp(DEBUG_LEVEL_STATISTICS, this.getClass().getName(), "run", "statisticCollectionReminder.run() :: Collect statistics");
                }
                StatisticComp.this.m_channelService.sendOnChannels((Channel[])objectArray, (short)0, StatisticComp.this.m_msgRequest, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

