/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.post;

import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImAdapter;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.post.PostEvent;
import com.lotus.sametime.post.PostListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Post {
    static final int ST_POST_DATA_TYPE = 10;
    static final int ST_POST_DATA_SUB_TYPE = 1;
    static final int ST_RESPONSE_DATA_SUB_TYPE = 2;
    Im m_incomingIm;
    String m_title;
    String m_postText;
    final int m_postType;
    int m_detailsType;
    byte[] m_details;
    InstantMessagingService m_imService;
    Hashtable m_openMessages = new Hashtable();
    Vector m_invitees = new Vector();
    private ImListener m_imListener;
    Vector m_listeners = new Vector();
    boolean m_incomingPost;
    boolean m_postAllreadySent;
    boolean m_preferLoginId = false;

    protected Post(int n, String string, String string2, int n2, byte[] byArray, STUser[] sTUserArray, InstantMessagingService instantMessagingService, boolean bl) {
        this.m_imService = instantMessagingService;
        this.m_title = string == null ? "" : string;
        this.m_postText = string2 == null ? "" : string2;
        this.m_postType = n;
        this.m_detailsType = n2;
        this.m_details = byArray;
        this.m_preferLoginId = bl;
        if (sTUserArray != null) {
            for (int i = 0; i < sTUserArray.length; ++i) {
                this.m_invitees.addElement(sTUserArray[i]);
            }
        }
        this.m_incomingPost = false;
        this.createImListener();
    }

    protected Post(Im im, String string, String string2, int n, byte[] byArray) {
        this.m_incomingIm = im;
        this.m_incomingPost = true;
        this.m_title = string;
        this.m_postType = im.getType();
        this.m_postText = string2;
        this.m_detailsType = n;
        this.m_details = byArray;
    }

    public synchronized void addPostListener(PostListener postListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(postListener);
        this.m_listeners = vector;
    }

    public synchronized void removePostListener(PostListener postListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(postListener);
        this.m_listeners = vector;
    }

    public void send() {
        if (this.m_incomingPost || this.m_postAllreadySent) {
            System.out.println("Failed to send post, a post object should be used only once");
            return;
        }
        Vector vector = (Vector)this.m_invitees.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            Im im = this.m_imService.createIm(sTUser, EncLevel.ENC_LEVEL_NONE, this.m_postType, this.m_preferLoginId);
            im.addImListener(this.m_imListener);
            im.open();
            this.m_openMessages.put(im, sTUser);
        }
        this.m_postAllreadySent = true;
    }

    public void respond(int n, String string) {
        if (!this.m_incomingPost) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.startMark();
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeUTF(string);
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.m_incomingIm.sendData(false, 10, 2, ndrOutputStream.toByteArray());
    }

    public void setDetailsType(int n) {
        if (!this.m_incomingPost && !this.m_postAllreadySent) {
            this.m_detailsType = n;
        }
    }

    public int getDetailsType() {
        return this.m_detailsType;
    }

    public void setDetails(byte[] byArray) {
        if (!this.m_incomingPost && !this.m_postAllreadySent) {
            this.m_details = byArray;
        }
    }

    public byte[] getDetails() {
        return this.m_details;
    }

    public void setMessage(String string) {
        if (!this.m_incomingPost && !this.m_postAllreadySent) {
            this.m_postText = string;
        }
    }

    public String getMessage() {
        return this.m_postText;
    }

    public void setTitle(String string) {
        if (!this.m_incomingPost && !this.m_postAllreadySent) {
            this.m_title = string;
        }
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getType() {
        return this.m_postType;
    }

    public void addUser(STUser sTUser) {
        if (!this.m_incomingPost && !this.m_postAllreadySent) {
            this.m_invitees.addElement(sTUser);
        }
    }

    public STUserInstance getSenderDetails() {
        if (this.m_incomingPost) {
            return this.m_incomingIm.getPartnerDetails();
        }
        return null;
    }

    private void imOpened(ImEvent imEvent) {
        Im im = imEvent.getIm();
        if (im.getType() != this.m_postType) {
            return;
        }
        if (this.m_openMessages.get(im) != null) {
            this.sendInvitation(im);
        }
    }

    private void dataReceived(ImEvent imEvent) {
        STUser sTUser;
        if (imEvent.getDataType() != 10) {
            return;
        }
        if (imEvent.getDataSubType() == 2 && (sTUser = (STUser)this.m_openMessages.get(imEvent.getIm())) != null) {
            this.handleResponse(sTUser, imEvent.getData());
            imEvent.getIm().close(0);
        }
    }

    private void openImFailed(ImEvent imEvent) {
        int n = imEvent.getReason();
        if (n == -2147475451) {
            n = -2147471355;
        }
        Im im = (Im)imEvent.getSource();
        STUser sTUser = im.getPartner();
        this.m_openMessages.remove(im);
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        PostEvent postEvent = new PostEvent(this, 2, sTUser, n);
        while (enumeration.hasMoreElements()) {
            PostListener postListener = (PostListener)enumeration.nextElement();
            postListener.sendToUserFailed(postEvent);
        }
    }

    private void sendInvitation(Im im) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.startMark();
            ndrOutputStream.writeUTF(this.m_title);
            ndrOutputStream.writeUTF(this.m_postText);
            ndrOutputStream.writeInt(this.m_detailsType);
            ndrOutputStream.writeBytes(this.m_details);
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        im.sendData(false, 10, 1, ndrOutputStream.toByteArray());
    }

    private void handleResponse(STUser sTUser, byte[] byArray) {
        String string;
        int n;
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.loadMark();
            n = ndrInputStream.readInt();
            string = ndrInputStream.readUTF();
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        PostEvent postEvent = new PostEvent(this, 1, sTUser, string, n);
        while (enumeration.hasMoreElements()) {
            PostListener postListener = (PostListener)enumeration.nextElement();
            postListener.userResponded(postEvent);
        }
    }

    private void createImListener() {
        this.m_imListener = new ImAdapter(){

            public void imOpened(ImEvent imEvent) {
                Post.this.imOpened(imEvent);
            }

            public void openImFailed(ImEvent imEvent) {
                Post.this.openImFailed(imEvent);
            }

            public void dataReceived(ImEvent imEvent) {
                Post.this.dataReceived(imEvent);
            }
        };
    }
}

