/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.places.Activity;
import com.lotus.sametime.places.IncomingMessage;
import com.lotus.sametime.places.MyselfEvent;
import com.lotus.sametime.places.MyselfInPlace;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceEvent;
import com.lotus.sametime.places.PlaceMember;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.PlacesServiceEvent;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.SectionEvent;
import com.lotus.sametime.places.UserInPlace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlacesImpl
extends STCompImpl
implements ChannelListener,
ServiceListener,
LoginListener {
    private Hashtable m_places = new Hashtable();
    private Hashtable m_waitingPlaces = new Hashtable();
    private ChannelService m_cnlService;
    private CommunityService m_commService;
    private boolean m_serviceUp = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.places");

    public PlacesImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.places.PlacesComp", sTSession);
        this.m_cnlService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_commService != null) {
            this.m_commService.addServiceListener(this);
            this.m_commService.addLoginListener(this);
        }
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
        Debug.stAssert(this.m_cnlService != null);
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
        this.m_commService.removeServiceListener(this);
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_cnlService == null && sTCompApi instanceof ChannelService) {
            this.m_cnlService = (ChannelService)sTCompApi;
        }
        if (this.m_commService == null && sTCompApi instanceof CommunityService) {
            this.m_commService = (CommunityService)sTCompApi;
            this.m_commService.addServiceListener(this);
            this.m_commService.addLoginListener(this);
            if (!this.m_serviceUp && this.m_commService.isLoggedIn()) {
                this.m_commService.senseService(-2147483614);
            }
        }
    }

    public boolean isServiceUp() {
        return this.m_serviceUp;
    }

    public void enterPlace(Place place) {
        Channel channel = this.createPlacesChannel(place);
        place.setChannel(channel);
        this.m_waitingPlaces.put(channel, place);
    }

    public void leavePlace(Integer n, int n2) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        Channel channel = place.getChannel();
        channel.close(n2, null);
    }

    public void changeSection(Integer n, Integer n2) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)1, ndrOutputStream.toByteArray(), false);
    }

    public void addActivity(Integer n, int n2, byte[] byArray) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeBytes(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)30, ndrOutputStream.toByteArray(), false);
    }

    public void setMyIdInActivity(Integer n, Integer n2, String string) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeUTF(string);
            ndrOutputStream.writeInt(n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)60, ndrOutputStream.toByteArray(), false);
    }

    public void setAttribute(Integer n, Integer n2, STExtendedAttribute sTExtendedAttribute) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.startMark();
            ndrOutputStream.writeInt(sTExtendedAttribute.getKey());
            ndrOutputStream.writeBytes(sTExtendedAttribute.getValue());
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)10, ndrOutputStream.toByteArray(), true);
    }

    public void removeAttribute(Integer n, Integer n2, int n3) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeInt(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = ndrOutputStream.toByteArray();
        Channel channel = place.getChannel();
        channel.sendMsg((short)11, byArray, false);
    }

    public void getAttributeContent(Integer n, Integer n2, int n3) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeInt(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)12, ndrOutputStream.toByteArray(), false);
    }

    private void subscribeOnMember(Integer n, Integer n2) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        if (place.isSubscribed(n2) || place.isWaitingSubscriber(n2)) {
            return;
        }
        int n3 = STCompPart.getUniqueId();
        place.addWaitingSubscriber(n2, n3);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeShort(2);
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeBoolean(false);
            ndrOutputStream.writeInt(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)20, ndrOutputStream.toByteArray(), false);
    }

    private void unsubscribeOnMember(Integer n, Integer n2) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        if (!place.isSubscribed(n2)) {
            return;
        }
        place.removeSubscriber(n2);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeShort(3);
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeBoolean(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)20, ndrOutputStream.toByteArray(), false);
    }

    public void invite15Client(Integer n, STUser sTUser, String string, boolean bl) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            sTUser.getId().dump(ndrOutputStream);
            ndrOutputStream.writeUTF(sTUser.getName());
            if (sTUser instanceof STUserInstance) {
                ndrOutputStream.writeUTF(((STUserInstance)sTUser).getLoginId().getId());
            } else {
                ndrOutputStream.writeUTF("");
            }
            ndrOutputStream.writeUTF(string);
            ndrOutputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)5, ndrOutputStream.toByteArray(), false);
    }

    public void addAllowedUsers(Integer n, Integer n2, STUser[] sTUserArray) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeInt(sTUserArray.length);
            for (int i = 0; i < sTUserArray.length; ++i) {
                sTUserArray[i].getId().dump(ndrOutputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)50, ndrOutputStream.toByteArray(), false);
    }

    public void removeAllowedUsers(Integer n, Integer n2, STUser[] sTUserArray) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeInt(sTUserArray.length);
            for (int i = 0; i < sTUserArray.length; ++i) {
                sTUserArray[i].getId().dump(ndrOutputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)51, ndrOutputStream.toByteArray(), false);
    }

    public void sendText(Integer n, Integer n2, String string) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        byte[] byArray = this.buildTextMessage(string);
        this.sendToMember(place, n2, byArray);
    }

    public void sendData(Integer n, Integer n2, int n3, byte[] byArray) {
        Place place = this.getPlace(n);
        if (place == null) {
            return;
        }
        byte[] byArray2 = this.buildDataMessage(n3, byArray);
        this.sendToMember(place, n2, byArray2);
    }

    private void sendToMember(Place place, Integer n, byte[] byArray) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeBytes(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)3, ndrOutputStream.toByteArray(), true);
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (channel.getServiceType() != -2147483614 || channel.getProtocolType() != 33) {
            return;
        }
        Place place = (Place)this.m_waitingPlaces.remove(channel);
        place.setEncLevel(channel.getEncLevel());
        this.m_places.put(channel, place);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeUTF(place.getPassword());
            ndrOutputStream.writeBoolean(place.getToStage());
            ndrOutputStream.writeShort(place.getPublishMode());
            ndrOutputStream.writeShort(place.getCreationMode());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel2 = place.getChannel();
        channel2.sendMsg((short)0, ndrOutputStream.toByteArray(), true);
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (this.m_waitingPlaces.containsKey(channel)) {
            Place place = (Place)this.m_waitingPlaces.remove(channel);
            PlaceEvent placeEvent = new PlaceEvent((Object)place, -2147483646, channelEvent.getReason());
            place.processPlacesEvent(placeEvent);
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (this.m_places.containsKey(channel)) {
            Place place = (Place)this.m_places.remove(channel);
            int n = place.isInPlace() ? -2147483645 : -2147483646;
            PlaceEvent placeEvent = new PlaceEvent((Object)place, n, channelEvent.getReason());
            place.processPlacesEvent(placeEvent);
            if (channelEvent.getReason() == -2147483635 && this.m_serviceUp) {
                this.m_serviceUp = false;
                this.sendEvent(new PlacesServiceEvent(this, -2147483646));
                this.m_commService.senseService(-2147483614);
            }
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Place place = (Place)this.m_places.get(channel);
        if (place == null) {
            return;
        }
        NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
        switch (channelEvent.getMessageType()) {
            case 0: {
                this.handleEntered(place, ndrInputStream);
                break;
            }
            case 1: {
                this.handleNavigate(place, ndrInputStream);
                break;
            }
            case 2: {
                this.handleGetProperties(place, ndrInputStream);
                break;
            }
            case 3: {
                this.handleSendToMember(place, ndrInputStream);
                break;
            }
            case 4: {
                this.handleMsgFromMember(place, ndrInputStream);
                break;
            }
            case 30: {
                this.handleAddActivity(place, ndrInputStream);
                break;
            }
            case 5: {
                this.handleInviteDeclined(place, ndrInputStream);
                break;
            }
            case 50: {
                this.handleAddAllowedUsersFailed(place, ndrInputStream);
                break;
            }
            case 51: {
                this.handleRemoveAllowedUsersFailed(place, ndrInputStream);
                break;
            }
            case 10: {
                this.handleSetAttr(place, ndrInputStream);
                break;
            }
            case 11: {
                this.handleRemoveAttr(place, ndrInputStream);
                break;
            }
            case 20: {
                this.handleEventMembers(place, ndrInputStream);
                break;
            }
            case 21: {
                this.handleEventActivity(place, ndrInputStream);
                break;
            }
            case 12: {
                this.handleGetAttrContent(place, ndrInputStream);
            }
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_commService.senseService(-2147483614);
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_serviceUp = false;
    }

    private byte[] buildTextMessage(String string) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return ndrOutputStream.toByteArray();
    }

    private byte[] buildDataMessage(int n, byte[] byArray) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(2);
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeBytes(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return ndrOutputStream.toByteArray();
    }

    private void getProperties(Place place, Integer n) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Channel channel = place.getChannel();
        channel.sendMsg((short)2, ndrOutputStream.toByteArray(), false);
    }

    private void handleEntered(Place place, NdrInputStream ndrInputStream) {
        Integer n;
        Integer n2;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n = new Integer(ndrInputStream.readInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        place.setMySection(n);
        place.setMyself(n2);
        this.subscribeOnMember(place.getPlaceId(), new Integer(0));
    }

    private void handleNavigate(Place place, NdrInputStream ndrInputStream) {
        Integer n;
        int n2;
        try {
            n2 = ndrInputStream.readInt();
            n = new Integer(ndrInputStream.readInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        MyselfInPlace myselfInPlace = place.getMyselfInPlace();
        if (STError.VpkFailed(n2)) {
            MyselfEvent myselfEvent = new MyselfEvent((Object)myselfInPlace, -2147483644, n2);
            myselfInPlace.processPlacesEvent(myselfEvent);
        } else {
            place.setMySection(n);
            MyselfEvent myselfEvent = new MyselfEvent((Object)myselfInPlace, -2147483645, place.getMySection());
            myselfInPlace.processPlacesEvent(myselfEvent);
        }
    }

    private void handleGetProperties(Place place, NdrInputStream ndrInputStream) {
        int n;
        Integer n2;
        try {
            ndrInputStream.loadMark();
            n2 = new Integer(ndrInputStream.readInt());
            n = ndrInputStream.readInt();
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (STError.VpkFailed(n)) {
            return;
        }
        PlaceMember placeMember = this.loadMember(place, ndrInputStream, n2);
        if (placeMember != null) {
            Vector vector = place.getMessages(placeMember.getMemberId());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                IncomingMessage incomingMessage = (IncomingMessage)enumeration.nextElement();
                this.dispatchIncomingMessage(place, placeMember, incomingMessage.getReceiverId(), incomingMessage.getMessage());
            }
        }
    }

    private void handleAddActivity(Place place, NdrInputStream ndrInputStream) {
        int n;
        int n2;
        try {
            n2 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (STError.VpkFailed(n)) {
            PlaceEvent placeEvent = new PlaceEvent((Object)place, -2147483641, n2, n);
            place.processPlacesEvent(placeEvent);
        }
    }

    private void handleGetAttrContent(Place place, NdrInputStream ndrInputStream) {
        Object object;
        int n;
        int n2;
        Integer n3;
        try {
            n3 = new Integer(ndrInputStream.readInt());
            n2 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceMember placeMember = place.getMember(n3);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleGetAttrContent", "PLACES:Got attribute content on an unknown member");
            }
            return;
        }
        if (STError.VpkFailed(n2)) {
            object = new PlaceMemberEvent((Object)placeMember, -2147483641, n, n2);
            placeMember.processPlacesEvent((PlacesEvent)object);
        }
        try {
            object = ndrInputStream.readBytes();
        }
        catch (IOException iOException) {
            PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483641, n, -2147483641);
            placeMember.processPlacesEvent(placeMemberEvent);
            return;
        }
        STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(n, (byte[])object);
        PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483647, sTExtendedAttribute);
        placeMember.processPlacesEvent(placeMemberEvent);
    }

    private void handleInviteDeclined(Place place, NdrInputStream ndrInputStream) {
        int n;
        STUserInstance sTUserInstance;
        try {
            sTUserInstance = new STUserInstance(ndrInputStream);
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceEvent placeEvent = new PlaceEvent((Object)place, -2147483637, sTUserInstance, n);
        place.processPlacesEvent(placeEvent);
    }

    private void handleAddAllowedUsersFailed(Place place, NdrInputStream ndrInputStream) {
        int n;
        Integer n2;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (STError.VpkFailed(n)) {
            PlaceMember placeMember;
            PlacesEvent placesEvent;
            if (n2 == 0) {
                placesEvent = new PlaceEvent((Object)place, -2147483636, n);
                placeMember = place;
            } else {
                placeMember = place.getMember(n2);
                placesEvent = new SectionEvent((Object)placeMember, -2147483645, n);
            }
            placeMember.processPlacesEvent(placesEvent);
        }
    }

    private void handleRemoveAllowedUsersFailed(Place place, NdrInputStream ndrInputStream) {
        int n;
        Integer n2;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (STError.VpkFailed(n)) {
            PlaceMember placeMember;
            PlacesEvent placesEvent;
            if (n2 == 0) {
                placesEvent = new PlaceEvent((Object)place, -2147483635, n);
                placeMember = place;
            } else {
                placeMember = place.getMember(n2);
                placesEvent = new SectionEvent((Object)placeMember, -2147483644, n);
            }
            placeMember.processPlacesEvent(placesEvent);
        }
    }

    private void handleSendToMember(Place place, NdrInputStream ndrInputStream) {
        int n;
        Integer n2;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceMember placeMember = place.getMember(n2);
        PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483642, n);
        placeMember.processPlacesEvent(placeMemberEvent);
    }

    private void handleMsgFromMember(Place place, NdrInputStream ndrInputStream) {
        byte[] byArray;
        Integer n;
        Integer n2;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n = new Integer(ndrInputStream.readInt());
            byArray = ndrInputStream.readBytes();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceMember placeMember = place.getMember(n2);
        if (placeMember == null) {
            boolean bl = place.addMessage(new IncomingMessage(n2, n, byArray));
            if (!bl) {
                this.getProperties(place, n2);
            }
        } else {
            this.dispatchIncomingMessage(place, placeMember, n, byArray);
        }
    }

    private void dispatchIncomingMessage(Place place, PlaceMember placeMember, Integer n, byte[] byArray) {
        int n2 = 0;
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            n2 = ndrInputStream.readInt();
            switch (n2) {
                case 1: {
                    String string = ndrInputStream.readUTF();
                    this.textMessageReceived(place, placeMember, n, string);
                    break;
                }
                case 2: {
                    int n3 = ndrInputStream.readInt();
                    byte[] byArray2 = ndrInputStream.readBytes();
                    this.dataMessageReceived(place, placeMember, n, n3, byArray2);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void textMessageReceived(Place place, PlaceMember placeMember, Integer n, String string) {
        int n2 = this.getScope(place, n);
        MyselfInPlace myselfInPlace = place.getMyselfInPlace();
        MyselfEvent myselfEvent = new MyselfEvent(myselfInPlace, -2147483647, placeMember, n2, string);
        myselfInPlace.processPlacesEvent(myselfEvent);
    }

    private void dataMessageReceived(Place place, PlaceMember placeMember, Integer n, int n2, byte[] byArray) {
        int n3 = this.getScope(place, n);
        MyselfInPlace myselfInPlace = place.getMyselfInPlace();
        MyselfEvent myselfEvent = new MyselfEvent(myselfInPlace, -2147483646, placeMember, n3, n2, byArray);
        myselfInPlace.processPlacesEvent(myselfEvent);
    }

    private void handleSetAttr(Place place, NdrInputStream ndrInputStream) {
        int n;
        int n2;
        Integer n3;
        try {
            n3 = new Integer(ndrInputStream.readInt());
            n2 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceMember placeMember = place.getMember(n3);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleSetAttr", "Places: Attr change failed on an unknown member");
            }
            return;
        }
        PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483640, n, n2);
        placeMember.processPlacesEvent(placeMemberEvent);
    }

    private void handleRemoveAttr(Place place, NdrInputStream ndrInputStream) {
        int n;
        int n2;
        Integer n3;
        try {
            n3 = new Integer(ndrInputStream.readInt());
            n2 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        PlaceMember placeMember = place.getMember(n3);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleRemoveAttr", "Places: Attr remove failed on an unknown member");
            }
            return;
        }
        PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483639, n, n2);
        placeMember.processPlacesEvent(placeMemberEvent);
    }

    private void handleEventMembers(Place place, NdrInputStream ndrInputStream) {
        short s;
        try {
            s = ndrInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        switch (s) {
            case 2: {
                this.handleSubscribe(place, ndrInputStream);
                break;
            }
            case 3: {
                this.handleUnsubscribe(place, ndrInputStream);
                break;
            }
            case 0: {
                this.handleSnapshot(place, ndrInputStream);
                break;
            }
            case 1: {
                this.handleEventOnSubscribedMember(place, ndrInputStream);
                break;
            }
            default: {
                if (!this.m_logger.isLoggable(Level.FINER)) break;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleEventMembers", "Places: Got an unknown eventMembers event.");
            }
        }
    }

    private void handleSnapshot(Place place, NdrInputStream ndrInputStream) {
        Object[] objectArray;
        Integer n;
        int n2 = -1;
        try {
            ndrInputStream.loadMark();
            n = new Integer(ndrInputStream.readInt());
            n2 = ndrInputStream.readInt();
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (place.getWaitingSubscriber(n) != n2) {
            return;
        }
        place.removeWaitingSubscriber(n);
        place.addSubscriber(n, n2);
        int n3 = 0;
        int n4 = 0;
        Vector<Object[]> vector = new Vector<Object[]>();
        PlaceMember placeMember = place.getMember(n);
        try {
            ndrInputStream.loadMark();
            n3 = ndrInputStream.readInt();
            n4 = ndrInputStream.readInt();
            ndrInputStream.skipMarks();
            ndrInputStream.loadMark();
            for (int i = 0; i < n3; ++i) {
                objectArray = this.loadMember(place, ndrInputStream, n);
                if (objectArray != null && objectArray instanceof UserInPlace) {
                    vector.addElement(objectArray);
                    continue;
                }
                this.memberAdded(place, (PlaceMember)objectArray);
            }
            ndrInputStream.skipMarks();
            ndrInputStream.loadMark();
            for (int i = 0; i < n4; ++i) {
                STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(ndrInputStream);
                placeMember.processPlacesEvent(new PlaceMemberEvent((Object)placeMember, -2147483647, sTExtendedAttribute));
            }
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (vector.size() != 0) {
            objectArray = new UserInPlace[vector.size()];
            vector.copyInto(objectArray);
            placeMember.processPlacesEvent(new SectionEvent((Object)placeMember, -2147483647, (UserInPlace[])objectArray));
        }
    }

    private void handleSubscribe(Place place, NdrInputStream ndrInputStream) {
        int n;
        Integer n2;
        int n3 = -1;
        try {
            n2 = new Integer(ndrInputStream.readInt());
            n3 = ndrInputStream.readInt();
            n = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (place.removeWaitingSubscriber(n2) != n3) {
            return;
        }
        PlaceMember placeMember = place.getMember(n2);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleSubscribe", "Places: Subscribe failed on an unknown member");
            }
            return;
        }
        placeMember.processPlacesEvent(new PlaceMemberEvent((Object)placeMember, -2147483645, n));
    }

    private void handleUnsubscribe(Place place, NdrInputStream ndrInputStream) {
        Integer n;
        try {
            n = new Integer(ndrInputStream.readInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        place.removeSubscriber(n);
        PlaceMember placeMember = place.removeMember(n);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleUnsubscribe", "Places: unsubscribe failed on an unknown member");
            }
            return;
        }
        if (placeMember instanceof UserInPlace) {
            UserInPlace userInPlace = (UserInPlace)placeMember;
            Section section = userInPlace.getSection();
            SectionEvent sectionEvent = new SectionEvent((Object)section, -2147483646, userInPlace);
            section.processPlacesEvent(sectionEvent);
        } else if (placeMember instanceof Section) {
            PlaceEvent placeEvent = new PlaceEvent((Object)place, -2147483638, (Section)placeMember);
            place.processPlacesEvent(placeEvent);
        } else if (placeMember instanceof Activity) {
            PlaceEvent placeEvent = new PlaceEvent((Object)place, -2147483640, (Activity)placeMember);
            place.processPlacesEvent(placeEvent);
        } else if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleUnsubscribe", "Places: Unknown member unsubscribed");
        }
    }

    private void handleEventActivity(Place place, NdrInputStream ndrInputStream) {
        int n = -1;
        try {
            n = ndrInputStream.readShort();
            Integer n2 = new Integer(ndrInputStream.readInt());
            int n3 = ndrInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (n == 1 || n == 0) {
            // empty if block
        }
    }

    private void handleEventOnSubscribedMember(Place place, NdrInputStream ndrInputStream) {
        Integer n;
        short s;
        try {
            s = ndrInputStream.readShort();
            n = new Integer(ndrInputStream.readInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (!place.isSubscribed(n)) {
            return;
        }
        PlaceMember placeMember = place.getMember(n);
        if (s == 0) {
            PlaceMember placeMember2 = this.loadMember(place, ndrInputStream, n);
            if (placeMember2 == null) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleEventOnSubscribedMember", "Places: Type mismatch on add member");
                }
                return;
            }
            this.memberAdded(place, placeMember2);
        } else if (s == 1) {
            Integer n2;
            try {
                n2 = new Integer(ndrInputStream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            PlaceMember placeMember3 = place.removeMember(n2);
            if (placeMember3 == null) {
                return;
            }
            PlacesEvent placesEvent = null;
            if (placeMember3 instanceof UserInPlace) {
                UserInPlace userInPlace = (UserInPlace)placeMember3;
                placesEvent = new SectionEvent((Object)((Section)placeMember), -2147483646, userInPlace);
            } else if (placeMember3 instanceof Section) {
                placesEvent = new PlaceEvent((Object)place, -2147483638, (Section)placeMember3);
            } else if (placeMember3 instanceof Activity) {
                placesEvent = new PlaceEvent((Object)place, -2147483640, (Activity)placeMember3);
            } else {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleEventOnSubscribedMember", "Places: Unknown member on delete member");
                }
                return;
            }
            placeMember.processPlacesEvent(placesEvent);
        } else if (s == 4) {
            STExtendedAttribute sTExtendedAttribute;
            try {
                sTExtendedAttribute = new STExtendedAttribute(ndrInputStream);
                Integer n3 = new Integer(ndrInputStream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483647, sTExtendedAttribute);
            placeMember.processPlacesEvent(placeMemberEvent);
        } else if (s == 3) {
            int n4;
            try {
                n4 = ndrInputStream.readInt();
                Integer n5 = new Integer(ndrInputStream.readInt());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)placeMember, -2147483646, n4);
            placeMember.processPlacesEvent(placeMemberEvent);
        }
    }

    private PlaceMember loadMember(Place place, NdrInputStream ndrInputStream, Integer n) {
        PlaceMember placeMember = null;
        try {
            ndrInputStream.loadMark();
            Integer n2 = new Integer(ndrInputStream.readInt());
            short s = ndrInputStream.readShort();
            switch (s) {
                case 3: {
                    STId sTId = new STId(ndrInputStream);
                    STLoginId sTLoginId = new STLoginId(ndrInputStream.readUTF(), sTId.getCommunityName());
                    String string = ndrInputStream.readUTF();
                    short s2 = ndrInputStream.readShort();
                    int n3 = ndrInputStream.readInt();
                    Integer n4 = place.getChannel().getProtocolVersion() >= 5 ? new Integer(ndrInputStream.readInt()) : n;
                    Section section = (Section)place.getMember(n4);
                    MyselfInPlace myselfInPlace = place.getMyselfInPlace();
                    if (n2.equals(myselfInPlace.getMemberId())) {
                        myselfInPlace.m_section = section;
                        placeMember = myselfInPlace;
                        break;
                    }
                    placeMember = new UserInPlace(this.getSession(), n2, place, section, sTId, string, sTLoginId, s2, n3);
                    break;
                }
                case 4: {
                    int n5 = ndrInputStream.readInt();
                    byte[] byArray = ndrInputStream.readBytes();
                    Integer n6 = new Integer(ndrInputStream.readInt());
                    boolean bl = ndrInputStream.readBoolean();
                    Integer n7 = place.getMyselfInPlace().getMemberId();
                    boolean bl2 = n7.equals(n6);
                    placeMember = new Activity(this.getSession(), place, n2, n5, byArray, bl2, bl);
                    break;
                }
                case 2: {
                    int n8 = ndrInputStream.readInt();
                    Section section = place.getMySection();
                    if (n2.equals(section.getMemberId())) {
                        placeMember = section;
                        break;
                    }
                    placeMember = new Section(this.getSession(), place, n2, n8);
                    break;
                }
                case 1: {
                    String string = ndrInputStream.readUTF();
                    boolean bl = ndrInputStream.readBoolean();
                    boolean bl3 = ndrInputStream.readBoolean();
                    int n9 = ndrInputStream.readInt();
                    String string2 = ndrInputStream.readUTF();
                    PlaceEvent placeEvent = new PlaceEvent(place, -2147483647, string, place.getMySection(), place.getEncLevel(), bl3, bl, n9, string2);
                    place.processPlacesEvent(placeEvent);
                }
            }
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        if (placeMember != null) {
            place.addMember(placeMember);
        }
        return placeMember;
    }

    private void memberAdded(Place place, PlaceMember placeMember) {
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "memberAdded", "Places: OnAddMember with a null member.");
            }
            return;
        }
        if (placeMember instanceof UserInPlace) {
            UserInPlace userInPlace = (UserInPlace)placeMember;
            UserInPlace[] userInPlaceArray = new UserInPlace[]{userInPlace};
            Section section = userInPlace.getSection();
            SectionEvent sectionEvent = new SectionEvent((Object)section, -2147483647, userInPlaceArray);
            section.processPlacesEvent(sectionEvent);
        } else if (placeMember instanceof Activity) {
            Activity activity = (Activity)placeMember;
            place.processPlacesEvent(new PlaceEvent((Object)place, -2147483642, activity));
        } else if (placeMember instanceof Section) {
            place.processPlacesEvent(new PlaceEvent((Object)place, -2147483639, (Section)placeMember));
        }
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() != -2147483614) {
            return;
        }
        this.m_serviceUp = true;
        this.sendEvent(new PlacesServiceEvent(this, -2147483647));
    }

    private Channel createPlacesChannel(Place place) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeUTF(place.getName());
            ndrOutputStream.writeUTF(place.getDisplayName());
            ndrOutputStream.writeInt(place.getPlaceType());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        Channel channel = this.m_cnlService.createChannel(-2147483614, 33, 5, place.getRequestedEncLevel(), ndrOutputStream.toByteArray(), null);
        channel.addChannelListener(this);
        channel.open();
        return channel;
    }

    private Place getPlace(Integer n) {
        Place place = null;
        Hashtable hashtable = (Hashtable)this.m_places.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            place = (Place)enumeration.nextElement();
            if (!place.getPlaceId().equals(n)) continue;
            return place;
        }
        return null;
    }

    private int getScope(Place place, Integer n) {
        if (n == 0) {
            return 3;
        }
        PlaceMember placeMember = place.getMember(n);
        if (placeMember == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getScope", "Places: Got a message to an unknown destination");
            }
            return -1;
        }
        if (placeMember instanceof Section) {
            return 2;
        }
        if (placeMember instanceof UserInPlace) {
            return 1;
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "getScope", "Places: can't get the message scope.");
        }
        return -1;
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof PlacesEvent) {
            this.processPlacesEvent((PlacesEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof PlaceEvent) {
            this.processPlaceEvent((PlaceEvent)placesEvent);
        } else if (placesEvent instanceof PlaceMemberEvent) {
            this.processPlaceMemberEvent((PlaceMemberEvent)placesEvent);
        } else if (placesEvent instanceof SectionEvent) {
            this.processSectionEvent((SectionEvent)placesEvent);
        } else if (placesEvent instanceof MyselfEvent) {
            this.processMyselfEvent((MyselfEvent)placesEvent);
        }
    }

    protected void processPlaceEvent(PlaceEvent placeEvent) {
        switch (placeEvent.getId()) {
            case 1: {
                this.enterPlace((Place)placeEvent.getSource());
                placeEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.leavePlace(placeEvent.getPlaceId(), placeEvent.getReason());
                placeEvent.setConsumed(true);
                break;
            }
            case 4: {
                this.addActivity(placeEvent.getPlaceId(), placeEvent.getType(), placeEvent.getData());
                placeEvent.setConsumed(true);
                break;
            }
            case 5: {
                this.invite15Client(placeEvent.getPlaceId(), placeEvent.getUser(), placeEvent.getInviteText(), placeEvent.getAutoInvite());
                placeEvent.setConsumed(true);
                break;
            }
            case 6: {
                this.addAllowedUsers(placeEvent.getPlaceId(), new Integer(0), placeEvent.getAllowedUsers());
                placeEvent.setConsumed(true);
                break;
            }
            case 7: {
                this.removeAllowedUsers(placeEvent.getPlaceId(), new Integer(0), placeEvent.getAllowedUsers());
                placeEvent.setConsumed(true);
                break;
            }
            case 8: {
                this.setMyIdInActivity(placeEvent.getPlaceId(), placeEvent.getActivityId(), placeEvent.getIdInActivity());
                placeEvent.setConsumed(true);
            }
        }
    }

    protected void processPlaceMemberEvent(PlaceMemberEvent placeMemberEvent) {
        switch (placeMemberEvent.getId()) {
            case 1: {
                this.subscribeOnMember(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.unsubscribeOnMember(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 5: {
                this.setAttribute(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId(), placeMemberEvent.getAttribute());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 6: {
                this.removeAttribute(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId(), placeMemberEvent.getAttributeKey());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 3: {
                this.sendText(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId(), placeMemberEvent.getText());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 4: {
                this.sendData(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId(), placeMemberEvent.getType(), placeMemberEvent.getData());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 7: {
                this.getAttributeContent(placeMemberEvent.getPlaceId(), placeMemberEvent.getMemberId(), placeMemberEvent.getAttributeKey());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case 8: {
                PlaceMember placeMember = placeMemberEvent.getMember();
                PlaceMemberEvent placeMemberEvent2 = new PlaceMemberEvent(placeMember, -2147483638, placeMemberEvent.getListener());
                placeMember.processPlacesEvent(placeMemberEvent2);
                placeMemberEvent.setConsumed(true);
            }
        }
    }

    protected void processSectionEvent(SectionEvent sectionEvent) {
        switch (sectionEvent.getId()) {
            case 1: {
                this.addAllowedUsers(sectionEvent.getPlaceId(), sectionEvent.getSectionId(), sectionEvent.getAllowedUsers());
                sectionEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.removeAllowedUsers(sectionEvent.getPlaceId(), sectionEvent.getSectionId(), sectionEvent.getAllowedUsers());
                sectionEvent.setConsumed(true);
            }
        }
    }

    protected void processMyselfEvent(MyselfEvent myselfEvent) {
        switch (myselfEvent.getId()) {
            case 1: {
                this.changeSection(myselfEvent.getPlaceId(), myselfEvent.getSectionId());
                myselfEvent.setConsumed(true);
            }
        }
    }
}

