/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.gdk.tooltip.STToolTip;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.EmptyNode;
import com.lotus.sametime.guiutils.tree.McListView;
import com.lotus.sametime.guiutils.tree.McTitleView;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TooltipProvider;
import com.lotus.sametime.guiutils.tree.TreeModelListener;
import com.lotus.sametime.guiutils.tree.TreeModelMethods;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.guiutils.tree.ViewListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;

public class TreeView
extends Panel
implements TreeModelListener,
AdjustmentListener,
FocusListener,
MouseListener,
KeyListener,
ComponentListener,
ImageObserver,
STToolTip {
    public static final short TREE_MODE = 0;
    public static final short LIST_MODE = 1;
    protected static int ITEM_HEIGHT = 16;
    protected static short ICON_WIDTH = (short)16;
    private short PADDING = (short)3;
    private short LEVELS_GAP = (short)20;
    protected static final int SCROLLBARS_WIDTH = 15;
    private static final long DCLICK_INTERVAL = 350L;
    private int m_bounds = 2;
    protected int m_minNameWidth = 150;
    protected int m_nameWidth;
    private Scrollbar m_Hscrollbar;
    private Scrollbar m_Vscrollbar;
    private Image m_offscreen;
    private int m_first = 0;
    protected int m_HorizontalOffset = 0;
    private boolean m_clearOffscreen = true;
    private boolean m_clearBackground = true;
    private Dimension m_size = new Dimension();
    private boolean m_focus = false;
    private boolean m_firstPainted = true;
    private long m_lastClicked = 0L;
    private Point m_clicked = new Point(0, 0);
    private Vector m_items = new Vector();
    protected TreeNode m_lastSelection;
    private TreeModelMethods m_model;
    private boolean m_singleSelection = false;
    private boolean m_treeMode = true;
    private Vector m_listeners = new Vector();
    private boolean m_border = false;
    private boolean m_singleColumn = true;
    private int m_nbOfLeftColumns = 0;
    private int m_nbOfRightColumns = 0;
    protected McListView m_mcListView;
    private TooltipProvider m_tooltipProvider;

    public TreeView(TreeModelMethods treeModelMethods, short s, boolean bl) {
        this.setLayout(null);
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.window);
        }
        this.m_model = treeModelMethods;
        this.m_nameWidth = this.m_minNameWidth;
        this.m_border = bl;
        if (s == 1) {
            this.m_treeMode = false;
        }
        this.m_Vscrollbar = new Scrollbar(1);
        this.m_Vscrollbar.setUnitIncrement(1);
        this.m_Vscrollbar.setBackground(Color.lightGray);
        this.add(this.m_Vscrollbar);
        this.m_Vscrollbar.setVisible(false);
        this.m_Hscrollbar = new Scrollbar(0);
        this.m_Hscrollbar.setUnitIncrement(1);
        this.m_Hscrollbar.setBlockIncrement(1);
        this.m_Hscrollbar.setBackground(Color.lightGray);
        this.add(this.m_Hscrollbar);
        this.m_Hscrollbar.setVisible(false);
        this.m_Vscrollbar.addAdjustmentListener(this);
        this.m_Hscrollbar.addAdjustmentListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
    }

    public TreeView(McListView mcListView, TreeModelMethods treeModelMethods) {
        this(treeModelMethods, 1, false);
        this.m_mcListView = mcListView;
        this.m_nbOfLeftColumns = mcListView.getNbOfLeftColumns();
        this.m_nbOfRightColumns = mcListView.getNbOfRightColumns();
        this.m_singleColumn = false;
        this.m_bounds = 0;
        this.m_mcListView.setTreeView(this);
        this.m_mcListView.add((Component)this, "Center");
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addTreeView(Container container) {
        if (this.m_mcListView == null) {
            container.add(this);
        } else {
            container.add(this.m_mcListView);
        }
    }

    public void addColumn(int n) {
        if (n > 0) {
            ++this.m_nbOfRightColumns;
        } else {
            ++this.m_nbOfLeftColumns;
        }
    }

    public void addViewListener(ViewListener viewListener) {
        this.m_listeners.addElement(viewListener);
    }

    public void removeViewListener(ViewListener viewListener) {
        this.m_listeners.removeElement(viewListener);
    }

    public Vector getSelectedNodes() {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        Enumeration enumeration = this.m_items.elements();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.isSelected() || treeNode instanceof EmptyNode) continue;
            vector.addElement(treeNode);
        }
        return vector;
    }

    private void setScrollbars() {
        int n;
        boolean bl = this.isHorizontalScrollbarNeeded();
        boolean bl2 = this.isVerticalScrollbarNeeded();
        Rectangle rectangle = this.m_border ? this.getInnerBounds() : this.getBounds();
        int n2 = bl2 ? rectangle.width - 15 : rectangle.width;
        int n3 = n = bl ? rectangle.height - 15 : rectangle.height;
        if (bl2) {
            if (n2 > 0) {
                this.m_Vscrollbar.setBounds(rectangle.width - 15, this.m_bounds, 15, n);
            }
            this.setVerticalScrollbar(bl);
            this.m_Vscrollbar.setVisible(true);
        } else {
            this.m_Vscrollbar.setVisible(false);
            this.m_Vscrollbar.setValue(0);
            this.m_first = 0;
        }
        if (bl) {
            if (n > 0) {
                this.m_Hscrollbar.setBounds(this.m_bounds, rectangle.height - 15, n2, 15);
            }
            this.setHorizontalScrollbar(bl2);
            this.m_Hscrollbar.setVisible(true);
        } else {
            this.m_Hscrollbar.setVisible(false);
            this.m_Hscrollbar.setValue(0);
            this.m_HorizontalOffset = 0;
        }
    }

    private boolean isHorizontalScrollbarNeeded() {
        Rectangle rectangle = this.getInnerBounds();
        return this.m_size.width > rectangle.width || this.m_size.height > rectangle.height - 15 && this.m_size.width > rectangle.width - 15;
    }

    private boolean isVerticalScrollbarNeeded() {
        Rectangle rectangle = this.getInnerBounds();
        return this.m_size.height > rectangle.height || this.m_size.width > rectangle.width - 15 && this.m_size.height > rectangle.height - 15;
    }

    private void setHorizontalScrollbar(boolean bl) {
        Rectangle rectangle = this.getInnerBounds();
        int n = rectangle.width;
        if (bl) {
            n -= 15;
        }
        int n2 = Math.min(this.m_Hscrollbar.getValue(), this.m_Hscrollbar.getMaximum() - 1);
        int n3 = Math.max(2, this.m_size.width - n);
        this.m_Hscrollbar.setValues(n2, 1, 0, n3);
        this.m_HorizontalOffset = -this.m_Hscrollbar.getValue();
    }

    private void setVerticalScrollbar(boolean bl) {
        int n = bl ? this.getInnerBounds().height - 15 : this.getInnerBounds().height;
        int n2 = n / ITEM_HEIGHT;
        int n3 = Math.min(this.m_first, this.m_items.size() - n2);
        this.m_Vscrollbar.setValues(n3, 1, 0, this.m_items.size() - n2 + 1);
        this.m_Vscrollbar.setBlockIncrement(n2 - 1);
        this.m_first = this.m_Vscrollbar.getValue();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void createImage() {
        Rectangle rectangle = this.getInnerBounds();
        int n = this.isHorizontalScrollbarNeeded() ? rectangle.height - 15 : rectangle.height;
        n = Math.max(1, n);
        int n2 = Math.max(this.m_size.width, rectangle.width);
        n2 = Math.max(1, n2);
        Image image = this.m_offscreen;
        this.m_offscreen = this.createImage(n2, n);
        this.refreshOffscreen();
        if (null != image) {
            image.flush();
        }
    }

    private void setVirtualSize() {
        this.m_clearOffscreen = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.m_singleColumn) {
            Enumeration enumeration = this.m_items.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                FontMetrics fontMetrics = this.getFontMetrics(treeNode.getFont());
                n3 += ITEM_HEIGHT;
                n = fontMetrics.stringWidth(treeNode.m_value) + 2 * this.PADDING + ICON_WIDTH;
                n2 = Math.max(n += this.m_treeMode ? treeNode.getLevel() * this.LEVELS_GAP : 0, n2);
            }
        } else {
            n2 = this.m_nameWidth + this.m_mcListView.getAllColumnsWidth();
            n3 = this.m_items.size() * ITEM_HEIGHT;
        }
        this.m_size = new Dimension(n2, n3);
        this.createImage();
        this.setScrollbars();
    }

    private void refreshOffscreen() {
        if (this.m_singleColumn) {
            this.singleColOffscreen();
        } else {
            this.multiColOffscreen();
        }
    }

    private void multiColOffscreen() {
        if (this.m_offscreen == null) {
            return;
        }
        this.setBackground(SystemColor.window);
        Rectangle rectangle = this.getBounds();
        int n = rectangle.height;
        if (this.isHorizontalScrollbarNeeded()) {
            n -= 15;
        }
        Graphics graphics = this.m_offscreen.getGraphics();
        graphics.setClip(0, 0, Math.max(this.m_size.width, rectangle.width), n);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, Math.max(this.m_size.width, rectangle.width), n);
        Vector vector = (Vector)this.m_items.clone();
        boolean bl = this.m_focus;
        Rectangle rectangle2 = new Rectangle();
        int n2 = this.m_first;
        McTitleView mcTitleView = this.m_mcListView.getTitleView();
        Vector vector2 = mcTitleView.getLeftTitles();
        Vector vector3 = mcTitleView.getRightTitles();
        for (int i = 0; n2 < vector.size() && i < n; i += ITEM_HEIGHT, ++n2) {
            int n3;
            CellData cellData;
            ColumnAttributes columnAttributes;
            int n4;
            TreeNode treeNode = (TreeNode)vector.elementAt(n2);
            FontMetrics fontMetrics = this.getFontMetrics(treeNode.getFont());
            ITEM_HEIGHT = ITEM_HEIGHT > fontMetrics.getHeight() ? ITEM_HEIGHT : fontMetrics.getHeight();
            treeNode.setArea(0, i, this.m_size.width, ITEM_HEIGHT);
            if (!bl && treeNode.isSelected()) {
                graphics.setColor(treeNode.getForeground());
            } else {
                graphics.setColor(treeNode.getBackground());
            }
            graphics.fillRect(treeNode.m_area.x, treeNode.m_area.y, treeNode.m_area.width, treeNode.m_area.height);
            if (!bl && treeNode.isSelected()) {
                graphics.setColor(treeNode.getBackground());
                graphics.drawRect(treeNode.m_area.x, treeNode.m_area.y, treeNode.m_area.width - 1, treeNode.m_area.height - 1);
            }
            int n5 = 0;
            if (!bl && treeNode.isSelected()) {
                graphics.setColor(treeNode.getBackground());
            } else {
                graphics.setColor(treeNode.getForeground());
            }
            graphics.setFont(treeNode.getFont());
            if (this.m_nbOfLeftColumns > 0) {
                for (n4 = 0; n4 < this.m_nbOfLeftColumns; ++n4) {
                    rectangle2.setLocation(n5, i);
                    columnAttributes = (ColumnAttributes)vector2.elementAt(n4);
                    n5 += columnAttributes.getWidth();
                    rectangle2.setSize(columnAttributes.getWidth(), ITEM_HEIGHT);
                    cellData = (CellData)treeNode.m_leftData.elementAt(n4);
                    cellData.drawData(graphics, this, rectangle2);
                }
            }
            if (treeNode.m_icon != null) {
                n4 = (ITEM_HEIGHT - treeNode.m_icon.getHeight(this)) / 2;
                n3 = (ICON_WIDTH - treeNode.m_icon.getWidth(this)) / 2;
                graphics.drawImage(treeNode.m_icon, n5 + n3, i + n4, this);
            }
            String string = treeNode.m_value;
            n3 = ICON_WIDTH + this.PADDING;
            graphics.drawString(this.truncateName(this.m_nameWidth - n3, string, fontMetrics), n5 + n3, i + fontMetrics.getAscent());
            n5 += this.m_nameWidth;
            if (this.m_nbOfRightColumns <= 0) continue;
            for (int j = 0; j < this.m_nbOfRightColumns; ++j) {
                rectangle2.setLocation(n5, i);
                columnAttributes = (ColumnAttributes)vector3.elementAt(j);
                rectangle2.setSize(columnAttributes.getWidth(), ITEM_HEIGHT);
                cellData = (CellData)treeNode.m_rightData.elementAt(j);
                cellData.drawData(graphics, this, rectangle2);
                n5 += columnAttributes.getWidth();
            }
        }
    }

    public String truncateName(int n, String string, FontMetrics fontMetrics) {
        if (fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        while (fontMetrics.stringWidth((string = string.substring(0, string.length() - 1)) + "..") > n) {
        }
        return string + "..";
    }

    private void singleColOffscreen() {
        int n;
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.window);
        }
        if (this.m_offscreen == null) {
            return;
        }
        int n2 = this.isHorizontalScrollbarNeeded() ? this.getInnerBounds().height - 15 : this.getInnerBounds().height;
        Rectangle rectangle = this.getInnerBounds();
        Graphics graphics = this.m_offscreen.getGraphics();
        graphics.setClip(0, 0, Math.max(this.m_size.width, rectangle.width), n2);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, Math.max(this.m_size.width, rectangle.width), n2);
        int n3 = this.m_first;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        Vector vector = (Vector)this.m_items.clone();
        boolean bl2 = this.m_focus;
        if (this.m_treeMode) {
            for (n = vector.size() - 1; n >= 0; --n) {
                if (((TreeNode)vector.elementAt(n)).getLevel() != 1) continue;
                n5 = n;
                break;
            }
        }
        while (n3 < vector.size() && n4 < n2) {
            int n6;
            int n7;
            int n8;
            TreeNode treeNode = (TreeNode)vector.elementAt(n3);
            FontMetrics fontMetrics = this.getFontMetrics(treeNode.getFont());
            int n9 = ITEM_HEIGHT = ITEM_HEIGHT > fontMetrics.getHeight() ? ITEM_HEIGHT : fontMetrics.getHeight();
            if (n3 >= n5) {
                bl = true;
            }
            int n10 = n8 = fontMetrics.stringWidth(treeNode.m_value) + 2 * this.PADDING;
            int n11 = n7 = this.m_treeMode ? treeNode.getLevel() * this.LEVELS_GAP : 5;
            graphics.setColor(this.getBackground());
            graphics.fillRect(n7, n4, ICON_WIDTH, ICON_WIDTH);
            n11 += ICON_WIDTH;
            n10 += ICON_WIDTH;
            if (treeNode.m_icon != null) {
                n = (ITEM_HEIGHT - treeNode.m_icon.getHeight(this)) / 2;
                n6 = (ICON_WIDTH - treeNode.m_icon.getWidth(this)) / 2;
                graphics.drawImage(treeNode.m_icon, n7 + n6, n4 + n, this);
            }
            treeNode.setArea(n7, n4, n10, ITEM_HEIGHT);
            if (this.m_treeMode) {
                if (treeNode.getLevel() == 1) {
                    treeNode.setArea(0, n4, n10 += ICON_WIDTH, ITEM_HEIGHT);
                    if (vector.lastElement() != treeNode && ((TreeNode)vector.elementAt(n3 + 1)).getLevel() == 1) {
                        graphics.setColor(Color.gray);
                        for (n = 0; n <= 4; n += 2) {
                            graphics.drawLine(7, n4 + 13 + n, 7, n4 + 13 + n);
                        }
                    }
                    graphics.setColor(Color.gray);
                    graphics.drawRect(3, n4 + 3, 8, 8);
                    graphics.drawLine(13, n4 + 7, 13, n4 + 7);
                    graphics.drawLine(15, n4 + 7, 15, n4 + 7);
                    graphics.drawLine(17, n4 + 7, 17, n4 + 7);
                    graphics.setColor(Color.black);
                    graphics.drawLine(5, n4 + 7, 9, n4 + 7);
                    if (!treeNode.isExpanded()) {
                        graphics.drawLine(7, n4 + 9, 7, n4 + 5);
                    }
                } else {
                    graphics.setColor(Color.gray);
                    n = ITEM_HEIGHT - 5;
                    if (vector.lastElement() != treeNode && ((TreeNode)vector.elementAt(n3 + 1)).getLevel() != 1) {
                        n = ITEM_HEIGHT;
                    }
                    for (n6 = 0; n6 < n; n6 += 2) {
                        graphics.drawLine((int)(1.5 * (double)ITEM_HEIGHT), n4 + n6, (int)(1.5 * (double)ITEM_HEIGHT), n4 + n6);
                    }
                    for (n6 = 0; n6 < ITEM_HEIGHT / 2; n6 += 2) {
                        graphics.drawLine((int)(1.5 * (double)ITEM_HEIGHT) + n6, n4 + 10, (int)(1.5 * (double)ITEM_HEIGHT) + n6, n4 + 10);
                    }
                    if (!bl) {
                        graphics.setColor(Color.gray);
                        graphics.drawLine(7, n4 + 14, 7, n4 + 14);
                        for (n6 = 0; n6 <= ITEM_HEIGHT; n6 += 2) {
                            graphics.drawLine(7, n4 + n6, 7, n4 + n6);
                        }
                    }
                }
            }
            if (!bl2 && treeNode.isSelected()) {
                graphics.setColor(treeNode.getForeground());
            } else {
                graphics.setColor(treeNode.getBackground());
            }
            graphics.fillRect(n11, n4, n8, ITEM_HEIGHT);
            if (!bl2 && treeNode.isSelected()) {
                graphics.setColor(treeNode.getBackground());
                graphics.drawRect(n11, n4, n8 - 1, ITEM_HEIGHT - 1);
            }
            if (!bl2 && treeNode.isSelected()) {
                graphics.setColor(treeNode.getBackground());
            } else {
                graphics.setColor(treeNode.getForeground());
            }
            graphics.setFont(treeNode.getFont());
            graphics.drawString(treeNode.m_value, n11 + this.PADDING, n4 + fontMetrics.getAscent());
            n4 += ITEM_HEIGHT;
            ++n3;
        }
    }

    public Dimension getMinimumSize() {
        int n;
        Dimension dimension = new Dimension();
        int n2 = 5 * ITEM_HEIGHT;
        if (this.m_singleColumn) {
            n = 30 + this.m_minNameWidth;
        } else {
            Dimension dimension2 = this.m_mcListView.getMinimumSize();
            n = dimension2.width - 2 * this.m_mcListView.getBorderSize();
        }
        dimension.setSize(n, n2);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getInnerBounds();
        if (this.m_border) {
            this.paintBorders(graphics);
            graphics.setClip(this.m_bounds, this.m_bounds, rectangle.width - this.m_bounds, rectangle.height - this.m_bounds);
        }
        if (this.m_clearBackground || this.m_items.isEmpty()) {
            graphics.clearRect(0, 0, rectangle.width, rectangle.height);
            this.m_clearBackground = false;
        }
        if (!this.m_items.isEmpty() && this.m_offscreen != null) {
            this.refreshOffscreen();
            graphics.drawImage(this.m_offscreen, this.m_HorizontalOffset, this.m_bounds, this);
        }
        if (this.m_Vscrollbar.isVisible() && this.m_Hscrollbar.isVisible()) {
            graphics.setColor(this.m_Vscrollbar.getBackground());
            graphics.fillRect(rectangle.width - 15, rectangle.height - 15, 15, 15);
        }
    }

    private Rectangle getInnerBounds() {
        Rectangle rectangle = this.getBounds();
        if (this.m_bounds != 0) {
            return new Rectangle(this.m_bounds, this.m_bounds, rectangle.width - this.m_bounds, rectangle.height - this.m_bounds);
        }
        return rectangle;
    }

    private void paintBorders(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, rectangle.width - 2, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(0, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    public void resetSelection() {
        if (!this.m_items.isEmpty()) {
            Enumeration enumeration = this.m_items.elements();
            while (enumeration.hasMoreElements()) {
                ((TreeNode)enumeration.nextElement()).setSelected(false);
            }
            this.m_lastSelection = (TreeNode)this.m_items.firstElement();
            this.m_lastSelection.setSelected(true);
            this.notifySelectionChanged();
            this.repaint();
        }
    }

    public TreeNode getNodeAtPoint(Point point) {
        Rectangle rectangle = this.getInnerBounds();
        rectangle.height = rectangle.height - (this.m_Vscrollbar.isShowing() ? 15 : 0);
        int n = 0;
        TreeNode treeNode = null;
        TreeNode treeNode2 = null;
        for (int i = this.m_first; i < this.m_items.size() && n < rectangle.height; n += ITEM_HEIGHT, ++i) {
            treeNode = (TreeNode)this.m_items.elementAt(i);
            if (!treeNode.contains(point)) continue;
            if (treeNode instanceof EmptyNode) break;
            treeNode2 = treeNode;
            break;
        }
        return treeNode2;
    }

    protected void nodeClicked(TreeNode treeNode, MouseEvent mouseEvent) {
        boolean bl = true;
        if (mouseEvent.isControlDown()) {
            boolean bl2 = bl = !treeNode.isSelected();
        }
        if (!(mouseEvent.isMetaDown() && treeNode.isSelected() || !this.m_singleSelection && (this.m_singleSelection || mouseEvent.isControlDown()))) {
            Enumeration enumeration = this.m_items.elements();
            while (enumeration.hasMoreElements()) {
                ((TreeNode)enumeration.nextElement()).setSelected(false);
            }
        }
        if (!this.m_singleSelection && mouseEvent.isShiftDown()) {
            int n = this.m_items.indexOf(this.m_lastSelection);
            int n2 = this.m_items.indexOf(treeNode);
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            for (int i = n3; i <= n4; ++i) {
                TreeNode treeNode2 = (TreeNode)this.m_items.elementAt(i);
                treeNode2.setSelected(true);
            }
        }
        this.m_lastSelection = treeNode;
        this.m_lastSelection.setSelected(bl);
        this.notifySelectionChanged();
        this.repaint();
    }

    protected void nodeDoubleClicked(TreeNode treeNode) {
        Enumeration enumeration = this.m_items.elements();
        while (enumeration.hasMoreElements()) {
            ((TreeNode)enumeration.nextElement()).setSelected(false);
        }
        treeNode.setSelected(true);
        this.m_lastSelection = treeNode;
        this.notifySelectionChanged();
        if (!(treeNode instanceof EmptyNode)) {
            if (treeNode.getLevel() == 1 && this.m_treeMode) {
                treeNode.setExpanded(!treeNode.isExpanded());
                if (treeNode.isExpanded()) {
                    this.nodeExpanded(treeNode);
                } else {
                    this.nodeCollapsed(treeNode);
                }
            }
            this.notifyNodeDoubleClicked(treeNode);
        }
        this.repaint();
    }

    private void notifyPopupMenuRequest(MouseEvent mouseEvent, Vector vector) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.popupMenuRequest(mouseEvent, vector);
        }
    }

    private void notifyNodeDoubleClicked(TreeNode treeNode) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.nodeDoubleClicked(treeNode);
        }
    }

    private void notifyDeletePressed(Vector vector) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.deletePressed(vector);
        }
    }

    private void notifySelectionChanged() {
        Vector vector = this.getSelectedNodes();
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.selectionChanged(vector);
        }
    }

    private void notifyNodeExpanded(TreeNode treeNode) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.nodeExpanded(treeNode);
        }
    }

    private void notifyNodeCollapsed(TreeNode treeNode) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ViewListener viewListener = (ViewListener)enumeration.nextElement();
            viewListener.nodeCollapsed(treeNode);
        }
    }

    public void insertEmptyNode(TreeNode treeNode, EmptyNode emptyNode) {
        this.m_model.insertEmptyNode(treeNode, emptyNode);
        int n = this.m_items.indexOf(treeNode);
        this.m_items.ensureCapacity(n + 2);
        this.m_items.insertElementAt(emptyNode, n + 1);
    }

    private void removeEmptyNode(TreeNode treeNode) {
        int n = this.m_items.indexOf(treeNode);
        if (this.m_items.lastElement() != treeNode && this.m_items.elementAt(n + 1) instanceof EmptyNode) {
            this.m_items.removeElementAt(n + 1);
        }
    }

    public void nodeExpanded(TreeNode treeNode) {
        int n;
        boolean bl = false;
        int n2 = this.m_first + (int)Math.ceil((double)this.getInnerBounds().height / (double)ITEM_HEIGHT) - 1;
        int n3 = this.m_items.indexOf(treeNode) + 1;
        if (n3 - 1 <= n2) {
            bl = true;
        }
        if ((n = this.m_model.getChildCount(treeNode)) > 0) {
            TreeNode treeNode2 = treeNode;
            this.m_items.ensureCapacity(this.m_items.size() + n);
            while (n-- > 0) {
                treeNode2 = this.m_model.getNext(treeNode2);
                treeNode2.setSelected(false);
                this.m_items.insertElementAt(treeNode2, n3++);
            }
        } else {
            this.insertEmptyNode(treeNode, new EmptyNode());
        }
        this.setVirtualSize();
        this.notifySelectionChanged();
        this.notifyNodeExpanded(treeNode);
        if (bl) {
            this.repaint();
        }
    }

    public void nodeCollapsed(TreeNode treeNode) {
        int n;
        boolean bl = false;
        int n2 = this.m_first + (int)Math.ceil((double)this.getInnerBounds().height / (double)ITEM_HEIGHT) - 1;
        int n3 = this.m_items.indexOf(this.m_lastSelection);
        int n4 = this.m_items.indexOf(treeNode);
        if (n4 <= n2) {
            bl = true;
        }
        if ((n = this.m_model.getChildCount(treeNode)) > 0) {
            while (n-- > 0) {
                TreeNode treeNode2 = (TreeNode)this.m_items.elementAt(n4 + 1);
                treeNode2.setSelected(false);
                this.m_items.removeElement(treeNode2);
            }
        } else {
            this.removeEmptyNode(treeNode);
        }
        if (!this.m_items.contains(this.m_lastSelection)) {
            this.m_lastSelection = (TreeNode)this.m_items.elementAt(Math.min(this.m_items.size() - 1, n3));
            this.m_lastSelection.setSelected(true);
        }
        this.setVirtualSize();
        this.notifySelectionChanged();
        this.notifyNodeCollapsed(treeNode);
        if (bl) {
            this.repaint();
        }
    }

    public void nodesInserted(TreeNode[] treeNodeArray, TreeNode[] treeNodeArray2, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            boolean bl2 = this.insertNode(treeNodeArray[i], treeNodeArray2[i], nArray[i]);
            if (!bl2) continue;
            bl = true;
        }
        this.setVirtualSize();
        this.notifySelectionChanged();
        if (bl) {
            this.repaint();
        }
    }

    public void nodesChanged(TreeNode[] treeNodeArray) {
        this.setVirtualSize();
        this.repaint();
        this.notifySelectionChanged();
    }

    public void nodesRemoved(TreeNode[] treeNodeArray) {
        boolean bl = false;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            boolean bl2 = this.removeNode(treeNodeArray[i]);
            if (!bl2) continue;
            bl = true;
        }
        this.setVirtualSize();
        this.notifySelectionChanged();
        if (bl) {
            this.repaint();
        }
    }

    private boolean removeNode(TreeNode treeNode) {
        boolean bl = false;
        int n = this.m_first + (int)Math.ceil((double)this.getInnerBounds().height / (double)ITEM_HEIGHT) - 1;
        int n2 = this.m_items.indexOf(this.m_lastSelection);
        int n3 = this.m_items.indexOf(treeNode);
        if (n3 == -1) {
            return false;
        }
        if (n3 <= n) {
            bl = true;
        }
        if (this.m_treeMode) {
            if (treeNode.getLevel() == 1) {
                if (treeNode.isExpanded()) {
                    int n4 = this.m_model.getChildCount(treeNode);
                    if (n4 > 0) {
                        int n5 = Math.min(this.m_items.size() - 1, this.m_items.indexOf(treeNode) + 1);
                        while (n4-- > 0) {
                            this.m_items.removeElementAt(n5);
                        }
                    } else {
                        this.removeEmptyNode(treeNode);
                    }
                }
            } else {
                TreeNode treeNode2 = (TreeNode)this.m_items.elementAt(n3 - 1);
                if (treeNode2.getLevel() == 1 && this.m_model.getChildCount(treeNode2) == 0) {
                    this.insertEmptyNode(treeNode2, new EmptyNode());
                }
            }
        }
        this.m_items.removeElement(treeNode);
        if (!this.m_items.contains(this.m_lastSelection)) {
            this.m_lastSelection = null;
            if (!this.m_items.isEmpty()) {
                this.m_lastSelection = (TreeNode)this.m_items.elementAt(Math.min(this.m_items.size() - 1, n2));
                this.m_lastSelection.setSelected(true);
            }
        }
        return bl;
    }

    private boolean insertNode(TreeNode treeNode, TreeNode treeNode2, int n) {
        int n2 = this.m_first + (int)Math.ceil((double)this.getInnerBounds().height / (double)ITEM_HEIGHT) - 1;
        if (this.m_treeMode) {
            if (treeNode.getLevel() == 1) {
                ModelNode modelNode;
                int n3 = 0;
                if (n != 0 && this.m_items.contains(modelNode = this.m_model.getChild(treeNode2, n - 1))) {
                    int n4;
                    for (n4 = this.m_items.indexOf(modelNode) + 1; n4 < this.m_items.size() && ((TreeNode)this.m_items.elementAt(n4)).getLevel() != 1; ++n4) {
                    }
                    n3 = n4;
                }
                this.m_items.ensureCapacity(n3 + 1);
                this.m_items.insertElementAt(treeNode, n3);
                if (treeNode.isExpanded()) {
                    this.insertEmptyNode(treeNode, new EmptyNode());
                }
            } else if (treeNode2.isExpanded()) {
                int n5 = this.m_items.indexOf(treeNode2);
                if (this.m_items.lastElement() != treeNode2 && this.m_items.elementAt(n5 + 1) instanceof EmptyNode) {
                    this.removeEmptyNode(treeNode2);
                }
                this.m_items.insertElementAt(treeNode, n5 + n + 1);
            }
        } else {
            if (n == -1) {
                n = this.m_items.size();
            }
            if (n > this.m_items.size()) {
                this.m_items.addElement(treeNode);
            } else {
                this.m_items.ensureCapacity(n + 1);
                this.m_items.insertElementAt(treeNode, n);
            }
        }
        if (this.m_lastSelection == null) {
            this.m_lastSelection = treeNode;
            this.m_lastSelection.setSelected(true);
        }
        return this.m_items.indexOf(treeNode) <= n2;
    }

    protected void insertNodeAtIndex(TreeNode treeNode, int n) {
        boolean bl = this.insertNode(treeNode, null, n);
        this.setVirtualSize();
        this.notifySelectionChanged();
        if (bl) {
            this.repaint();
        }
    }

    public void treeModelInitialized() {
        this.m_items.removeAllElements();
        TreeNode treeNode = this.m_lastSelection;
        this.m_lastSelection = null;
        TreeNode treeNode2 = this.m_model.getRoot();
        if (treeNode2 != null) {
            TreeNode treeNode3 = this.m_model.getNext(treeNode2);
            while (treeNode3 != null) {
                if (treeNode != null && treeNode3.equals(treeNode)) {
                    treeNode3.setSelected(true);
                    this.m_lastSelection = treeNode;
                    treeNode = null;
                } else {
                    treeNode3.setSelected(false);
                }
                this.m_items.addElement(treeNode3);
                if (this.m_treeMode && treeNode3.getLevel() == 1 && treeNode3.isExpanded() && this.m_model.getChildCount(treeNode3) == 0) {
                    this.insertEmptyNode(treeNode3, new EmptyNode());
                }
                treeNode3 = this.m_model.getNext(treeNode3);
            }
            if (!this.m_items.isEmpty() && null == this.m_lastSelection) {
                this.m_lastSelection = (TreeNode)this.m_items.firstElement();
                this.m_lastSelection.setSelected(true);
            }
        }
        this.setVirtualSize();
        this.notifySelectionChanged();
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (adjustmentEvent.getSource() == this.m_Vscrollbar) {
                    this.m_first = this.m_Vscrollbar.getValue();
                    this.m_clearOffscreen = true;
                }
                if (adjustmentEvent.getSource() != this.m_Hscrollbar) break;
                this.m_HorizontalOffset = -this.m_Hscrollbar.getValue();
            }
        }
        this.repaint();
        if (this.m_mcListView != null && adjustmentEvent.getSource() == this.m_Hscrollbar) {
            McTitleView mcTitleView = this.m_mcListView.getTitleView();
            mcTitleView.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_focus) {
            this.m_focus = false;
            this.repaint();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.m_focus) {
            this.m_focus = true;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
        if (!this.m_items.isEmpty()) {
            int n = this.m_Hscrollbar.isShowing() ? this.getInnerBounds().height - 15 : this.getInnerBounds().height;
            int n2 = 0;
            TreeNode treeNode = null;
            Point point = mouseEvent.getPoint();
            Point point2 = new Point(point.x - this.m_HorizontalOffset, point.y);
            for (int i = this.m_first; i < this.m_items.size() && n2 < n; n2 += ITEM_HEIGHT, ++i) {
                TreeNode treeNode2 = (TreeNode)this.m_items.elementAt(i);
                if (!treeNode2.contains(point2)) continue;
                treeNode = treeNode2;
                break;
            }
            if (treeNode != null) {
                Vector vector;
                boolean bl;
                boolean bl2 = false;
                if (!mouseEvent.isMetaDown() && -this.m_lastClicked + mouseEvent.getWhen() <= 350L && Math.abs(mouseEvent.getX() - this.m_clicked.x) < 5 && Math.abs(mouseEvent.getY() - this.m_clicked.y) < 5) {
                    bl2 = true;
                }
                boolean bl3 = bl = this.m_treeMode && point2.x < ICON_WIDTH;
                if (bl2 || treeNode.getLevel() == 1 && bl) {
                    this.nodeDoubleClicked(treeNode);
                } else {
                    this.nodeClicked(treeNode, mouseEvent);
                }
                if (mouseEvent.isMetaDown() && !(vector = this.getSelectedNodes()).isEmpty()) {
                    this.paint(this.getGraphics());
                    this.notifyPopupMenuRequest(mouseEvent, vector);
                }
            } else {
                Enumeration enumeration = this.m_items.elements();
                while (enumeration.hasMoreElements()) {
                    ((TreeNode)enumeration.nextElement()).setSelected(false);
                }
                if (this.m_lastSelection != null) {
                    this.m_lastSelection.setSelected(true);
                }
                this.repaint();
            }
        }
        if (!mouseEvent.isMetaDown()) {
            this.m_lastClicked = mouseEvent.getWhen();
            this.m_clicked.move(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        if (this.m_items.isEmpty()) {
            return;
        }
        int n = this.m_Hscrollbar.isShowing() ? (this.getInnerBounds().height - 15) / ITEM_HEIGHT : this.getInnerBounds().height / ITEM_HEIGHT;
        int n2 = 0;
        if (this.m_lastSelection != null) {
            n2 = this.m_items.indexOf(this.m_lastSelection);
        }
        int n3 = 0;
        int n4 = 0;
        if (this.m_Vscrollbar.isShowing()) {
            n3 = this.m_Vscrollbar.getMaximum();
            n4 = this.m_Vscrollbar.getValue();
            if (n2 < n4 || n2 >= n4 + n) {
                n4 = Math.max(n2 + 1 - n, 0);
            }
        }
        int n5 = 0;
        boolean bl = false;
        switch (keyEvent.getKeyCode()) {
            case 32: {
                if (n2 == this.m_items.size() - 1) {
                    n5 = 0;
                    n4 = 0;
                } else {
                    n5 = Math.min(n2 + 1, this.m_items.size() - 1);
                    if (n5 >= n4 + n) {
                        n4 = Math.min(n4 + 1, n3 - 1);
                    }
                }
                bl = true;
                break;
            }
            case 36: {
                n5 = 0;
                n4 = 0;
                bl = true;
                break;
            }
            case 35: {
                n5 = this.m_items.size() - 1;
                n4 = n3 - 1;
                bl = true;
                break;
            }
            case 38: {
                n5 = Math.max(n2 - 1, 0);
                if (n5 < n4) {
                    n4 = n5;
                }
                bl = true;
                break;
            }
            case 40: {
                n5 = Math.min(n2 + 1, this.m_items.size() - 1);
                if (n5 >= n4 + n) {
                    n4 = Math.min(n4 + 1, n3);
                }
                bl = true;
                break;
            }
            case 37: {
                if (this.m_lastSelection.getLevel() != 1 || !this.m_lastSelection.isExpanded()) break;
                this.nodeDoubleClicked(this.m_lastSelection);
                break;
            }
            case 39: {
                if (this.m_lastSelection.getLevel() != 1 || this.m_lastSelection.isExpanded()) break;
                this.nodeDoubleClicked(this.m_lastSelection);
                break;
            }
            case 33: {
                n5 = Math.max(n2 - n + 1, 0);
                n4 = Math.min(n5, n4);
                bl = true;
                break;
            }
            case 34: {
                n5 = Math.min(n2 + n - 1, this.m_items.size() - 1);
                if (n5 >= n4 + n) {
                    n4 = Math.min(n4 + n - 1, n3 - 1);
                }
                bl = true;
                break;
            }
            case 127: {
                object = this.getSelectedNodes();
                if (((Vector)object).isEmpty()) break;
                this.notifyDeletePressed((Vector)object);
            }
        }
        if (bl) {
            if (!keyEvent.isShiftDown()) {
                object = this.m_items.elements();
                while (object.hasMoreElements()) {
                    ((TreeNode)object.nextElement()).setSelected(false);
                }
            } else {
                int n6 = n5 > n2 ? n2 : n5;
                int n7 = n5 > n2 ? n5 : n2;
                for (int i = n6; i <= n7; ++i) {
                    ((TreeNode)this.m_items.elementAt(i)).setSelected(true);
                }
            }
            if (this.m_Vscrollbar.isShowing()) {
                this.m_Vscrollbar.setValue(n4);
                this.m_first = n4;
            }
            this.m_lastSelection = (TreeNode)this.m_items.elementAt(n5);
            this.m_lastSelection.setSelected(true);
            this.notifySelectionChanged();
            this.m_clearOffscreen = true;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (!this.m_singleColumn) {
            this.setVirtualSize();
        } else {
            this.createImage();
            this.setScrollbars();
        }
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = true;
        if (n == 32) {
            this.repaint();
            bl = false;
        }
        return bl;
    }

    public Vector getToolTipComponents() {
        Vector<TreeView> vector = new Vector<TreeView>();
        vector.addElement(this);
        return vector;
    }

    public void setHoverBased(boolean bl) {
    }

    public boolean isHoverBased() {
        return true;
    }

    public void setToolTipText(Component component, String string) {
    }

    public String getToolTipText(Component component, Point point) {
        TreeNode treeNode = this.getNodeAtPoint(point);
        String string = null;
        if (treeNode != null) {
            string = this.m_tooltipProvider != null ? this.m_tooltipProvider.getTooltipText(treeNode) : treeNode.getDescription();
        }
        return string;
    }

    public void setTooltipProvider(TooltipProvider tooltipProvider) {
        this.m_tooltipProvider = tooltipProvider;
    }

    public McListView getMultiColumnView() {
        return this.m_mcListView;
    }

    public TreeModelMethods getModel() {
        return this.m_model;
    }

    public int getItemHeight() {
        return ITEM_HEIGHT;
    }

    public int getMinNameWidth() {
        return this.m_minNameWidth;
    }

    public void setMinNameWidth(int n) {
        this.m_minNameWidth = n;
    }

    public void enableMultiSelection(boolean bl) {
        this.m_singleSelection = !bl;
    }
}

