/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.misc;

import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.ImagePanel;
import com.lotus.sametime.guiutils.misc.TextPanel;
import com.lotus.sametime.guiutils.misc.UbqDialogListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UbqDialog
extends Dialog
implements WindowListener,
ActionListener {
    private static final short PADDING = 5;
    private Panel m_panel = new Panel(new BorderLayout());
    private TextPanel m_textPanel;
    private Panel m_imagePanel;
    private ButtonsPanel m_buttonsPanel;
    private Checkbox m_checkBox = new Checkbox("", false);
    private Vector m_listeners = new Vector();
    private String LINE_SEPARATOR = "~";
    private int m_pressedButton = -1;
    private String[] m_buttonsLabels;

    public UbqDialog(Frame frame) {
        super(frame);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.add("Center", this.m_panel);
        this.add("South", this.m_checkBox);
    }

    public UbqDialog(Frame frame, String string, String[] stringArray, String[] stringArray2, boolean bl, String string2) {
        this(frame);
        this.resetDialog(string, stringArray, stringArray2, bl, string2);
    }

    public UbqDialog(Frame frame, String string, String[] stringArray, String[] stringArray2) {
        this(frame, string, stringArray, stringArray2, false, "");
    }

    public void resetDialog(String string, String string2, String[] stringArray, boolean bl, String string3) {
        this.setImage(null);
        this.setTitle(string);
        this.setText(this.parseText(string2));
        this.setButtons(stringArray);
        this.setCheckBox(bl, string3);
    }

    public void resetDialog(String string, String[] stringArray, String[] stringArray2, boolean bl, String string2) {
        this.setImage(null);
        this.setTitle(string);
        this.setText(stringArray);
        this.setButtons(stringArray2);
        this.setCheckBox(bl, string2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
    }

    public void setImage(Image image) {
        if (this.m_imagePanel != null) {
            this.m_panel.remove(this.m_imagePanel);
        }
        if (image != null) {
            this.m_imagePanel = new ImagePanel(image, 1, 1);
            this.m_panel.add("West", this.m_imagePanel);
        }
    }

    private void setText(String[] stringArray) {
        if (this.m_textPanel != null) {
            this.m_panel.remove(this.m_textPanel);
        }
        this.m_textPanel = new TextPanel(stringArray);
        this.m_panel.add("Center", this.m_textPanel);
    }

    private void setCheckBox(boolean bl, String string) {
        this.m_checkBox.setLabel(string);
        this.m_checkBox.setState(false);
        this.m_checkBox.setVisible(bl);
    }

    private void setButtons(String[] stringArray) {
        if (this.m_buttonsPanel != null) {
            this.m_panel.remove(this.m_buttonsPanel);
        }
        this.m_buttonsPanel = new ButtonsPanel(stringArray, this);
        this.m_panel.add("South", this.m_buttonsPanel);
        this.m_buttonsLabels = stringArray;
        this.m_pressedButton = -1;
    }

    public int getPressedButton() {
        return this.m_pressedButton;
    }

    public boolean getCheckBoxState() {
        return this.m_checkBox.getState();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.getBounds();
            this.setLocation(dimension.width / 2 - rectangle.width / 2, dimension.height / 2 - rectangle.height / 2);
        }
        super.setVisible(bl);
        if (bl) {
            this.toFront();
        } else {
            this.notifyListenersDialogClosed();
        }
    }

    public void addListener(UbqDialogListener ubqDialogListener) {
        this.m_listeners.addElement(ubqDialogListener);
    }

    public void removeListener(UbqDialogListener ubqDialogListener) {
        this.m_listeners.removeElement(ubqDialogListener);
    }

    private void notifyListenersDialogClosed() {
        int n = this.m_pressedButton;
        boolean bl = this.m_checkBox.getState();
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((UbqDialogListener)enumeration.nextElement()).ubqDialogClosed(this, n, bl);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = (int)((double)this.getFontMetrics(this.getFont()).stringWidth(this.getTitle()) * 1.4);
        if (n > dimension.width) {
            dimension.setSize(n, dimension.height);
        }
        return dimension;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.m_pressedButton = -1;
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.m_pressedButton = -1;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    private String[] parseText(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.LINE_SEPARATOR);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.m_buttonsLabels.length; ++i) {
            if (!actionEvent.getActionCommand().equals(this.m_buttonsLabels[i])) continue;
            this.m_pressedButton = i;
            break;
        }
        this.setVisible(false);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                Component component = UbqDialog.this.getFocusOwner();
                if (component != null && component instanceof Button) {
                    Button button = (Button)component;
                    for (int i = 0; i < UbqDialog.this.m_buttonsLabels.length; ++i) {
                        if (!button.getLabel().equals(UbqDialog.this.m_buttonsLabels[i])) continue;
                        UbqDialog.this.m_pressedButton = i;
                        break;
                    }
                    UbqDialog.this.setVisible(false);
                }
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                UbqDialog.this.setVisible(false);
            }
        });
        return new KeyHandler(vector);
    }
}

