/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.directory;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.directory.Directory;
import com.lotus.sametime.directory.DirectoryEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryImpl
extends STCompPart
implements ChannelListener,
ServiceListener,
LoginListener {
    public static final short GET_DIRECTORIES = 0;
    public static final short OPEN_DIRECTORY = 1;
    public static final short CLOSE_DIRECTORY = 2;
    public static final short GET_ENTRIES = 3;
    public static final int NEXT_CHUNK = 0;
    public static final int PREVIOUS_CHUNK = 1;
    public static final int START_WITH_STRING = 8;
    public static final int AT_FIRST_CHUNK = 2;
    public static final int AT_LAST_CHUNK = 4;
    public static final int ENTRY_TYPE_USER = 0;
    public static final int ENTRY_TYPE_GROUP = 1;
    private ChannelService m_channelService;
    private Channel m_channel = null;
    private Vector m_pendingEvents = new Vector();
    private Hashtable m_unansweredRequests = new Hashtable();
    private Hashtable m_openDirs = new Hashtable();
    private CommunityService m_comm;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.directory");

    public DirectoryImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.directory.DirectoryComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
        Debug.stAssert(this.m_channelService != null);
        this.m_comm.addServiceListener(this);
        this.m_comm.addLoginListener(this);
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
        this.m_comm.removeServiceListener(this);
        this.m_comm.removeLoginListener(this);
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_channelService && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
        }
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof DirectoryEvent) {
            this.processDirectoryEvent((DirectoryEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processDirectoryEvent(DirectoryEvent directoryEvent) {
        switch (directoryEvent.getId()) {
            case 0: {
                this.getDirectories(directoryEvent);
                directoryEvent.setConsumed(true);
                break;
            }
            case 1: {
                this.openDirectory(directoryEvent);
                directoryEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.closeDirectory(directoryEvent);
                directoryEvent.setConsumed(true);
                break;
            }
            case 3: {
                this.getEntries(directoryEvent);
                directoryEvent.setConsumed(true);
                break;
            }
            case 5: {
                this.getEntriesStartWith(directoryEvent);
                directoryEvent.setConsumed(true);
            }
        }
    }

    private void getDirectories(DirectoryEvent directoryEvent) {
        if (null == this.m_channel) {
            this.createChannel();
            this.m_pendingEvents.addElement(directoryEvent);
            return;
        }
        if (!this.m_channel.isOpen()) {
            this.m_pendingEvents.addElement(directoryEvent);
            return;
        }
        Integer n = directoryEvent.getRequestId();
        this.m_unansweredRequests.put(n, directoryEvent);
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeInt(n);
            this.m_channel.sendMsg((short)0, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void openDirectory(DirectoryEvent directoryEvent) {
        if (null == this.m_channel) {
            this.createChannel();
            this.m_pendingEvents.addElement(directoryEvent);
            return;
        }
        if (!this.m_channel.isOpen()) {
            this.m_pendingEvents.addElement(directoryEvent);
            return;
        }
        Integer n = directoryEvent.getRequestId();
        this.m_unansweredRequests.put(n, directoryEvent);
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeInt(n);
            directoryEvent.getDirectory().dump(ndrOutputStream);
            this.m_channel.sendMsg((short)1, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void closeDirectory(DirectoryEvent directoryEvent) {
        if (null == this.m_channel || !this.m_channel.isOpen()) {
            return;
        }
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeInt(directoryEvent.getRequestId());
            ndrOutputStream.writeInt(directoryEvent.getHandle());
            this.m_channel.sendMsg((short)2, ndrOutputStream.toByteArray(), false);
            this.m_openDirs.remove(new Integer(directoryEvent.getHandle()));
            if (this.m_openDirs.isEmpty() && this.m_unansweredRequests.isEmpty()) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "closeDirectory", "destroying Directory channel");
                }
                this.m_channel.close(0, null);
                this.m_channel.removeChannelListener(this);
                this.m_channel = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void getEntries(DirectoryEvent directoryEvent) {
        Integer n = directoryEvent.getRequestId();
        int n2 = directoryEvent.isPrevious() ? 1 : 0;
        this.getEntries(directoryEvent, n, directoryEvent.getHandle(), directoryEvent.getChunkSize(), n2, "");
    }

    private void getEntriesStartWith(DirectoryEvent directoryEvent) {
        Integer n = directoryEvent.getRequestId();
        this.getEntries(directoryEvent, n, directoryEvent.getHandle(), directoryEvent.getChunkSize(), 8, directoryEvent.getStartWith());
    }

    private void getEntries(DirectoryEvent directoryEvent, Integer n, int n2, short s, int n3, String string) {
        if (null == this.m_channel) {
            this.m_pendingEvents.addElement(directoryEvent);
            this.createChannel();
            return;
        }
        if (!this.m_channel.isOpen()) {
            this.m_pendingEvents.addElement(directoryEvent);
            return;
        }
        this.m_unansweredRequests.put(n, directoryEvent);
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeShort(s);
            ndrOutputStream.writeInt(n3);
            if (n3 == 8) {
                ndrOutputStream.writeUTF(string);
            }
            this.m_channel.sendMsg((short)3, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createChannel() {
        this.m_channel = this.m_channelService.createChannel(26, 28, 5, EncLevel.ENC_LEVEL_NONE, null, new STId("", ""));
        this.m_channel.addChannelListener(this);
        this.m_channel.open();
    }

    private void handleGetDirectoriesResponse(byte[] byArray) {
        try {
            DirectoryEvent directoryEvent;
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            Integer n = new Integer(ndrInputStream.readInt());
            if (!this.m_unansweredRequests.containsKey(n)) {
                return;
            }
            this.m_unansweredRequests.remove(n);
            int n2 = ndrInputStream.readInt();
            if (STError.VpkSucceeded(n2)) {
                int n3 = ndrInputStream.readInt();
                Directory[] directoryArray = new Directory[n3];
                for (int i = 0; i < n3; ++i) {
                    directoryArray[i] = new Directory(ndrInputStream);
                }
                directoryEvent = new DirectoryEvent((Object)this, 8, n, directoryArray);
            } else {
                directoryEvent = new DirectoryEvent(this, 7, n, n2, 0);
            }
            this.sendEvent(directoryEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void handleOpenDirectoriesResponse(byte[] byArray) {
        try {
            DirectoryEvent directoryEvent;
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            Integer n = new Integer(ndrInputStream.readInt());
            if (!this.m_unansweredRequests.containsKey(n)) {
                return;
            }
            this.m_unansweredRequests.remove(n);
            int n2 = ndrInputStream.readInt();
            if (STError.VpkSucceeded(n2)) {
                int n3 = ndrInputStream.readInt();
                int n4 = ndrInputStream.readInt();
                short s = ndrInputStream.readShort();
                directoryEvent = new DirectoryEvent((Object)this, 10, n, n3, n4, s);
                Integer n5 = new Integer(n3);
                this.m_openDirs.put(n5, n5);
            } else {
                directoryEvent = new DirectoryEvent(this, 9, n, n2, 0);
            }
            this.sendEvent(directoryEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void handleGetEntriesResponse(byte[] byArray) {
        try {
            DirectoryEvent directoryEvent;
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            Integer n = new Integer(ndrInputStream.readInt());
            if (!this.m_unansweredRequests.containsKey(n)) {
                return;
            }
            this.m_unansweredRequests.remove(n);
            int n2 = ndrInputStream.readInt();
            if (STError.VpkSucceeded(n2)) {
                boolean bl;
                STUserInstance sTUserInstance = this.m_comm.getLogin().getMyUserInstance();
                String string = sTUserInstance.getCommunityName();
                ndrInputStream.readInt();
                int n3 = ndrInputStream.readInt();
                boolean bl2 = (n3 & 2) != 0;
                boolean bl3 = bl = (n3 & 4) != 0;
                if (this.m_channel.getProtocolVersion() == 4) {
                    ndrInputStream.readInt();
                }
                int n4 = ndrInputStream.readInt();
                STObject[] sTObjectArray = new STObject[n4];
                for (int i = 0; i < n4; ++i) {
                    short s = ndrInputStream.readShort();
                    if (s == 1) {
                        sTObjectArray[i] = new STGroup(new STId(ndrInputStream.readUTF(), string), ndrInputStream.readUTF(), ndrInputStream.readUTF());
                    }
                    if (s != 0) continue;
                    sTObjectArray[i] = new STUser(new STId(ndrInputStream.readUTF(), string), ndrInputStream.readUTF(), "", ndrInputStream.readUTF());
                    ndrInputStream.readUTF();
                }
                directoryEvent = new DirectoryEvent((Object)this, 12, n, sTObjectArray, bl2, bl);
            } else {
                directoryEvent = new DirectoryEvent(this, 11, n, n2, 0);
            }
            this.sendEvent(directoryEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        if (!this.m_pendingEvents.isEmpty()) {
            Vector vector = (Vector)this.m_pendingEvents.clone();
            this.m_pendingEvents.removeAllElements();
            for (int i = 0; i < vector.size(); ++i) {
                this.processDirectoryEvent((DirectoryEvent)vector.elementAt(i));
            }
        }
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelOpenFailed", "DirectoryImpl.onOpenFailed(Channel, reason, data)");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelOpenFailed", "open Channel failed. reason = " + channelEvent.getReason());
        }
        if (channelEvent.getReason() != 0) {
            DirectoryEvent directoryEvent = new DirectoryEvent((Object)this, 14, channelEvent.getReason());
            this.sendFailForAll(channelEvent.getReason());
            if (channelEvent.getReason() == -2147483635) {
                this.m_comm.senseService(26);
            }
            this.sendEvent(directoryEvent);
        }
        this.m_channel.removeChannelListener(this);
        this.m_channel = null;
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelClosed", "DirectoryImpl.onClosed(Channel, reason, data)");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelClosed", "Channel closed. reason = " + channelEvent.getReason());
        }
        if (channelEvent.getReason() != 0) {
            DirectoryEvent directoryEvent = new DirectoryEvent((Object)this, 14, channelEvent.getReason());
            this.sendEvent(directoryEvent);
            this.sendFailForAll(channelEvent.getReason());
            this.m_comm.senseService(26);
        }
        this.m_openDirs.clear();
        this.m_channel.removeChannelListener(this);
        this.m_channel = null;
    }

    private void sendFailForAll(int n) {
        Enumeration<Object> enumeration = this.m_unansweredRequests.elements();
        this.sendFailResponse(enumeration, n);
        enumeration = this.m_pendingEvents.elements();
        this.sendFailResponse(enumeration, n);
        this.m_pendingEvents.removeAllElements();
        this.m_unansweredRequests.clear();
    }

    private void sendFailResponse(Enumeration enumeration, int n) {
        while (enumeration.hasMoreElements()) {
            int n2;
            DirectoryEvent directoryEvent = (DirectoryEvent)enumeration.nextElement();
            switch (directoryEvent.getId()) {
                case 0: {
                    n2 = 7;
                    break;
                }
                case 1: {
                    n2 = 9;
                    break;
                }
                case 3: {
                    n2 = 11;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (n2 == 0) continue;
            DirectoryEvent directoryEvent2 = new DirectoryEvent(this, n2, directoryEvent.getRequestId(), n, 0);
            this.sendEvent(directoryEvent2);
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        byte[] byArray = channelEvent.getData();
        switch (channelEvent.getMessageType()) {
            case 0: {
                this.handleGetDirectoriesResponse(byArray);
                break;
            }
            case 1: {
                this.handleOpenDirectoriesResponse(byArray);
                break;
            }
            case 3: {
                this.handleGetEntriesResponse(byArray);
            }
        }
        if (this.m_openDirs.isEmpty() && this.m_unansweredRequests.isEmpty()) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelMsgReceived", "destroying Directory channel");
            }
            this.m_channel.close(0, null);
            this.m_channel.removeChannelListener(this);
            this.m_channel = null;
        }
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() == 26) {
            DirectoryEvent directoryEvent = new DirectoryEvent(this, 13);
            this.sendEvent(directoryEvent);
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_comm.senseService(26);
    }

    public void loggedOut(LoginEvent loginEvent) {
    }
}

