/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.LoaderHelpers;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.core.util.UtilLibrary;
import com.lotus.sametime.core.util.connection.AgentInstaller;
import com.lotus.sametime.core.util.connection.RespondThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AgentLink {
    private static final String AGENT_INSTALL_NAME = "StConnAgent31.exe";
    private static final String AGENT_INSTALL_DIR = "\\Lotus\\Sametime\\";
    public static final int CONNECTION_TYPE_COMMUNITY = 0;
    public static final int CONNECTION_TYPE_MEETING = 1;
    private static RespondThread m_thread;
    private static int c_runningAgents;
    private boolean m_destroyed = false;
    private static int c_counter;
    protected int m_id;
    private static Logger m_logger;

    public AgentLink(String string, String string2, int n, String string3, int n2, String string4, int n3, boolean bl, String string5, String string6, boolean bl2, int n4) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "<init>", "AgentLink ctor in");
        }
        this.m_id = c_counter++;
        if (c_runningAgents++ == 0) {
            this.enableResponds();
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "<init>", "initPeer " + this.m_id);
        }
        this.initPeer(string, this.m_id, string2, n, string3, n2, string4, n3, bl, string5, string6, bl2, n4);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "<init>", "AgentLink ctor out");
        }
    }

    public void destroy() {
        if (!this.m_destroyed) {
            this.m_destroyed = true;
            if (--c_runningAgents == 0) {
                AgentLink.stopRespondTread();
            }
            this.destroyPeer(this.m_id);
        }
    }

    public void finalize() {
        this.destroy();
    }

    private void enableResponds() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "enableResponds", "enableResponds() in");
        }
        m_thread = new RespondThread();
        m_thread.start();
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "enableResponds", "enableResponds() out");
        }
    }

    public void connect() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "connect", "AgentLink connect in");
        }
        this.connect(this.m_id);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "connect", "AgentLink connect out");
        }
    }

    public void sendData(byte[] byArray) {
        this.sendData(this.m_id, byArray);
    }

    public void disconnect() {
        this.disconnect(this.m_id);
    }

    public static void installAgentIfNeeded(String string) throws IOException {
        if (AgentLink.isAgentInstalled(string)) {
            return;
        }
        new AgentInstaller().install(string);
    }

    static void installAndRegisterAgent(String string) throws IOException {
        int n;
        File file;
        String string2;
        if (!StaticProps.m_bWindowsOS) {
            throw new IOException("AgentConnection runs on MS-windows only");
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, AgentLink.class.getName(), "installAndRegisterAgent", "Installing agent...");
        }
        if ((string2 = AgentLink.getCommonFilesDir()) == null) {
            Debug.stAssert(false);
            string2 = "c:\\program files\\Common Files";
        }
        if (!(file = new File(string2 = string2 + AGENT_INSTALL_DIR + string + "\\")).exists()) {
            file.mkdirs();
        }
        String string3 = string2 + AGENT_INSTALL_NAME;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, AgentLink.class.getName(), "installAndRegisterAgent", "Installing agent to " + string3);
        }
        InputStream inputStream = LoaderHelpers.getResourceAsStream(null, null, AGENT_INSTALL_NAME);
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, AgentLink.class.getName(), "installAndRegisterAgent", "Registering agent...");
        }
        if (!AgentLink.registerAgent(string, string3)) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.logp(Level.FINER, AgentLink.class.getName(), "installAndRegisterAgent", "Couldn't register agent");
            }
            throw new IOException("Couldn't register agent");
        }
    }

    private native void initPeer(String var1, int var2, String var3, int var4, String var5, int var6, String var7, int var8, boolean var9, String var10, String var11, boolean var12, int var13);

    private native void destroyPeer(int var1);

    private native void connect(int var1);

    private native void sendData(int var1, byte[] var2);

    private native void disconnect(int var1);

    static native void respondThread();

    static native void stopRespondTread();

    static native boolean registerAgent(String var0, String var1);

    static native boolean isAgentInstalled(String var0);

    static native String getCommonFilesDir();

    protected abstract void onConnected();

    protected abstract void onConnectFailed(int var1);

    protected abstract void onDisconnected(int var1);

    protected abstract void onDataReceived(byte[] var1);

    protected abstract void onSendDataFailed(int var1);

    protected abstract void onStatusReport(String var1);

    static {
        c_runningAgents = 0;
        c_counter = 0;
        m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");
        Runnable runnable = new Runnable(){

            public void run() {
                System.loadLibrary("StConnAgent31");
            }
        };
        try {
            UtilLibrary.runWithPermissions("30Capabilities", runnable);
        }
        catch (RuntimeException runtimeException) {
            if (StaticProps.m_bNSVendor) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
    }
}

