/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.AgentLink;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentConnection
extends Connection {
    private static final String DEFAULT_APP_NAME = "JavaApplets3.1.20.1";
    private String m_server;
    private int m_serverPort;
    private String m_mux;
    private int m_muxPort;
    private String m_proxy;
    private int m_proxyPort;
    private boolean m_useIEProxy;
    private String m_proxyUsername;
    private String m_proxyPass;
    private boolean m_popupAuthDialog;
    private int m_connectionType;
    private AgentLink m_agentLink;
    private boolean m_isReadyForInitialSend = false;
    private int m_bytesToReceive = 1;
    private byte[] m_oldBytes = null;
    private String m_appName = null;
    private int m_closeReason = 0;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public AgentConnection(int n, String string, int n2, String string2, int n3, boolean bl, String string3, String string4, boolean bl2, long l) {
        super(bl2 ? 0L : l);
        this.m_serverPort = n;
        this.m_mux = string;
        this.m_muxPort = n2;
        this.m_proxy = string2;
        this.m_proxyPort = n3;
        this.m_useIEProxy = bl;
        this.m_proxyUsername = string3;
        this.m_proxyPass = string4;
        this.m_popupAuthDialog = bl2;
        this.m_connectionType = 1;
    }

    public AgentConnection(int n, String string, int n2, boolean bl, String string2, String string3, boolean bl2, long l) {
        super(bl2 ? 0L : l);
        this.m_serverPort = 0;
        this.m_mux = null;
        this.m_muxPort = n;
        this.m_proxy = string;
        this.m_proxyPort = n2;
        this.m_useIEProxy = bl;
        this.m_proxyUsername = string2;
        this.m_proxyPass = string3;
        this.m_popupAuthDialog = bl2;
        this.m_connectionType = 0;
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        this.m_server = string;
        if (this.m_mux == null) {
            this.m_mux = string;
        }
        String string2 = this.m_appName == null ? DEFAULT_APP_NAME : this.m_appName;
        IOException iOException = null;
        connectionInitializer.pauseSleep();
        try {
            AgentLink.installAgentIfNeeded(string2);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        connectionInitializer.restartSleep();
        if (iOException != null) {
            throw iOException;
        }
        this.m_agentLink = new AgentLink(string2, this.m_server, this.m_serverPort, this.m_mux, this.m_muxPort, this.m_proxy, this.m_proxyPort, this.m_useIEProxy, this.m_proxyUsername, this.m_proxyPass, this.m_popupAuthDialog, this.m_connectionType){

            protected void onConnected() {
                AgentConnection.this.onConnected();
            }

            protected void onConnectFailed(int n) {
                AgentConnection.this.onConnectFailed(n);
            }

            protected void onDisconnected(int n) {
                AgentConnection.this.onDisconnected(n);
            }

            protected void onDataReceived(byte[] byArray) {
                AgentConnection.this.onDataReceived(byArray);
            }

            protected void onSendDataFailed(int n) {
                AgentConnection.this.onSendDataFailed(n);
            }

            protected void onStatusReport(String string) {
                AgentConnection.this.onStatusReport(string);
            }
        };
        this.m_agentLink.connect();
    }

    public void sendMessage(byte[] byArray, byte by) {
        if (null == this.m_agentLink || !this.isReadyForInitialSend()) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendMessage", "Trying to send data on invalid connection " + this);
            }
        } else {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendMessage", "sendData: sending ");
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendMessage", TkLogger.formatBytes(byArray));
            }
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendMessage", "AgentConnection: calling DLL");
            }
            this.m_agentLink.sendData(byArray);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendMessage", "AgentConnection: returned from DLL");
            }
        }
    }

    protected boolean isReadyForInitialSend() {
        return this.m_isReadyForInitialSend;
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(7, this.m_serverPort, this.m_proxy, this.m_proxyPort, null, null);
    }

    public synchronized void close() {
        this.m_closeRequested = true;
        if (null != this.m_agentLink) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "close", "AgentLink - disconnecting");
            }
            this.m_agentLink.disconnect();
        }
    }

    public void close(int n) {
        this.m_closeReason = n;
        this.close();
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
    }

    public void setBytesToReceive(int n) {
        this.m_bytesToReceive = n;
    }

    public void setAppName(String string) {
        this.m_appName = string;
    }

    private void onConnected() {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onConnected", "AgentConnection connected");
        }
        this.m_isReadyForInitialSend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectFailed(int n) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onConnectFailed", "AgentConnection connect failed");
        }
        AgentConnection agentConnection = this;
        synchronized (agentConnection) {
            this.m_agentLink.destroy();
            this.m_agentLink = null;
        }
        n = this.m_closeRequested ? this.m_closeReason : -2147483623;
        this.m_closedListener.onConnectionClosed(n, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnected(int n) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onDisconnected", "AgentConnection disconnected, reason:" + n);
        }
        AgentConnection agentConnection = this;
        synchronized (agentConnection) {
            this.m_isReadyForInitialSend = false;
            this.m_agentLink.destroy();
            this.m_agentLink = null;
        }
        n = this.m_closeRequested ? this.m_closeReason : -2147483623;
        this.m_closedListener.onConnectionClosed(n, this);
    }

    private void onDataReceived(byte[] byArray) {
        byte[] byArray2;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onDataReceived", "AgentConnection data received: ");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onDataReceived", TkLogger.formatBytes(byArray));
        }
        if (this.m_oldBytes != null) {
            byArray2 = new byte[byArray.length + this.m_oldBytes.length];
            int n = this.m_oldBytes.length;
            System.arraycopy(this.m_oldBytes, 0, byArray2, 0, n);
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        } else {
            byArray2 = byArray;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            while (byteArrayInputStream.available() >= this.m_bytesToReceive) {
                byte[] byArray3 = new byte[this.m_bytesToReceive];
                byteArrayInputStream.read(byArray3);
                this.onReceive(byArray3);
            }
            this.m_oldBytes = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(this.m_oldBytes);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }

    private void onSendDataFailed(int n) {
        this.m_isReadyForInitialSend = false;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSendDataFailed", "AgentConnection send data failed reason: " + n);
        }
        this.close(n);
    }

    private void onStatusReport(String string) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onStatusReport", "AgentConnection status message: " + string);
        }
    }
}

