/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.RandomSeedGenerator;
import com.lotus.sametime.core.util.UtilLibrary;
import java.lang.reflect.Constructor;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RandomGenerator {
    private static final int SECURE_SEED_BYTES = 16;
    private static final int NON_SECURE_SEED_BYTES = 8;
    private static Random c_random = null;
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util");

    public static Random getRandomGenerator() {
        if (c_random == null) {
            RandomGenerator.createRandomGenerator();
        }
        return c_random;
    }

    private static void createRandomGenerator() {
        try {
            Class<?> clazz = Class.forName("java.security.SecureRandom");
            byte[] byArray = RandomGenerator.generateSeed(16);
            Class[] classArray = new Class[]{byArray.getClass()};
            Object[] objectArray = new Object[]{byArray};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            c_random = (Random)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.logp(Level.FINER, RandomGenerator.class.getName(), "createRandomGenerator", "Using non-secure random generator");
            }
            byte[] byArray = RandomGenerator.generateSeed(8);
            long l = UtilLibrary.longFromByteArray(byArray);
            c_random = new Random(l);
        }
    }

    static byte[] generateSeed(int n) {
        byte[] byArray = new RandomSeedGenerator().getBytes(n);
        return byArray;
    }
}

