/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageResources {
    private static ImageResources m_resources = new ImageResources();
    private Hashtable m_images = new Hashtable();
    private static URL imagesURL = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util");

    public static ImageResources getInstance() {
        return m_resources;
    }

    public Image getImage(String string) {
        Image image;
        Object v = this.m_images.get(string);
        if (v != null) {
            return (Image)v;
        }
        try {
            InputStream inputStream = imagesURL == null ? this.getClass().getResourceAsStream(string) : new URL(imagesURL, string.substring(1)).openStream();
            if (inputStream == null) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "getImage", "ImageResources: Can't find image: " + string);
                }
                return null;
            }
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            image = Toolkit.getDefaultToolkit().createImage(byArray);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getImage", "Can't load image: " + string, iOException);
            }
            iOException.printStackTrace();
            return null;
        }
        this.m_images.put(string, image);
        return image;
    }

    public static void setURL(URL uRL) {
        imagesURL = uRL;
    }

    public static URL getURL() {
        return imagesURL;
    }
}

