/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel;

import com.lotus.sametime.community.kernel.VpkAuthInfo;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.IOException;
import java.util.Random;

public class VpkRC240AuthInfo
extends VpkAuthInfo {
    private static final int RC2_KEY_LENGTH = 5;
    private Random m_rndGen;

    public VpkRC240AuthInfo(byte[] byArray, Random random) {
        super((short)2, byArray);
        this.m_rndGen = random;
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        byte[] byArray = this.encryptData();
        ndrOutputStream.writeBytes(byArray);
        ndrOutputStream.writeShort(this.getType());
    }

    private byte[] encryptData() {
        byte[] byArray = this.getData();
        byte[] byArray2 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[5];
        this.m_rndGen.nextBytes(byArray3);
        byte[] byArray4 = RC2Cipher.encryptOT(byArray2, byArray3, 5);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeShort(0);
            ndrOutputStream.writeShort(byArray3.length);
            ndrOutputStream.write(byArray3);
            ndrOutputStream.writeBytes(byArray4);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return ndrOutputStream.toByteArray();
    }
}

