/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel;

import com.lotus.sametime.community.kernel.VpChannel;
import com.lotus.sametime.community.kernel.VpkAuthInfo;
import com.lotus.sametime.community.kernel.VpkDiffieAuthInfo;
import com.lotus.sametime.community.kernel.VpkRC240AuthInfo;
import com.lotus.sametime.community.kernel.connhandler.CnlMsgListener;
import com.lotus.sametime.community.kernel.connhandler.ConnectionHandler;
import com.lotus.sametime.community.kernel.connhandler.MasterCnlListener;
import com.lotus.sametime.community.kernel.enc.EncData;
import com.lotus.sametime.community.kernel.enc.EncMngr;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgAcceptCnl;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgAdminMsg;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgCreateCnl;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgDestroyCnl;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgEncKey;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgHandshake;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgIn;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgLogin;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgLoginCont;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgMultiCast;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgMultiSendOnCnls;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgOut;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgQueryCommunities;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSendOnCnl;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSendTo;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSendToDenied;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSenseService;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgServerLogin;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgServiceDown;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgServiceUp;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSetNewPrivacyList;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSetOldPrivacyList;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSetPrivacyMode;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSetUserName;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgSetUserStatus;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STPrivacyList;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.RandomGenerator;
import com.lotus.sametime.core.util.UtilLibrary;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.enc.DiffieHellman;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VpKernel
implements MasterCnlListener,
CnlMsgListener {
    private static final short ST_MAJOR_VERSION = 30;
    private static final short ST_MINOR_VERSION = 7510;
    private static final short DIFFIE_SERVER_MINOR_VERSION = 26;
    private static final short GROUP_PRIVACY_SERVER_MINOR_VERSION = 7501;
    private static final short ST_PRIV_MODE_INVISIBLE = 0;
    private static final short ST_PRIV_MODE_VISIBLE = 1;
    private static final int RC2_KEY_LENGTH = 16;
    private short m_loginType = (short)4097;
    private STUserInstance m_userInstance = null;
    private short m_major = 0;
    private short m_minor = 0;
    private InetAddress m_ip = null;
    private InetAddress m_serverPovIp = null;
    private String m_host = null;
    private String m_name = null;
    private VpkAuthInfo m_authInfo = null;
    private String m_communityForLogin = null;
    private int[] m_serviceTypes = null;
    private short m_privacyMode;
    STPrivacyList m_privacyList;
    private STUserStatus m_status = null;
    private int m_serverVersion = 0;
    private Hashtable m_openChannels = new Hashtable();
    private boolean m_autoRelogin = false;
    private boolean m_weAreRedirected = false;
    private STServer m_connectingServer = null;
    private boolean m_readIDFromAuthMessage = false;
    private int m_masterChannelId = 0;
    private ConnectionHandler m_connectionHandler = null;
    private Connection[] m_connectionsToTry = null;
    private long m_keepAliveRate = -1L;
    private VpkAuthInfo m_originalAuthInfo;
    private String m_clusterName;
    private byte[] m_quickTokenEncrypted = null;
    private long m_quickTokenCacheTime = 0L;
    private byte[] m_prevAgreedKey = null;
    private String m_prevName = null;
    private VpkAuthInfo m_prevAuthInfo = null;
    private String m_prevCommunity = null;
    private String m_prevLoginId = null;
    long m_prevLogoutTime = 0L;
    private InetAddress m_prevIp = null;
    private String m_location = null;
    private String m_prevLocation = null;
    private boolean m_forceChangeStatus = false;
    private STUserStatus m_userStatusOnLogin = null;
    private boolean m_encryptConnection = true;
    DiffieHellman m_keyGenerator;
    byte[] m_privateKey;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community.kernel");
    private boolean m_loginInProcess = false;
    private boolean m_keyExchangeInProcess = false;

    protected VpKernel() {
    }

    public boolean isLoggedIn() {
        return this.m_userInstance != null;
    }

    public STUserInstance getLoginInfo() {
        return this.m_userInstance;
    }

    public short getPrivacyMode() {
        return this.m_privacyMode;
    }

    public InetAddress getIp() {
        return this.m_ip;
    }

    public InetAddress getServerPovIp() {
        return this.m_serverPovIp;
    }

    public synchronized ConnectionInfo getConnectionInfo() {
        return this.m_connectionHandler == null ? null : this.m_connectionHandler.getConnectionInfo();
    }

    public void setIp(InetAddress inetAddress) {
        this.m_ip = inetAddress;
    }

    public void setLocation(String string) {
        this.m_location = string;
    }

    public STUserStatus getStatus() {
        return this.m_status;
    }

    public STPrivacyList getPrivacyList() {
        return this.m_privacyList == null ? null : (STPrivacyList)this.m_privacyList.clone();
    }

    public int getServerVersion() {
        return this.m_serverVersion;
    }

    public boolean isGroupPrivacySupported() {
        return this.m_minor >= 7501;
    }

    public void setAutoRelogin(boolean bl) {
        this.m_autoRelogin = bl;
    }

    public boolean getAutoRelogin() {
        return this.m_autoRelogin;
    }

    public void setLoginType(short s) {
        this.m_loginType = s;
    }

    public void setLoginStatus(boolean bl, STUserStatus sTUserStatus) {
        this.m_forceChangeStatus = bl;
        this.m_userStatusOnLogin = sTUserStatus;
    }

    public short getLoginType() {
        return this.m_loginType;
    }

    public String getHost() {
        return this.m_host;
    }

    public STServer getConnectingServer() {
        return this.m_connectingServer;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.m_connectionHandler;
    }

    protected synchronized void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.m_connectionHandler = connectionHandler;
    }

    private int vpkTransEncError(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = -2147483618;
                break;
            }
            case 2: {
                n2 = -2147483617;
                break;
            }
            case 3: {
                n2 = -2147483616;
                break;
            }
            case 4: {
                n2 = -2147483615;
                break;
            }
            default: {
                n2 = -2147483619;
            }
        }
        return n2;
    }

    private void diffieEncryptAuth(byte[] byArray, byte[] byArray2) {
        short s = this.m_authInfo.getType();
        short s2 = 0;
        if (s == 0) {
            s2 = 4;
        } else if (s == 1) {
            s2 = 5;
        } else {
            Debug.stAssert(false);
        }
        byte[] byArray3 = this.m_authInfo.getData();
        VpkDiffieAuthInfo vpkDiffieAuthInfo = new VpkDiffieAuthInfo(s2, byArray3, byArray, byArray2, RandomGenerator.getRandomGenerator());
        this.m_prevAgreedKey = vpkDiffieAuthInfo.getAgreedKey();
        this.m_authInfo = vpkDiffieAuthInfo;
    }

    public String getKernelName() {
        return "VPKernel(" + this.m_masterChannelId + ")";
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getLocalAddress", "Could not resolve the main hostname from network config, trying other network interfaces...." + inetAddress, exception);
            }
            if (inetAddress == null || inetAddress.isLoopbackAddress()) {
                int n = -1;
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        int n2 = UtilLibrary.intFromByteArray(inetAddress2.getAddress());
                        if (inetAddress instanceof Inet4Address && inetAddress2 instanceof Inet6Address) continue;
                        if (inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet4Address) {
                            n = n2;
                            inetAddress = inetAddress2;
                            continue;
                        }
                        if (inetAddress2 == null || inetAddress2.isLoopbackAddress() || n != -1 && n2 >= n) continue;
                        n = n2;
                        inetAddress = inetAddress2;
                    }
                }
            }
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getLocalAddress", "Returning hostName=" + inetAddress.getHostName() + ", address=" + inetAddress.getHostAddress() + ", isLoopback=" + inetAddress.isLoopbackAddress());
            return inetAddress;
        }
        catch (Exception exception) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getLocalAddress", "Problem resolving hostname: " + inetAddress + ", error = " + exception.getMessage() + ". Returning null", exception);
            return null;
        }
    }

    private VpkMsgHandshake createHandshakeMsg(boolean bl) {
        Object object;
        String string = null;
        byte[] byArray = null;
        long l = new Date().getTime() / 1000L;
        VpkMsgHandshake vpkMsgHandshake = null;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "createHandshakeMsg", "m_name = " + this.m_name + "m_prevCommunity = " + this.m_prevCommunity + "m_prevLoginId = " + this.m_prevLoginId + "m_prevAgreedKey = " + this.m_prevAgreedKey + "m_quickTokenEncrypted = " + this.m_quickTokenEncrypted + "m_quickTokenCacheTime = " + this.m_quickTokenCacheTime);
        }
        if (this.m_name.equals(this.m_prevName) && null != this.m_originalAuthInfo && this.m_originalAuthInfo.equals(this.m_prevAuthInfo) && this.m_communityForLogin.equals(this.m_prevCommunity) && this.m_prevLoginId != null && this.m_prevAgreedKey != null && this.m_quickTokenEncrypted != null && this.m_quickTokenCacheTime != 0L && this.m_prevLogoutTime + this.m_quickTokenCacheTime > l) {
            object = RC2Cipher.decryptOT(this.m_quickTokenEncrypted, this.m_prevAgreedKey, 16);
            try {
                NdrOutputStream ndrOutputStream = new NdrOutputStream();
                Random random = RandomGenerator.getRandomGenerator();
                ndrOutputStream.writeInt(random.nextInt());
                ndrOutputStream.write((byte[])object);
                ndrOutputStream.writeUTF(this.m_prevLoginId);
                byte[] byArray2 = ndrOutputStream.toByteArray();
                byArray = RC2Cipher.encryptOT(byArray2, this.m_prevAgreedKey, 16);
                string = this.m_prevLoginId;
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "createHandshakeMsg", "VpKernel: Attempting quick relogin");
                }
                this.m_ip = this.m_prevIp;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            object = bl ? this.m_userStatusOnLogin : null;
            boolean bl2 = bl ? this.m_forceChangeStatus : false;
            vpkMsgHandshake = new VpkMsgHandshake(this.m_masterChannelId, 30, 7510, this.m_loginType, this.m_ip, string, byArray, this.m_location, bl2, (STUserStatus)object);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return vpkMsgHandshake;
    }

    private VpkMsgEncKey createEncKeyMsg() {
        this.m_keyGenerator = new DiffieHellman(DiffieHellman.Default_Modulus, DiffieHellman.Default_Base);
        Random random = RandomGenerator.getRandomGenerator();
        this.m_privateKey = this.m_keyGenerator.generatePrivateKey(random);
        byte[] byArray = this.m_keyGenerator.generatePublicKey(this.m_privateKey);
        VpkMsgEncKey vpkMsgEncKey = null;
        try {
            vpkMsgEncKey = new VpkMsgEncKey(byArray);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return vpkMsgEncKey;
    }

    private final synchronized boolean startLogin(String string, String string2, VpkAuthInfo vpkAuthInfo, String string3, boolean bl) {
        if (this.isLoggedIn() || this.m_loginInProcess) {
            return true;
        }
        this.m_loginInProcess = true;
        this.m_name = string2;
        this.m_authInfo = vpkAuthInfo;
        this.m_originalAuthInfo = vpkAuthInfo;
        this.m_host = string;
        String string4 = this.m_communityForLogin = string3 == null ? "" : string3;
        if (this.m_connectionHandler == null) {
            Debug.stAssert(this.m_masterChannelId == 0);
            if (null == this.m_ip) {
                this.m_ip = this.getLocalAddress();
            }
            if (null == this.m_location) {
                this.m_location = this.getDefaultLocationName();
            }
            VpkMsgOut vpkMsgOut = null;
            if (this.m_encryptConnection) {
                this.m_keyExchangeInProcess = true;
                vpkMsgOut = this.createEncKeyMsg();
            } else {
                vpkMsgOut = this.createHandshakeMsg(bl);
            }
            this.m_connectionHandler = new ConnectionHandler();
            this.m_connectionHandler.setMasterCnlListener(this.m_masterChannelId, this);
            this.m_connectionHandler.setKeepAliveRate(this.m_keepAliveRate);
            this.m_connectionHandler.connect(string, this.m_connectionsToTry, vpkMsgOut);
        } else if (this.m_connectionHandler.isReady()) {
            this.m_masterChannelId = STCompPart.getUniqueId();
            this.m_connectionHandler.setMasterCnlListener(this.m_masterChannelId, this);
            this.onConnected(this.m_connectionHandler);
        } else {
            this.onConnectFailed(this.m_connectionHandler);
        }
        return true;
    }

    public synchronized boolean loginByPassword(String string, String string2, String string3, String string4) {
        boolean bl;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeUTF(string3);
            VpkAuthInfo vpkAuthInfo = new VpkAuthInfo(0, ndrOutputStream.toByteArray());
            int n = 10240;
            this.m_loginType = (short)(this.m_loginType & ~n);
            bl = this.login(string, string2, vpkAuthInfo, string4, true);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean loginByToken(String string, String string2, String string3, String string4) {
        boolean bl;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeUTF(string3);
            VpkAuthInfo vpkAuthInfo = new VpkAuthInfo(1, ndrOutputStream.toByteArray());
            int n = 10240;
            this.m_loginType = (short)(this.m_loginType & ~n);
            bl = this.login(string, string2, vpkAuthInfo, string4, true);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean loginAsAnon(String string, String string2, String string3) {
        boolean bl;
        if (string2 == null) {
            string2 = "";
        }
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeUTF("");
            VpkAuthInfo vpkAuthInfo = new VpkAuthInfo(3, ndrOutputStream.toByteArray());
            this.m_loginType = (short)(this.m_loginType | 0x800);
            bl = this.login(string, string2, vpkAuthInfo, string3, true);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean loginAsServerApp(String string, short s, String string2, int[] nArray) {
        this.m_loginType = (short)(s | 0x2000);
        this.m_serviceTypes = nArray != null ? nArray : new int[]{};
        return this.login(string, string2, null, null, false);
    }

    public final synchronized boolean login(String string, String string2, VpkAuthInfo vpkAuthInfo, String string3, boolean bl) {
        if (this.isLoggedIn()) {
            return true;
        }
        this.m_encryptConnection = true;
        return this.startLogin(string, string2, vpkAuthInfo, string3, bl);
    }

    public final synchronized boolean reconnect() {
        if (this.isLoggedIn()) {
            return true;
        }
        if (this.m_name == null || this.m_originalAuthInfo == null || this.m_host == null) {
            return false;
        }
        this.m_ip = this.m_prevIp;
        this.m_location = this.m_prevLocation;
        return this.startLogin(this.m_host, this.m_name, this.m_originalAuthInfo, this.m_communityForLogin, true);
    }

    public synchronized boolean logout() {
        boolean bl = this.destroyChannel(0, 0, null);
        if (!bl) {
            this.m_loginInProcess = false;
            this.onLogout(0);
        }
        return bl;
    }

    public final synchronized boolean logout(int n) {
        return this.destroyChannel(0, n, null);
    }

    public final synchronized boolean setPrivacyMode(short s) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgSetPrivacyMode vpkMsgSetPrivacyMode = null;
        try {
            vpkMsgSetPrivacyMode = new VpkMsgSetPrivacyMode(this.m_masterChannelId, s);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSetPrivacyMode, (byte)7);
    }

    public final synchronized boolean setPrivacyList(STPrivacyList sTPrivacyList) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgOut vpkMsgOut = null;
        try {
            vpkMsgOut = this.isGroupPrivacySupported() ? new VpkMsgSetNewPrivacyList(this.m_masterChannelId, sTPrivacyList) : new VpkMsgSetOldPrivacyList(this.m_masterChannelId, sTPrivacyList);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgOut, (byte)7);
    }

    public final synchronized boolean setUserStatus(STUserStatus sTUserStatus) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgSetUserStatus vpkMsgSetUserStatus = null;
        try {
            vpkMsgSetUserStatus = new VpkMsgSetUserStatus(this.m_masterChannelId, sTUserStatus);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSetUserStatus, (byte)7);
    }

    public final synchronized boolean setUserName(String string) {
        if (!this.isLoggedIn() || (this.getLoginInfo().getLoginType() & 0x800) == 0) {
            this.onSetUserNameDenied(0);
        }
        VpkMsgSetUserName vpkMsgSetUserName = null;
        try {
            vpkMsgSetUserName = new VpkMsgSetUserName(this.m_masterChannelId, string);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSetUserName, (byte)7);
    }

    public final synchronized boolean senseService(int n) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgSenseService vpkMsgSenseService = null;
        try {
            vpkMsgSenseService = new VpkMsgSenseService(this.m_masterChannelId, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSenseService, (byte)7);
    }

    public final synchronized boolean createChannel(int n, STId sTId, int n2, int n3, int n4, EncLevel encLevel, byte[] byArray, int n5, byte by, STUserInstance sTUserInstance) {
        if (!this.isLoggedIn() || this.m_connectionHandler == null) {
            return false;
        }
        if (sTId == null) {
            sTId = new STId("", "");
        }
        VpChannel vpChannel = new VpChannel(n, encLevel, by);
        EncData encData = vpChannel.getEncData();
        String string = this.m_userInstance.getLoginId().getId();
        encData.setCreatorId(string);
        int n6 = EncMngr.createRequest(encData);
        int n7 = this.vpkTransEncError(n6);
        if (STError.VpkFailed(n7)) {
            this.onDestroyChannel(n, n7, null);
            return false;
        }
        VpkMsgCreateCnl vpkMsgCreateCnl = null;
        try {
            vpkMsgCreateCnl = new VpkMsgCreateCnl(this.m_masterChannelId, n, sTId, n2, n3, n4, n5, byArray, encData, by, sTUserInstance);
        }
        catch (IOException iOException) {
            return false;
        }
        this.m_openChannels.put(new Integer(n), vpChannel);
        this.m_connectionHandler.setListenerForCnl(n, this);
        boolean bl = this.send(vpkMsgCreateCnl, (byte)7);
        return bl;
    }

    public final synchronized boolean acceptChannel(int n, int n2, int n3, int n4, EncLevel encLevel, byte[] byArray, STUserInstance sTUserInstance, byte by, STUserInstance sTUserInstance2) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpChannel vpChannel = (VpChannel)this.m_openChannels.get(new Integer(n));
        if (vpChannel == null) {
            this.onDestroyChannel(n, -2147483647, null);
            return false;
        }
        EncData encData = vpChannel.getEncData();
        int n5 = EncMngr.localizeRequest(encLevel, encData);
        int n6 = this.vpkTransEncError(n5);
        if (STError.VpkFailed(n6)) {
            this.destroyChannel(n, n6, null);
            return false;
        }
        if (by > vpChannel.getPriority()) {
            vpChannel.setPriority(by);
        }
        this.onCreateChannel(n, n2, n3, n4, encData.remoteEncLevel(), encData.getMinAgreedLevel(), byArray, sTUserInstance, vpChannel.getPriority());
        VpkMsgAcceptCnl vpkMsgAcceptCnl = null;
        try {
            vpkMsgAcceptCnl = new VpkMsgAcceptCnl(n, n2, n3, n4, byArray, encData, vpChannel.getPriority(), sTUserInstance2);
            return this.send(vpkMsgAcceptCnl, (byte)7);
        }
        catch (IOException iOException) {
            this.destroyChannel(n, -2147483623, null);
            return false;
        }
    }

    public final synchronized boolean destroyChannel(int n, int n2, byte[] byArray) {
        if (!this.isLoggedIn() && n != 0) {
            return false;
        }
        boolean bl = false;
        if (n == 0 || n == this.m_masterChannelId) {
            try {
                bl = this.send(new VpkMsgDestroyCnl(this.m_masterChannelId, n2, byArray), (byte)7);
            }
            catch (IOException iOException) {
                bl = false;
            }
            n = 0;
            if (this.m_connectionHandler != null) {
                if (this.m_masterChannelId == 0) {
                    this.m_connectionHandler.close(n2);
                } else {
                    this.onConnectionClosed(n2, this.m_connectionHandler);
                }
                this.m_connectionHandler = null;
                this.m_openChannels.clear();
                bl = true;
            } else {
                bl = false;
            }
        } else {
            try {
                VpChannel vpChannel = (VpChannel)this.m_openChannels.remove(new Integer(n));
                byte by = null == vpChannel ? (byte)7 : (byte)vpChannel.getPriority();
                boolean bl2 = bl = this.isLoggedIn() && this.send(new VpkMsgDestroyCnl(n, n2, byArray), by);
                if (null != this.m_connectionHandler) {
                    this.m_connectionHandler.removeListenerForCnl(n);
                }
            }
            catch (IOException iOException) {
                return false;
            }
            this.onDestroyChannel(n, n2, byArray);
        }
        return bl;
    }

    public final synchronized boolean sendOnChannel(int n, short s, byte[] byArray, boolean bl) {
        if (!this.isLoggedIn() || n == 0) {
            return false;
        }
        VpChannel vpChannel = (VpChannel)this.m_openChannels.get(new Integer(n));
        if (vpChannel == null) {
            return false;
        }
        EncData encData = vpChannel.getEncData();
        if ((bl |= encData.isEncryptionForced()) && encData.isEncrypted()) {
            byArray = EncMngr.encrypt(byArray, encData);
        }
        try {
            VpkMsgSendOnCnl vpkMsgSendOnCnl = new VpkMsgSendOnCnl(n, s, byArray, bl);
            return this.send(vpkMsgSendOnCnl, vpChannel.getPriority());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public final synchronized boolean multiSendOnChannel(int[] nArray, short s, byte[] byArray, boolean bl) {
        if (!this.isLoggedIn()) {
            return false;
        }
        short s2 = this.m_userInstance.getLoginType();
        boolean bl2 = (s2 & 0x2000) != 0;
        boolean bl3 = true;
        if (bl2 && !bl) {
            try {
                int[][] nArray2 = new int[16][nArray.length];
                int[] nArray3 = new int[16];
                for (int i = 0; i < nArray.length; ++i) {
                    byte by;
                    VpChannel vpChannel = (VpChannel)this.m_openChannels.get(new Integer(nArray[i]));
                    byte by2 = by = vpChannel.getPriority();
                    int n = nArray3[by2];
                    nArray3[by2] = n + 1;
                    nArray2[by][n] = nArray[i];
                }
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray3[i] <= 0) continue;
                    int[] nArray4 = new int[nArray3[i]];
                    System.arraycopy(nArray2[i], 0, nArray4, 0, nArray3[i]);
                    bl3 &= this.send(new VpkMsgMultiSendOnCnls(nArray4, s, byArray), (byte)i);
                }
            }
            catch (IOException iOException) {
                bl3 = false;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                bl3 &= this.sendOnChannel(nArray[i], s, byArray, bl);
            }
        }
        return bl3;
    }

    public final synchronized boolean sendTo(int n, STId sTId, int n2, int n3, int n4, short s, byte[] byArray) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgSendTo vpkMsgSendTo = null;
        try {
            vpkMsgSendTo = new VpkMsgSendTo(this.m_masterChannelId, n, sTId, n2, n3, n4, s, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSendTo, (byte)7);
    }

    public final synchronized boolean denySend(int n, STId sTId, int n2) {
        VpkMsgSendToDenied vpkMsgSendToDenied;
        if (!this.isLoggedIn()) {
            return false;
        }
        try {
            vpkMsgSendToDenied = new VpkMsgSendToDenied(this.m_masterChannelId, n, sTId, n2);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgSendToDenied, (byte)7);
    }

    public boolean queryCommunities() {
        VpkMsgQueryCommunities vpkMsgQueryCommunities;
        if (!this.isLoggedIn()) {
            return false;
        }
        try {
            vpkMsgQueryCommunities = new VpkMsgQueryCommunities(this.m_masterChannelId);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgQueryCommunities, (byte)7);
    }

    public boolean adminMsg(String string) {
        VpkMsgAdminMsg vpkMsgAdminMsg;
        if (!this.isLoggedIn()) {
            return false;
        }
        try {
            vpkMsgAdminMsg = new VpkMsgAdminMsg(this.m_masterChannelId, string);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgAdminMsg, (byte)7);
    }

    public boolean sendMultiCastMsg(STObject[] sTObjectArray, short s, byte[] byArray) {
        if (!this.isLoggedIn()) {
            return false;
        }
        VpkMsgMultiCast vpkMsgMultiCast = null;
        try {
            vpkMsgMultiCast = new VpkMsgMultiCast(this.m_masterChannelId, sTObjectArray, s, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.send(vpkMsgMultiCast, (byte)7);
    }

    public boolean setConnectivity(Connection[] connectionArray) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "setConnectivity", "setConnectivity: list of connections to try:");
            for (int i = 0; i < connectionArray.length; ++i) {
                ConnectionInfo connectionInfo = connectionArray[i].getConnectionInfo();
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "setConnectivity", "" + i + " - " + connectionInfo.toString());
            }
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "setConnectivity", "setConnectivity: end of connection list.");
        }
        this.m_connectionsToTry = connectionArray;
        return true;
    }

    public synchronized void setKeepAliveRate(long l) {
        this.m_keepAliveRate = l;
        if (this.m_connectionHandler != null) {
            this.m_connectionHandler.setKeepAliveRate(l);
        }
    }

    public synchronized void serviceUp(int[] nArray) {
        try {
            this.send(new VpkMsgServiceUp(0, nArray), (byte)7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void serviceDown(int[] nArray) {
        try {
            this.send(new VpkMsgServiceDown(0, nArray), (byte)7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void onLogin() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onLogin", this.getKernelName() + "onLogin: UserInstance = " + this.m_userInstance + "\n");
        }
    }

    protected void onLogout(int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onLogout", this.getKernelName() + "onLogout: reason = " + Integer.toHexString(n));
        }
    }

    protected void onSetPrivacyMode(short s) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetPrivacyMode", this.getKernelName() + "onSetPrivacyMode: privacyMode = " + Integer.toHexString(s));
        }
    }

    protected void onSetPrivacyList(STPrivacyList sTPrivacyList) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getKernelName() + "onSetPrivacyList: privacyList = " + (sTPrivacyList.isExcluding() ? "Excluding" : "Including") + " { ");
            Enumeration enumeration = sTPrivacyList.elements();
            while (enumeration.hasMoreElements()) {
                STUser sTUser = (STUser)enumeration.nextElement();
                STId sTId = sTUser.getId();
                stringBuffer.append("( " + sTId.getId() + ", " + sTId.getCommunityName() + ") ");
            }
            stringBuffer.append("}");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetPrivacyList", stringBuffer.toString());
        }
    }

    protected void onVisibilityRequested(STUser[] sTUserArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getKernelName() + "onAckVisibilityRequested");
            stringBuffer.append(" requestors list = { ");
            for (int i = 0; i < sTUserArray.length; ++i) {
                STId sTId = sTUserArray[i].getId();
                stringBuffer.append("( " + sTId.getId() + ", " + sTId.getCommunityName() + ") ");
            }
            stringBuffer.append("}");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onVisibilityRequested", stringBuffer.toString());
        }
    }

    protected void onVisibilityCancelled(STUser[] sTUserArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getKernelName() + "onVisibilityCancelled");
            stringBuffer.append(" requestors list = { ");
            for (int i = 0; i < sTUserArray.length; ++i) {
                STId sTId = sTUserArray[i].getId();
                stringBuffer.append("( " + sTId.getId() + ", " + sTId.getCommunityName() + ") ");
            }
            stringBuffer.append("}");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onVisibilityCancelled", stringBuffer.toString());
        }
    }

    protected void onAckVisibilityAccepted(STUser[] sTUserArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getKernelName() + "onAckVisibilityAccepted");
            stringBuffer.append(" requestors list = { ");
            for (int i = 0; i < sTUserArray.length; ++i) {
                STId sTId = sTUserArray[i].getId();
                stringBuffer.append("( " + sTId.getId() + ", " + sTId.getCommunityName() + ") ");
            }
            stringBuffer.append("}");
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onAckVisibilityAccepted", stringBuffer.toString());
        }
    }

    protected void onSetPrivacyDenied(int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetPrivacyDenied", this.getKernelName() + "onSetPrivacyDenied: reason = " + n);
        }
    }

    protected void onSetStatus(STUserStatus sTUserStatus) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetStatus", this.getKernelName() + "onSetStatus: type = " + Integer.toHexString(sTUserStatus.getStatusType()) + ", time = " + sTUserStatus.getTime() + ", description = " + sTUserStatus.getStatusDescription());
        }
    }

    protected void onCreateChannel(int n, int n2, int n3, int n4, EncLevel encLevel, EncLevel encLevel2, byte[] byArray, STUserInstance sTUserInstance, byte by) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onCreateChannel", this.getKernelName() + "Channel created: chId = " + Integer.toHexString(n) + ", serviceType = " + Integer.toHexString(n2) + ", prType = " + Integer.toHexString(n3) + ", prVersion = " + Integer.toHexString(n4) + ", encLevel = " + encLevel.getValue() + ", minEncLevel = " + encLevel2.getValue() + ", data len = " + (byArray != null ? Integer.toHexString(byArray.length) : "<None>") + ", remote User Instance = " + sTUserInstance + ", Priority = " + by);
        }
    }

    protected int onAcceptChannel(int n, int n2, int n3, int n4, EncLevel encLevel, byte[] byArray, byte[] byArray2, STUserInstance sTUserInstance, byte by, STId sTId) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onAcceptChannel", this.getKernelName() + "Accept channel: chId = " + Integer.toHexString(n) + ", serviceType = " + Integer.toHexString(n2) + ", prType = " + Integer.toHexString(n3) + ", prVersion = " + Integer.toHexString(n4) + ", encLevel = " + Integer.toHexString(encLevel.getValue()) + ", creator user Instance = " + sTUserInstance + " Priority = " + by);
        }
        return 1;
    }

    protected void onDestroyChannel(int n, int n2, byte[] byArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onDestroyChannel", this.getKernelName() + "Channel destroyed: chId = " + Integer.toHexString(n) + ", reason = " + Integer.toHexString(n2) + ", data len = " + (byArray != null ? Integer.toHexString(byArray.length) : "<None>"));
        }
    }

    protected void onSendOnChannel(int n, short s, byte[] byArray, boolean bl) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onSendOnChannel", this.getKernelName() + "onSendOnChannel chId = " + n + " msgType = " + s + " encrypted = " + bl);
        }
    }

    protected void onMultiSendOnChannel(int[] nArray, short s, byte[] byArray) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onMultiSendOnChannel", this.getKernelName() + "onMultiSendOnChannel" + " msgType = " + s);
        }
    }

    protected void onSendTo(int n, STId sTId, int n2, int n3, int n4, short s, byte[] byArray) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onSendTo", this.getKernelName() + "SentTo: reqId = " + Integer.toHexString(n) + ", from (id) = " + sTId.getId() + ", msgType " + Integer.toHexString(s) + ", data (len) = " + (byArray != null ? Integer.toHexString(byArray.length) : "<None>"));
        }
    }

    protected void onSendToDenied(int n, STId sTId, int n2) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onSendToDenied", this.getKernelName() + "SendToDenied: reqId = " + Integer.toHexString(n) + ", from (id) = " + sTId.getId() + ", reason = " + Integer.toHexString(n2));
        }
    }

    protected void onServiceSensed(int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onServiceSensed", this.getKernelName() + "Service sensed: serviceType = " + n);
        }
    }

    protected void onAdminMsg(String string) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onAdminMsg", this.getKernelName() + "admin message receive: {" + string + "}");
        }
    }

    protected void onMultiCast(STUser sTUser, short s, byte[] byArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onMultiCast", this.getKernelName() + "MultiCast message received, type: {" + s + "}");
        }
    }

    protected void onCommunitiesQueried(String[] stringArray) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onCommunitiesQueried", this.getKernelName() + "Communities message receive:");
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "onCommunitiesQueried", stringArray[i]);
            }
        }
    }

    protected void onSetUserName(String string) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetUserName", this.getKernelName() + "onSetUserName: new name = " + string);
        }
    }

    protected void onSetUserNameDenied(int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "onSetUserNameDenied", this.getKernelName() + "onSetUserNameDenied: reason = " + n);
        }
    }

    private final synchronized boolean send(VpkMsgOut vpkMsgOut, byte by) {
        if (this.m_connectionHandler != null) {
            return this.m_connectionHandler.send(vpkMsgOut, by);
        }
        return false;
    }

    public void onConnected(ConnectionHandler connectionHandler) {
        if (this.m_ip == null) {
            this.m_ip = this.getLocalAddress();
        }
        if (null == this.m_location) {
            this.m_location = this.getDefaultLocationName();
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onConnected", this.getKernelName() + ": IP sent on handshake: " + (this.m_ip != null ? this.m_ip.getHostAddress() : null) + " Location: " + this.m_location);
        }
        if (this.m_masterChannelId != 0) {
            VpkMsgHandshake vpkMsgHandshake = null;
            boolean bl = false;
            vpkMsgHandshake = this.createHandshakeMsg(false);
            bl = this.send(vpkMsgHandshake, (byte)7);
            if (!bl) {
                this.destroyChannel(0, -2147483623, null);
            }
        }
    }

    public void onConnectFailed(ConnectionHandler connectionHandler) {
        connectionHandler.removeMasterCnlListener(this.m_masterChannelId);
        this.m_connectionHandler = null;
        this.m_loginInProcess = false;
        this.onLogout(-2147483129);
    }

    public void onProtocolErrorOccured(ConnectionHandler connectionHandler) {
        this.destroyChannel(0, -2147483633, null);
    }

    public synchronized void onConnectionClosed(int n, ConnectionHandler connectionHandler) {
        connectionHandler.removeMasterCnlListener(this.m_masterChannelId);
        this.m_connectionHandler = null;
        this.m_userInstance = null;
        this.m_major = 0;
        this.m_minor = 0;
        this.m_authInfo = null;
        this.m_status = null;
        this.m_connectingServer = null;
        this.m_openChannels.clear();
        this.m_ip = null;
        this.m_location = null;
        this.m_prevLogoutTime = new Date().getTime() / 1000L;
        this.m_loginInProcess = false;
        if (this.m_encryptConnection && n == -2147483136) {
            this.m_encryptConnection = false;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "onConnectionClosed", "Trying to connect w/out encryption");
            }
            this.startLogin(this.m_host, this.m_name, this.m_originalAuthInfo, this.m_communityForLogin, true);
        } else {
            this.m_loginInProcess = false;
            this.onLogout(n);
        }
    }

    public void onReceive(VpkMsgIn vpkMsgIn) throws IOException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onReceive", this.getKernelName() + ": Received message " + vpkMsgIn.getType());
        }
        switch (vpkMsgIn.getType()) {
            case 37: {
                this.handleKeyExchange(vpkMsgIn);
                break;
            }
            case -32768: {
                this.handleHandshakeAck(vpkMsgIn);
                break;
            }
            case -32767: {
                this.handleLoginAck(vpkMsgIn);
                break;
            }
            case 24: {
                this.handleAuthPassed(vpkMsgIn);
                break;
            }
            case 10: {
                this.handleSetPrivacyMode(vpkMsgIn);
                break;
            }
            case 11: {
                this.handleSetOldPrivacyList(vpkMsgIn);
                break;
            }
            case 38: {
                this.handleSetNewPrivacyList(vpkMsgIn);
                break;
            }
            case 12: {
                this.handleSetPrivacyDenied(vpkMsgIn);
                break;
            }
            case 2: {
                this.handleCreateChannel(vpkMsgIn);
                break;
            }
            case 3: {
                this.handleDestroyChannel(vpkMsgIn);
                break;
            }
            case 4: {
                this.handleSendOnChannel(vpkMsgIn);
                break;
            }
            case 5: {
                this.handleMultiSendOnChannel(vpkMsgIn);
                break;
            }
            case 7: {
                this.handleSend(vpkMsgIn);
                break;
            }
            case 8: {
                this.handleSendDenied(vpkMsgIn);
                break;
            }
            case 6: {
                this.handleAcceptChannel(vpkMsgIn);
                break;
            }
            case 9: {
                this.handleSetStatus(vpkMsgIn);
                break;
            }
            case 17: {
                this.handleSenseService(vpkMsgIn);
                break;
            }
            case 25: {
                this.handleAdminMsg(vpkMsgIn);
                break;
            }
            case 26: {
                this.handleQueryCommunities(vpkMsgIn);
                break;
            }
            case 30: {
                this.handleSetUserName(vpkMsgIn);
                break;
            }
            case 31: {
                this.handleSetUserNameDenied(vpkMsgIn);
                break;
            }
            case 34: {
                this.handleMultiCastMsg(vpkMsgIn);
                break;
            }
            default: {
                Debug.stAssert(false);
            }
        }
    }

    final void handleKeyExchange(VpkMsgIn vpkMsgIn) throws IOException {
        Object object;
        if (!this.m_keyExchangeInProcess) {
            return;
        }
        byte[] byArray = vpkMsgIn.readBytes();
        if (byArray.length > 0) {
            int n;
            int n2;
            Debug.stAssert(this.m_privateKey != null);
            object = this.m_keyGenerator.generateAgreedValue(this.m_privateKey, byArray);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleKeyExchange", "---------->Connection agreed key = ");
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleKeyExchange", TkLogger.formatBytes((byte[])object));
            }
            byte[] byArray2 = new byte[16];
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray2[n2] = 0;
            }
            if (16 >= ((Object)object).length) {
                n2 = 0;
                n = ((Object)object).length;
            } else {
                n2 = ((Object)object).length - 16;
                n = 16;
            }
            System.arraycopy(object, n2, byArray2, 16 - n, n);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleKeyExchange", "Switching on connection encrypting - server public key = ");
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleKeyExchange", TkLogger.formatBytes(byArray));
            }
            this.m_connectionHandler.encryptConnection(byArray2);
        } else if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleKeyExchange", "handleKeyExchange warning: got request to bypass encryption");
        }
        object = this.createHandshakeMsg(true);
        if (!this.send((VpkMsgOut)object, (byte)7)) {
            this.destroyChannel(0, -2147483623, null);
        }
        this.m_keyExchangeInProcess = false;
    }

    final void handleHandshakeAck(VpkMsgIn vpkMsgIn) throws IOException {
        Object object;
        this.m_major = vpkMsgIn.readShort();
        this.m_minor = vpkMsgIn.readShort();
        this.m_serverPovIp = vpkMsgIn.readInetAddress();
        this.m_serverVersion = this.m_major << 16 | this.m_minor;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "handleHandshakeAck", this.getKernelName() + ": server version is " + this.m_minor);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleHandshakeAck", this.getKernelName() + ": Logging in as " + this.m_name);
        }
        if (this.m_ip == null) {
            this.m_ip = this.m_serverPovIp;
        }
        if ((this.m_loginType & 0x2000) != 0) {
            Debug.stAssert(this.m_masterChannelId == 0);
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleHandshakeAck", "VpKernel: Attempting server login");
            }
            VpkMsgServerLogin vpkMsgServerLogin = new VpkMsgServerLogin(this.m_masterChannelId, this.m_loginType, this.m_name, this.m_serviceTypes);
            this.send(vpkMsgServerLogin, (byte)7);
            return;
        }
        this.m_prevAgreedKey = null;
        short s = this.m_authInfo.getType();
        if (this.m_minor >= 26 && (s == 0 || s == 1)) {
            object = new byte[4];
            vpkMsgIn.read((byte[])object);
            byte[] byArray = vpkMsgIn.readBytes();
            if (byArray.length == 0) {
                this.destroyChannel(0, -2147483116, null);
            }
            this.diffieEncryptAuth(byArray, (byte[])object);
        } else if (s == 0) {
            object = this.m_authInfo.getData();
            this.m_authInfo = new VpkRC240AuthInfo((byte[])object, RandomGenerator.getRandomGenerator());
        }
        if (!this.m_weAreRedirected) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleHandshakeAck", "VpKernel: Attempting full login");
            }
            object = new VpkMsgLogin(this.m_masterChannelId, this.m_loginType, this.m_name, this.m_authInfo, this.m_communityForLogin);
            this.send((VpkMsgOut)object, (byte)7);
        }
        this.m_weAreRedirected = false;
    }

    final void handleLoginAck(VpkMsgIn vpkMsgIn) throws IOException {
        this.m_userInstance = new STUserInstance(vpkMsgIn);
        this.m_privacyMode = vpkMsgIn.readShort();
        this.m_privacyList = this.isGroupPrivacySupported() && (this.m_loginType & 0x2000) == 0 ? STPrivacyList.loadNewList(vpkMsgIn) : new STPrivacyList(vpkMsgIn, false);
        short s = vpkMsgIn.readShort();
        int n = vpkMsgIn.readInt();
        String string = vpkMsgIn.readUTF();
        this.m_status = new STUserStatus(s, n, string);
        if (!this.m_readIDFromAuthMessage) {
            this.m_connectingServer = this.m_userInstance.getServerId();
        }
        this.m_readIDFromAuthMessage = false;
        try {
            this.m_clusterName = vpkMsgIn.readUTF();
            this.m_quickTokenEncrypted = vpkMsgIn.readBytes();
            this.m_quickTokenCacheTime = vpkMsgIn.readInt();
            this.m_prevName = this.m_name;
            this.m_prevAuthInfo = this.m_originalAuthInfo;
            this.m_prevCommunity = this.m_communityForLogin;
            this.m_prevLoginId = this.m_userInstance.getLoginId().getId();
            if (!this.isGroupPrivacySupported()) {
                this.m_privacyList.loadRequestors(vpkMsgIn);
            }
        }
        catch (IOException iOException) {
            this.m_clusterName = "";
            this.m_quickTokenEncrypted = null;
            this.m_quickTokenCacheTime = 0L;
            this.m_prevName = null;
            this.m_prevAuthInfo = null;
            this.m_prevCommunity = null;
            this.m_prevLoginId = null;
        }
        this.m_prevIp = this.m_ip;
        this.m_prevLocation = this.m_location;
        this.onLogin();
        this.onSetPrivacyMode(this.m_privacyMode);
        this.onSetPrivacyList(this.m_privacyList);
        this.onSetStatus(this.m_status);
    }

    final void handleAuthPassed(VpkMsgIn vpkMsgIn) throws IOException {
        String string = vpkMsgIn.readUTF();
        if (this.m_masterChannelId != 0) {
            this.m_autoRelogin = false;
        }
        if (this.m_autoRelogin) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleAuthPassed", this.getKernelName() + "Re-login to " + string);
            }
            this.login(string, this.m_name, this.m_authInfo, this.m_communityForLogin, true);
        } else {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleAuthPassed", this.getKernelName() + "Login redirected by the server to " + string);
            }
            if (!this.m_readIDFromAuthMessage) {
                block8: {
                    try {
                        String string2 = vpkMsgIn.readUTF();
                        STLoginId sTLoginId = new STLoginId(string2, "");
                        this.m_connectingServer = new STServer(sTLoginId, "", "");
                    }
                    catch (IOException iOException) {
                        if (!this.m_logger.isLoggable(Level.FINER)) break block8;
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleAuthPassed", this.getKernelName() + "connecting server data unavailable");
                    }
                }
                this.m_readIDFromAuthMessage = true;
            }
            this.m_weAreRedirected = true;
            this.send(new VpkMsgLoginCont(this.m_masterChannelId), (byte)7);
        }
    }

    final void handleSetPrivacyMode(VpkMsgIn vpkMsgIn) throws IOException {
        this.m_privacyMode = vpkMsgIn.readShort();
        this.onSetPrivacyMode(this.m_privacyMode);
    }

    final void handleSetNewPrivacyList(VpkMsgIn vpkMsgIn) throws IOException {
        STPrivacyList sTPrivacyList = STPrivacyList.loadNewList(vpkMsgIn);
        this.m_privacyList = (STPrivacyList)sTPrivacyList.clone();
        this.onSetPrivacyList(sTPrivacyList);
    }

    final void handleSetOldPrivacyList(VpkMsgIn vpkMsgIn) throws IOException {
        STPrivacyList sTPrivacyList = new STPrivacyList(vpkMsgIn, false);
        if (sTPrivacyList.loadRequestors(vpkMsgIn)) {
            Object object;
            Object object2;
            Object object3;
            Hashtable hashtable = UtilLibrary.subtractTables(sTPrivacyList.getRequestors(), this.m_privacyList.getRequestors());
            Hashtable hashtable2 = UtilLibrary.subtractTables(this.m_privacyList.getRequestors(), sTPrivacyList.getRequestors());
            Hashtable hashtable3 = sTPrivacyList.getPeople();
            if (hashtable.size() > 0) {
                int n = 0;
                object3 = new STUser[hashtable.size()];
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    STUser sTUser = (STUser)hashtable.get(object);
                    object3[n++] = sTUser;
                }
                this.onVisibilityRequested((STUser[])object3);
            }
            if (hashtable2.size() > 0) {
                Hashtable hashtable4;
                STUser[] sTUserArray;
                Hashtable hashtable5 = UtilLibrary.existInBothTables(hashtable2, hashtable3);
                if (hashtable5.size() > 0) {
                    int n = 0;
                    object2 = new STUser[hashtable5.size()];
                    sTUserArray = hashtable5.keys();
                    while (sTUserArray.hasMoreElements()) {
                        object3 = sTUserArray.nextElement();
                        object = (STUser)hashtable5.get(object3);
                        object2[n++] = object;
                    }
                    this.onAckVisibilityAccepted((STUser[])object2);
                }
                if ((hashtable4 = UtilLibrary.subtractTables(hashtable2, hashtable3)).size() > 0) {
                    int n = 0;
                    sTUserArray = new STUser[hashtable4.size()];
                    Enumeration enumeration = hashtable4.keys();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        object3 = (STUser)hashtable4.get(object2);
                        sTUserArray[n++] = object3;
                    }
                    this.onVisibilityCancelled(sTUserArray);
                }
            }
        }
        this.m_privacyList = (STPrivacyList)sTPrivacyList.clone();
        this.onSetPrivacyList(sTPrivacyList);
    }

    final void handleSetPrivacyDenied(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        this.onSetPrivacyDenied(n);
    }

    final void handleSetStatus(VpkMsgIn vpkMsgIn) throws IOException {
        this.m_userStatusOnLogin = this.m_status = new STUserStatus(vpkMsgIn);
        this.onSetStatus(this.m_status);
    }

    final void handleSenseService(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        this.onServiceSensed(n);
    }

    final void handleCreateChannel(VpkMsgIn vpkMsgIn) throws IOException {
        byte by;
        EncData encData;
        STUserInstance sTUserInstance;
        byte[] byArray;
        int n;
        int n2;
        int n3;
        STId sTId;
        int n4;
        block8: {
            vpkMsgIn.readInt();
            n4 = vpkMsgIn.readInt();
            sTId = new STId(vpkMsgIn);
            n3 = vpkMsgIn.readInt();
            n2 = vpkMsgIn.readInt();
            n = vpkMsgIn.readInt();
            vpkMsgIn.readInt();
            byArray = vpkMsgIn.readBytes();
            boolean bl = vpkMsgIn.readBoolean();
            if (!bl) {
                throw new IOException();
            }
            sTUserInstance = new STUserInstance(vpkMsgIn);
            encData = new EncData(EncLevel.ENC_LEVEL_NONE);
            by = 7;
            try {
                encData.load(vpkMsgIn);
                vpkMsgIn.readInt();
                vpkMsgIn.readBoolean();
                vpkMsgIn.readBytes();
                by = vpkMsgIn.readByte();
                if (by > 15 || by < 0) {
                    by = 7;
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleCreateChannel", "handleCreateChannel with invalid priority level, chnaging to default level");
                    }
                }
            }
            catch (IOException iOException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block8;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleCreateChannel", this.getKernelName() + "handleCreateChannel: Couldn't read of of the " + "following: encData, snatching info, priority level");
            }
        }
        encData.setCreatorId(sTUserInstance.getLoginId().getId());
        encData.setAcceptorId(this.m_userInstance.getLoginId().getId());
        VpChannel vpChannel = new VpChannel(n4, encData, by);
        this.m_openChannels.put(new Integer(n4), vpChannel);
        this.m_connectionHandler.setListenerForCnl(n4, this);
        EncLevel encLevel = encData.getEncLevel();
        byte[] byArray2 = null;
        int n5 = this.onAcceptChannel(n4, n3, n2, n, encLevel, byArray, byArray2, sTUserInstance, by, sTId);
        if (1 != n5) {
            if (STError.VpkSucceeded(n5)) {
                this.acceptChannel(n4, n3, n2, n, encLevel, byArray2, sTUserInstance, by, null);
            } else {
                this.m_openChannels.remove(new Integer(n4));
                this.m_connectionHandler.removeListenerForCnl(n4);
                this.destroyChannel(n4, n5, null);
            }
        }
    }

    final void handleAcceptChannel(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        int n2 = vpkMsgIn.readInt();
        int n3 = vpkMsgIn.readInt();
        byte[] byArray = vpkMsgIn.readBytes();
        boolean bl = vpkMsgIn.readBoolean();
        if (!bl) {
            throw new IOException();
        }
        STUserInstance sTUserInstance = new STUserInstance(vpkMsgIn);
        int n4 = vpkMsgIn.getChannelId();
        VpChannel vpChannel = (VpChannel)this.m_openChannels.get(new Integer(n4));
        if (vpChannel == null) {
            throw new IOException("Accept on a non-existing channel");
        }
        EncData encData = vpChannel.getEncData();
        EncLevel encLevel = encData.getEncLevel();
        encData.setAcceptorId(sTUserInstance.getLoginId().getId());
        try {
            encData.load(vpkMsgIn);
            byte by = vpkMsgIn.readByte();
            if (by > vpChannel.getPriority()) {
                vpChannel.setPriority(by);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n5 = EncMngr.localizeReply(encLevel, encData);
        int n6 = this.vpkTransEncError(n5);
        if (STError.VpkFailed(n6)) {
            this.destroyChannel(n4, n6, null);
            this.onDestroyChannel(n4, n6, null);
            return;
        }
        this.onCreateChannel(n4, n, n2, n3, encData.remoteEncLevel(), encData.getMinAgreedLevel(), byArray, sTUserInstance, vpChannel.getPriority());
    }

    final void handleDestroyChannel(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        byte[] byArray = null;
        try {
            byArray = vpkMsgIn.readBytes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (vpkMsgIn.getChannelId() == 0 || vpkMsgIn.getChannelId() == this.m_masterChannelId) {
            this.destroyChannel(0, n, byArray);
        } else {
            this.m_openChannels.remove(new Integer(vpkMsgIn.getChannelId()));
            if (null != this.m_connectionHandler) {
                this.m_connectionHandler.removeListenerForCnl(vpkMsgIn.getChannelId());
            }
            this.onDestroyChannel(vpkMsgIn.getChannelId(), n, byArray);
        }
    }

    final void handleSendOnChannel(VpkMsgIn vpkMsgIn) throws IOException {
        short s = vpkMsgIn.readShort();
        byte[] byArray = vpkMsgIn.readBytes();
        int n = vpkMsgIn.getChannelId();
        if (vpkMsgIn.isEncrypted()) {
            VpChannel vpChannel = (VpChannel)this.m_openChannels.get(new Integer(n));
            if (vpChannel == null) {
                return;
            }
            EncData encData = vpChannel.getEncData();
            byArray = EncMngr.decrypt(byArray, encData);
            if (EncMngr.getEncError() != 0) {
                throw new IOException("Cannot decrypt message");
            }
        }
        this.onSendOnChannel(n, s, byArray, vpkMsgIn.isEncrypted());
    }

    final void handleMultiSendOnChannel(VpkMsgIn vpkMsgIn) throws IOException {
        short s;
        short s2 = vpkMsgIn.readInt();
        int[] nArray = new int[s2];
        for (s = 0; s < s2; ++s) {
            nArray[s] = vpkMsgIn.readInt();
        }
        s = vpkMsgIn.readShort();
        byte[] byArray = vpkMsgIn.readBytes();
        this.onMultiSendOnChannel(nArray, s, byArray);
    }

    final void handleSend(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        STId sTId = new STId(vpkMsgIn);
        int n2 = vpkMsgIn.readInt();
        int n3 = vpkMsgIn.readInt();
        int n4 = vpkMsgIn.readInt();
        short s = vpkMsgIn.readShort();
        byte[] byArray = vpkMsgIn.readBytes();
        this.onSendTo(n, sTId, n2, n3, n4, s, byArray);
    }

    final void handleSendDenied(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        STId sTId = new STId(vpkMsgIn);
        int n2 = vpkMsgIn.readInt();
        this.onSendToDenied(n, sTId, n2);
    }

    final void handleAdminMsg(VpkMsgIn vpkMsgIn) throws IOException {
        block2: {
            try {
                String string = vpkMsgIn.readUTF();
                this.onAdminMsg(string);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleAdminMsg", this.getKernelName() + "A bad admin message was received and ignored.");
            }
        }
    }

    final void handleMultiCastMsg(VpkMsgIn vpkMsgIn) throws IOException {
        try {
            boolean bl = vpkMsgIn.readBoolean();
            Debug.stAssert(bl);
            STUserInstance sTUserInstance = new STUserInstance(vpkMsgIn);
            short s = vpkMsgIn.readShort();
            byte[] byArray = vpkMsgIn.readBytes();
            this.onMultiCast(sTUserInstance, s, byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final void handleQueryCommunities(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = vpkMsgIn.readUTF();
        }
        this.onCommunitiesQueried(stringArray);
    }

    final void handleSetUserName(VpkMsgIn vpkMsgIn) throws IOException {
        String string = vpkMsgIn.readUTF();
        this.m_userInstance.setName(string);
        this.onSetUserName(string);
    }

    final void handleSetUserNameDenied(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.readInt();
        this.onSetUserNameDenied(n);
    }

    private String getDefaultLocationName() {
        int n;
        String string = null;
        InetAddress inetAddress = this.getLocalAddress();
        if (null != inetAddress && null != (string = inetAddress.getHostName()) && (n = string.indexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }
}

