/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.commui.PrivacyPanel;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class PrivacyDialog
extends Dialog {
    private PrivacyPanel m_privacy;
    private STSession m_session;
    private STBundle m_resourceFile;
    private Button m_btnOK;
    private Button m_btnCancel;

    public PrivacyDialog(Frame frame, STSession sTSession) {
        super(frame);
        this.m_resourceFile = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/commui");
        this.setTitle(this.m_resourceFile.getString("PRIVACY_FRAME_TITLE"));
        this.m_session = sTSession;
        this.m_btnOK = new Button(this.m_resourceFile.getString("BTN_LBL_OK"));
        this.m_btnCancel = new Button(this.m_resourceFile.getString("BTN_LBL_CANCEL"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrivacyDialog.this.actionPerformed(actionEvent);
            }
        };
        this.m_btnOK.addActionListener(actionListener);
        this.m_btnCancel.addActionListener(actionListener);
        this.m_privacy = new PrivacyPanel(this.m_session);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel(gridBagLayout);
        Panel panel2 = new Panel();
        panel.add(panel2);
        gridBagConstraints.weightx = 0.6;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        Panel panel3 = new Panel(new GridLayout(1, 2, 10, 0));
        panel3.add(this.m_btnOK);
        panel3.add(this.m_btnCancel);
        panel.add(panel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(SystemColor.control);
        if (StaticProps.m_bMacOSX) {
            this.setResizable(true);
        } else {
            this.setResizable(false);
        }
        this.setSize(275, 400);
        this.add("Center", this.m_privacy);
        this.add("South", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrivacyDialog.this.setVisible(false);
            }
        });
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.pack();
        Rectangle rectangle = this.getParent().getBounds();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (rectangle.x + rectangle.width + dimension.width < dimension2.width && rectangle.y < dimension2.height) {
            this.setBounds(rectangle.x + rectangle.width, rectangle.y, dimension.width, dimension.height);
        } else {
            this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        }
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 15, insets.bottom + 6, insets.right + 15);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.m_privacy.getBounds();
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                if (PrivacyDialog.this.m_privacy.submit()) {
                    PrivacyDialog.this.setVisible(false);
                }
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                PrivacyDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_CANCEL"))){

            public void executeKeyMethod() {
                PrivacyDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_OK"))){

            public void executeKeyMethod() {
                if (PrivacyDialog.this.m_privacy.submit()) {
                    PrivacyDialog.this.setVisible(false);
                }
            }
        });
        Enumeration enumeration = this.m_privacy.getActionKeys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((KeyAction)enumeration.nextElement());
        }
        return new KeyHandler(vector);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnOK) {
            if (this.m_privacy.submit()) {
                this.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.m_btnCancel) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_privacy.setVisible(bl);
    }
}

