/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.invitation;

import com.lotus.sametime.chatui.invitation.JoinDialogListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.ImagePanel;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class JoinDialog
extends Dialog
implements ActionListener,
WindowListener,
LoginListener {
    private static final int MESSAGE_WIDTH = 42;
    private static final int MESSAGE_HEIGHT = 2;
    private static int c_cascadingIterator = 0;
    private JoinDialogListener m_listener;
    private Button m_btnJoin;
    private Button m_btnRespond;
    private Button m_btnClose;
    private STBundle m_res;
    private ResourceLoaderService m_loader;
    private Image m_imgAudio;
    private Image m_imgVideo;
    private Image m_imgShare;
    private Image m_imgCollab;

    public JoinDialog(Frame frame, String string, String string2, MeetingTypes meetingTypes, String string3, String string4, boolean bl, STSession sTSession, JoinDialogListener joinDialogListener) {
        super(frame, string);
        String string5 = "com.lotus.sametime.resourceloader.ResourceLoaderComp";
        this.m_loader = (ResourceLoaderService)((Object)sTSession.getCompApi(string5));
        this.m_res = this.m_loader.getBundle("properties/chatui");
        this.m_listener = joinDialogListener;
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        communityService.addLoginListener(this);
        this.init(meetingTypes, string2, string3, string4, bl);
        this.addWindowListener(this);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.position();
        this.pack();
        this.setResizable(false);
        this.setSize(this.getPreferredSize());
        this.setVisible(true);
        this.toFront();
        this.m_btnJoin.requestFocus();
    }

    public JoinDialog(Frame frame, String string, String string2, MeetingTypes meetingTypes, String string3, String string4, boolean bl, STSession sTSession, JoinDialogListener joinDialogListener, STUser sTUser) {
        this(frame, string, string2, meetingTypes, string3, string4, bl, sTSession, joinDialogListener);
        if (null != sTUser && sTUser.isExternalUser()) {
            this.m_btnRespond.setEnabled(false);
        }
    }

    public void position() {
        int n = (c_cascadingIterator + 2) * 24;
        int n2 = (c_cascadingIterator + 2) * 24;
        this.setLocation(n, n2);
        ++c_cascadingIterator;
        c_cascadingIterator %= 8;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 3, insets.bottom + 3, insets.right + 3);
    }

    public void setListener(JoinDialogListener joinDialogListener) {
        this.m_listener = joinDialogListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnJoin) {
            this.joinButtonPressed();
        } else if (actionEvent.getSource() == this.m_btnRespond) {
            this.respondButtonPressed();
        } else if (actionEvent.getSource() == this.m_btnClose) {
            this.closeButtonPressed();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.m_listener != null) {
            this.m_listener.joinDlgCloseButtonPressed(this);
        }
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void loggedIn(LoginEvent loginEvent) {
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_btnJoin.setEnabled(false);
        this.m_btnRespond.setEnabled(false);
    }

    protected void init(MeetingTypes meetingTypes, String string, String string2, String string3, boolean bl) {
        this.setBackground(SystemColor.control);
        this.setLayout(new BorderLayout(10, 10));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(10, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(10, 10));
        Label label = this.createInvitedLabel(meetingTypes, string);
        panel.add("North", label);
        String string4 = this.createTextMessage(string2, string3);
        TextArea textArea = new TextArea(string4, 2, 42, 1);
        textArea.setEditable(false);
        panel.add("Center", textArea);
        Label label2 = new Label(this.m_res.getString("LBL_LAUNCH_MEETING"));
        panel.add("South", label2);
        panel2.add("Center", panel);
        panel2.add("South", this.createButtonsPanel(meetingTypes));
        this.add("Center", panel2);
        this.add("South", this.createStatusBar(bl));
    }

    private String createTextMessage(String string, String string2) {
        String string3 = this.m_res.getString("TOPIC_PREFIX") + " ";
        string3 = string3 + string;
        string3 = string3 + "\n";
        string3 = string3 + "\n";
        string3 = string3 + this.m_res.getString("MESSAGE_PREFIX") + " ";
        string3 = string3 + string2;
        return string3;
    }

    private Label createInvitedLabel(MeetingTypes meetingTypes, String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = this.m_res.formatString("LBL_INVITED_PREFIX", objectArray) + " ";
        if (meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_AUDIOBRIDGE_MEETING");
        } else if (meetingTypes.equals(MeetingTypes.ST_AUDIO_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_AUDIO_MEETING");
        } else if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_CHAT_MEETING");
        } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_COLLAB_MEETING");
        } else if (meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_SHARE_MEETING");
        } else if (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING)) {
            string2 = string2 + this.m_res.getString("LBL_VIDEO_MEETING");
        }
        return new Label(string2);
    }

    protected Statusbar createStatusBar(boolean bl) {
        Image image = null;
        image = bl ? this.m_loader.getImage("images/encrypt_key.gif") : this.m_loader.getImage("images/no_encrypt_key.gif");
        return new Statusbar("", this.m_res.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE"), this.m_res.getInt("STATUSBAR_HEIGHT"), image);
    }

    protected Panel createButtonsPanel(MeetingTypes meetingTypes) {
        String[] stringArray = new String[]{this.m_res.getString("BTN_LBL_JOIN"), this.m_res.getString("BTN_LBL_RESPOND"), this.m_res.getString("BTN_LBL_CLOSE")};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, this, 2);
        this.m_btnJoin = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_JOIN"));
        this.m_btnRespond = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_RESPOND"));
        this.m_btnClose = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_CLOSE"));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Image image = meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING) ? this.m_loader.getImage("images/telephone_f.gif") : (meetingTypes.equals(MeetingTypes.ST_AUDIO_MEETING) ? this.m_loader.getImage("images/audio.gif") : (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING) ? this.m_loader.getImage("images/Message.gif") : (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING) ? this.m_loader.getImage("images/collaborate.gif") : (meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING) ? this.m_loader.getImage("images/share.gif") : (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING) ? this.m_loader.getImage("images/video.gif") : this.m_loader.getImage("images/Message.gif"))))));
        panel.add((Component)new ImagePanel(image, 0, 1), "West");
        panel.add((Component)buttonsPanel, "Center");
        return panel;
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                JoinDialog.this.joinButtonPressed();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                JoinDialog.this.closeButtonPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_JOIN"))){

            public void executeKeyMethod() {
                JoinDialog.this.joinButtonPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_RESPOND"))){

            public void executeKeyMethod() {
                JoinDialog.this.respondButtonPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                JoinDialog.this.closeButtonPressed();
            }
        });
        return new KeyHandler(vector);
    }

    private void joinButtonPressed() {
        if (this.m_listener != null) {
            this.m_listener.joinDlgJoinButtonPressed(this);
        }
        this.dispose();
    }

    private void respondButtonPressed() {
        if (this.m_listener != null) {
            this.m_listener.joinDlgRespondButtonPressed(this);
        }
    }

    private void closeButtonPressed() {
        if (this.m_listener != null) {
            this.m_listener.joinDlgCloseButtonPressed(this);
        }
        this.dispose();
    }
}

