/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.buddylist;

import com.lotus.sametime.buddylist.AimUser;
import com.lotus.sametime.buddylist.BL;
import com.lotus.sametime.buddylist.BLCommunity;
import com.lotus.sametime.buddylist.BLEvent;
import com.lotus.sametime.buddylist.BLGroup;
import com.lotus.sametime.buddylist.BLUser;
import com.lotus.sametime.buddylist.BLXMLParser;
import com.lotus.sametime.buddylist.BLXMLWriter;
import com.lotus.sametime.buddylist.PrivateGroup;
import com.lotus.sametime.buddylist.PublicGroup;
import com.lotus.sametime.buddylist.STBLUser;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObjectImpl;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.storage.StorageEvent;
import com.lotus.sametime.storage.StorageService;
import com.lotus.sametime.storage.StorageServiceListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BLServiceImpl
extends STCompImpl
implements StorageServiceListener {
    static final int BUDDY_LIST_ATTR_KEY = 0;
    static final int XML_BUDDY_LIST_ATTR_KEY = 8192;
    private final String BL_FILE_VERSION_1 = "Version=3.1.3";
    private final String BL_FILE_VERSION_2 = "Version=3.1.2";
    private final String BL_GROUP = "G";
    private final String BL_USER = "U";
    private final String BL_GROUP_OPEN = "O";
    private final String BL_GROUP_CLOSED = "C";
    private final String BL_PRIVATE_GROUP = "2";
    private final String BL_PUBLIC_GROUP = "3";
    private final char BL_BLANK_REPLACE = (char)59;
    private final String BL_COMMUNITY_DELIMITER = "::";
    private final String BL_NICK_NAME_DELIMITER = ",";
    private final char BL_DELIMITER = (char)32;
    private final String BL_SAMETIME_SERVER_TYPE = "1";
    private final String BL_AOL_SERVER_TYPE = "2";
    private final String BL_SIP_SERVER_TYPE = "3";
    private final String DEFAULT_PRIVATE_GROUP_NAME = "Work";
    private static int MAX_STRING_LENGTH_TO_STORAGE = 60000;
    static int m_buddyListAttrKey = 0;
    private BLXMLParser BLXMLHandler = null;
    private Vector m_BLCommunityList = new Vector();
    private StorageService m_storage;
    CommunityService m_commService;
    private Hashtable m_ReqIds = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.buddylist");

    public BLServiceImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.buddylist.BLComp", sTSession);
        this.m_storage = (StorageService)sTSession.getCompApi("com.lotus.sametime.storage.StorageComp");
        this.m_storage.addStorageServiceListener(this);
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof BLEvent) {
            BLEvent bLEvent = (BLEvent)sTEvent;
            switch (bLEvent.getId()) {
                case 10: {
                    this.getBuddyList();
                    break;
                }
                case 11: {
                    this.setBuddyList(bLEvent.getBL());
                }
            }
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    void getBuddyList() {
        Integer n = this.m_storage.queryAttr(m_buddyListAttrKey);
        this.m_ReqIds.put(n, n);
    }

    private void setBuddyList(BL bL) {
        Serializable serializable;
        String string = null;
        string = m_buddyListAttrKey == 8192 ? this.convertBLToXML(bL) : this.convertBLToString(bL);
        if (string.equals("")) {
            return;
        }
        if (string.length() > MAX_STRING_LENGTH_TO_STORAGE) {
            string = string.substring(0, MAX_STRING_LENGTH_TO_STORAGE);
            int n = string.lastIndexOf(",");
            string = string.substring(0, n + 1);
            serializable = new BLEvent(this, 108);
            this.sendEvent((STEvent)serializable);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "setBuddyList", "BLServiceImpl.setBuddyList--> buffer : " + string);
        }
        STAttribute sTAttribute = new STAttribute(m_buddyListAttrKey, string);
        serializable = this.m_storage.storeAttr(sTAttribute);
        this.m_ReqIds.put(serializable, serializable);
    }

    protected BL readBuddyList(String string) {
        String string2 = "";
        String string3 = "";
        Object object = null;
        BLGroup bLGroup = null;
        BLUser bLUser = null;
        Vector<BLGroup> vector = new Vector<BLGroup>();
        Vector<BLUser> vector2 = new Vector<BLUser>();
        boolean bl = true;
        boolean bl2 = true;
        if (string != null) {
            if (m_buddyListAttrKey == 8192) {
                if (this.BLXMLHandler == null) {
                    this.BLXMLHandler = new BLXMLParser(this);
                    this.BLXMLHandler.InitXmlParser(string);
                }
                return new BL(this.BLXMLHandler.m_groupsList);
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                string3 = stringTokenizer.nextToken();
                if (this.checkVersion(string3)) {
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "readBuddyList", "BLServiceImpl.readBuddyList--> BuddyList : " + string);
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        object = this.parseString(string2, string3);
                        if (object != null && object instanceof BLGroup) {
                            if (!bl2) {
                                vector.addElement(this.createGroupWithUsers(bLGroup, vector2));
                                vector2 = new Vector();
                            }
                            bLGroup = (BLGroup)object;
                            bl = false;
                            bl2 = false;
                            continue;
                        }
                        if (object == null || !(object instanceof BLUser)) continue;
                        bLUser = (BLUser)object;
                        vector2.addElement(bLUser);
                    }
                    if (!bl) {
                        vector.addElement(this.createGroupWithUsers(bLGroup, vector2));
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
        }
        if (vector.size() > 0) {
            return new BL(vector);
        }
        return null;
    }

    BLGroup createGroupWithUsers(BLGroup bLGroup, Vector vector) {
        if (bLGroup == null || bLGroup instanceof PublicGroup || vector == null) {
            return bLGroup;
        }
        PrivateGroup privateGroup = new PrivateGroup(bLGroup.getBLId(), bLGroup.getName(), bLGroup.getDesc(), bLGroup.getGroupOpenStatus(), vector);
        return privateGroup;
    }

    private Object parseString(String string, String string2) {
        Object object = null;
        if (string.substring(0, 1).equals("G")) {
            object = this.parseGroupString(string.substring(1));
        } else if (string.substring(0, 1).equals("U")) {
            object = this.parseUserString(string.substring(1));
        }
        return object;
    }

    private BLGroup parseGroupString(String string) {
        BLGroup bLGroup = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
            string3 = string2.substring(0, string2.length() - 1);
            String string5 = string2.substring(string2.length() - 1, string2.length());
            string3 = string3.replace(';', ' ');
            for (int i = stringTokenizer.countTokens(); i > 1; --i) {
                String string6 = stringTokenizer.nextToken();
                string4 = string4.equals("") ? string6 : string4 + " " + string6;
            }
            string4 = string4.replace(';', ' ');
            String string7 = stringTokenizer.nextToken().substring(0, 1);
            if (string5.equals("2")) {
                bLGroup = new PrivateGroup(string3, string4, "", string7.equals("O"), null);
            } else if (string5.equals("3")) {
                bLGroup = new PublicGroup(new STId(string3, this.m_commService.getLogin().getMyUserInstance().getCommunityName()), string4, "", string7.equals("O"));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        return bLGroup;
    }

    private BLUser parseUserString(String string) {
        BLUser bLUser = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n = -1;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
            string2 = string2.replace(';', ' ');
            string2 = string2.trim();
            n = string2.indexOf("::");
            if (n != -1) {
                string6 = string2.substring(n - "1".length(), n);
                string5 = string2.substring(n + "::".length());
                string2 = string2.substring(0, n - "1".length());
            } else {
                string6 = string2.substring(string2.length() - 1);
                string2 = string2.substring(0, string2.length() - 1);
            }
            string3 = stringTokenizer.nextToken();
            string3 = string3.replace(';', ' ');
            string3 = string3.trim();
            n = string3.indexOf(",");
            if (n != -1) {
                int n2 = string3.indexOf(",", n + 1);
                if (n2 >= 0) {
                    n = n2;
                }
                if (n < string3.length() - 1) {
                    string4 = string3.substring(n + 1, string3.length());
                }
                string3 = string3.substring(0, n);
            }
            if (string6.equals("1")) {
                STId sTId = new STId(string2, string5);
                bLUser = new STBLUser(sTId, string3, "", string4);
            } else if (string6.equals("2")) {
                bLUser = new AimUser(string2, string3, "", string4);
            }
            this.addCommunity(null, string6, string5);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bLUser;
    }

    private boolean checkVersion(String string) {
        boolean bl = false;
        if ((string = string.trim()).equals("Version=3.1.3") || string.equals("Version=3.1.2")) {
            bl = true;
        }
        return bl;
    }

    private String createGroupString(BLGroup bLGroup) {
        String string = new String();
        String string2 = bLGroup.getBLId();
        String string3 = bLGroup.getName();
        String string4 = bLGroup.getGroupOpenStatus() ? "O" : "C";
        String string5 = bLGroup instanceof PrivateGroup ? "2" : "3";
        string2 = string2.replace(' ', ';');
        string3 = string3.replace(' ', ';');
        string = "G " + string2 + string5 + ' ' + string3 + ' ' + string4;
        return string;
    }

    String createUserString(BLUser bLUser) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        String string5 = bLUser.getName();
        String string6 = bLUser.getNickName();
        if (bLUser instanceof STUser) {
            STUser sTUser = (STUser)((Object)bLUser);
            string4 = sTUser.getId().getId();
            string2 = "1";
            string3 = sTUser.getId().getCommunityName();
        } else if (bLUser instanceof AimUser) {
            AimUser aimUser = (AimUser)bLUser;
            string4 = aimUser.getBLId();
            string2 = "2";
            string3 = "AOL;Instant;Messenger";
        }
        string4 = string4.replace(' ', ';');
        string5 = string5.replace(' ', ';');
        string = "U " + string4 + string2 + "::" + string3.replace(' ', ';') + ' ' + string5 + "," + string6.replace(' ', ';');
        return string;
    }

    public void attrQueried(StorageEvent storageEvent) {
        if (this.m_ReqIds.get(storageEvent.getRequestId()) != null) {
            if (storageEvent.getRequestResult() == 0) {
                Vector vector = storageEvent.getAttrList();
                Enumeration enumeration = vector.elements();
                STAttribute sTAttribute = null;
                while (enumeration.hasMoreElements() && sTAttribute == null) {
                    STAttribute sTAttribute2 = (STAttribute)enumeration.nextElement();
                    if (sTAttribute2.getKey() != m_buddyListAttrKey) continue;
                    sTAttribute = sTAttribute2;
                }
                if (sTAttribute == null) {
                    return;
                }
                BL bL = this.readBuddyList(sTAttribute.getString());
                BLEvent bLEvent = new BLEvent((Object)this, 103, bL);
                this.sendEvent(bLEvent);
            } else {
                BLEvent bLEvent = new BLEvent((Object)this, 104, storageEvent.getRequestResult());
                this.sendEvent(bLEvent);
            }
        }
    }

    public void attrStored(StorageEvent storageEvent) {
        if (this.m_ReqIds.remove(storageEvent.getRequestId()) != null) {
            if (storageEvent.getRequestResult() == 0) {
                Vector vector = storageEvent.getAttrList();
                Enumeration enumeration = vector.elements();
                STAttribute sTAttribute = null;
                while (enumeration.hasMoreElements() && sTAttribute == null) {
                    STAttribute sTAttribute2 = (STAttribute)enumeration.nextElement();
                    if (sTAttribute2.getKey() != m_buddyListAttrKey) continue;
                    sTAttribute = sTAttribute2;
                }
                if (sTAttribute == null) {
                    return;
                }
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "attrStored", "BLServiceImple.attrStored : readBuddyList");
                }
                BL bL = this.readBuddyList(sTAttribute.getString());
                BLEvent bLEvent = new BLEvent((Object)this, 105, bL);
                this.sendEvent(bLEvent);
            } else {
                BLEvent bLEvent = new BLEvent(this, 106);
                this.sendEvent(bLEvent);
            }
        }
    }

    public void serviceAvailable(StorageEvent storageEvent) {
        BLEvent bLEvent = new BLEvent(this, 102);
        this.sendEvent(bLEvent);
    }

    public void serviceUnavailable(StorageEvent storageEvent) {
        BLEvent bLEvent = new BLEvent(this, 101);
        this.sendEvent(bLEvent);
    }

    public void attrUpdated(StorageEvent storageEvent) {
        int[] nArray = storageEvent.getUpdatedKeys();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != m_buddyListAttrKey) continue;
            BLEvent bLEvent = new BLEvent(this, 107);
            this.sendEvent(bLEvent);
            break;
        }
    }

    protected String convertBLToString(BL bL) {
        if (bL == null) {
            BLEvent bLEvent = new BLEvent(this, 106);
            this.sendEvent(bLEvent);
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version=3.1.3");
        stringBuffer.append("\r\n");
        if (bL.getblGroups() != null) {
            Enumeration enumeration = bL.getblGroups().elements();
            while (enumeration.hasMoreElements()) {
                PrivateGroup privateGroup;
                BLGroup bLGroup = (BLGroup)enumeration.nextElement();
                String string = this.createGroupString(bLGroup);
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
                if (!(bLGroup instanceof PrivateGroup) || (privateGroup = (PrivateGroup)bLGroup).getUsersInGroup() == null) continue;
                Enumeration enumeration2 = privateGroup.getUsersInGroup().elements();
                while (enumeration2.hasMoreElements()) {
                    BLUser bLUser = (BLUser)enumeration2.nextElement();
                    String string2 = this.createUserString(bLUser);
                    stringBuffer.append(string2);
                    stringBuffer.append("\r\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String convertBLToXML(BL bL) {
        if (bL == null) {
            BLEvent bLEvent = new BLEvent(this, 106);
            this.sendEvent(bLEvent);
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        BLXMLWriter bLXMLWriter = new BLXMLWriter(stringBuffer);
        bLXMLWriter.startDocument();
        bLXMLWriter.addCommunities(this.m_BLCommunityList);
        if (bL.getblGroups() != null) {
            Enumeration enumeration = bL.getblGroups().elements();
            while (enumeration.hasMoreElements()) {
                BLGroup bLGroup = (BLGroup)enumeration.nextElement();
                String string = "false";
                if (bLGroup.getGroupOpenStatus()) {
                    string = "true";
                }
                if (bLGroup instanceof PrivateGroup) {
                    PrivateGroup privateGroup = (PrivateGroup)bLGroup;
                    bLXMLWriter.startGroup(bLGroup.getBLId(), bLGroup.getName(), "private", string);
                    if (privateGroup.getUsersInGroup() != null) {
                        Enumeration enumeration2 = privateGroup.getUsersInGroup().elements();
                        while (enumeration2.hasMoreElements()) {
                            Object object;
                            BLUser bLUser = (BLUser)enumeration2.nextElement();
                            String string2 = bLUser.getName();
                            String string3 = bLUser.getNickName();
                            String string4 = null;
                            String string5 = null;
                            if (bLUser instanceof AimUser) {
                                object = (AimUser)bLUser;
                                string4 = ((AimUser)object).getBLId();
                                string5 = "AOL;Instant;Messenger";
                            } else {
                                object = (STUser)((Object)bLUser);
                                string4 = ((STObjectImpl)object).getId().getId();
                                string5 = ((STObjectImpl)object).getId().getCommunityName();
                            }
                            bLXMLWriter.addUser(this.getCommunityID(string5), string4, string2, string3);
                        }
                    }
                    bLXMLWriter.endGroup();
                    continue;
                }
                bLXMLWriter.startGroup(bLGroup.getBLId(), bLGroup.getName(), "public", string);
                bLXMLWriter.endGroup();
            }
        }
        bLXMLWriter.endDocument();
        return stringBuffer.toString();
    }

    public void setBuddyListAttrKey(int n) {
        m_buddyListAttrKey = n;
    }

    protected String getCommunityID(String string) {
        Object object;
        int n = 0;
        if (string.equals("")) {
            object = this.m_commService.getLogin();
            STServer sTServer = ((Login)object).getServer();
            string = sTServer.getName();
            string = "rat.lotus.com";
        }
        while (n < this.m_BLCommunityList.size()) {
            object = ((BLCommunity)this.m_BLCommunityList.elementAt((int)n)).m_name;
            if (string.equals(object)) {
                return ((BLCommunity)this.m_BLCommunityList.elementAt((int)n)).m_Id;
            }
            ++n;
        }
        return null;
    }

    protected String getCommunityServerType(String string) {
        for (int i = 0; i < this.m_BLCommunityList.size(); ++i) {
            String string2 = ((BLCommunity)this.m_BLCommunityList.elementAt((int)i)).m_name;
            if (!string.equals(string2)) continue;
            return ((BLCommunity)this.m_BLCommunityList.elementAt((int)i)).m_serverType;
        }
        return null;
    }

    protected String getCommunityName(String string) {
        for (int i = 0; i < this.m_BLCommunityList.size(); ++i) {
            String string2 = ((BLCommunity)this.m_BLCommunityList.elementAt((int)i)).m_Id;
            if (!string.equals(string2)) continue;
            return ((BLCommunity)this.m_BLCommunityList.elementAt((int)i)).m_name;
        }
        return "rat.lotus.com";
    }

    protected void addCommunity(String string, String string2, String string3) {
        Object object;
        int n = 0;
        if (string3.equals("")) {
            object = this.m_commService.getLogin();
            STServer sTServer = ((Login)object).getServer();
            string3 = sTServer.getName();
            string3 = "rat.lotus.com";
        }
        while (n < this.m_BLCommunityList.size()) {
            object = ((BLCommunity)this.m_BLCommunityList.elementAt((int)n)).m_name;
            if (string3.equals(object)) {
                return;
            }
            ++n;
        }
        if (string == null) {
            string = String.valueOf(this.m_BLCommunityList.size());
        }
        string2 = string2.equals("1") ? "sametime" : (string2.equals("2") ? "aol" : "sip");
        object = new BLCommunity(string, string2, string3);
        this.m_BLCommunityList.add(object);
    }
}

