/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hssf.usermodel;

import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class Hyperlinks {
    public static void main(String[] args) throws IOException {
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            HSSFCreationHelper helper = wb.getCreationHelper();
            HSSFCellStyle hlinkStyle = wb.createCellStyle();
            HSSFFont hlinkFont = wb.createFont();
            hlinkFont.setUnderline((byte)1);
            hlinkFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            hlinkStyle.setFont(hlinkFont);
            HSSFSheet sheet = wb.createSheet("Hyperlinks");
            HSSFCell cell = sheet.createRow(0).createCell(0);
            cell.setCellValue("URL Link");
            HSSFHyperlink link = helper.createHyperlink(HyperlinkType.URL);
            link.setAddress("https://poi.apache.org/");
            cell.setHyperlink(link);
            cell.setCellStyle(hlinkStyle);
            cell = sheet.createRow(1).createCell(0);
            cell.setCellValue("File Link");
            link = helper.createHyperlink(HyperlinkType.FILE);
            link.setAddress("link1.xls");
            cell.setHyperlink(link);
            cell.setCellStyle(hlinkStyle);
            cell = sheet.createRow(2).createCell(0);
            cell.setCellValue("Email Link");
            link = helper.createHyperlink(HyperlinkType.EMAIL);
            link.setAddress("mailto:poi@apache.org?subject=Hyperlinks");
            cell.setHyperlink(link);
            cell.setCellStyle(hlinkStyle);
            HSSFSheet sheet2 = wb.createSheet("Target Sheet");
            sheet2.createRow(0).createCell(0).setCellValue("Target Cell");
            cell = sheet.createRow(3).createCell(0);
            cell.setCellValue("Worksheet Link");
            link = helper.createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress("'Target Sheet'!A1");
            cell.setHyperlink(link);
            cell.setCellStyle(hlinkStyle);
            try (FileOutputStream out = new FileOutputStream("hssf-links.xls");){
                wb.write(out);
            }
        }
    }
}

