/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hpsf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class WriteAuthorAndTitle {
    private WriteAuthorAndTitle() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: WriteAuthorAndTitle originPOIFS destinationPOIFS");
            System.exit(1);
        }
        String srcName = args[0];
        String dstName = args[1];
        try (POIFSFileSystem poifs = new POIFSFileSystem();
             FileOutputStream out = new FileOutputStream(dstName);){
            POIFSReader r = new POIFSReader();
            r.registerListener(e -> WriteAuthorAndTitle.handleEvent(poifs, e));
            r.read(new File(srcName));
            poifs.writeFilesystem(out);
        }
    }

    private static void handleEvent(POIFSFileSystem poiFs, POIFSReaderEvent event) {
        DocumentInputStream stream = event.getStream();
        try {
            InputStreamSupplier isSup;
            if (PropertySet.isPropertySetStream(stream)) {
                PropertySet ps = PropertySetFactory.create(stream);
                if (ps.isSummaryInformation()) {
                    ps = new PropertySet(ps);
                    Section s = ps.getSections().get(0);
                    s.setProperty(4, 30L, "Rainer Klute");
                    s.setProperty(2, 31L, "Test");
                }
                isSup = ps::toInputStream;
            } else {
                isSup = event::getStream;
            }
            try (InputStream is = isSup.get();){
                POIFSDocumentPath path = event.getPath();
                DirectoryEntry de = poiFs.getRoot();
                for (int i = 0; i < path.length(); ++i) {
                    String subDir = path.getComponent(i);
                    de = de.hasEntryCaseInsensitive(subDir) ? (DirectoryEntry)de.getEntryCaseInsensitive(subDir) : de.createDirectory(subDir);
                }
                de.createDocument(event.getName(), is);
            }
        }
        catch (IOException | NoPropertySetStreamException | WritingNotSupportedException ex) {
            throw new HPSFRuntimeException("Could not read file " + event.getPath() + "/" + event.getName(), ex);
        }
    }

    private static interface InputStreamSupplier {
        public InputStream get() throws IOException, WritingNotSupportedException;
    }
}

