/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient.metadata;

import coldfusion.filter.FusionContext;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLClientImpl;
import coldfusion.graphql.graphqlClient.GraphQLSubscriptionCall;
import coldfusion.graphql.graphqlClient.PMTGraphQlApis;
import coldfusion.graphql.graphqlClient.PMTUtilsForGraphQlClient;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.runtime.async.Executor;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public class CFGraphQLSubscriptionCallHandler {
    private static final String GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID = "GRAPHQL_SUBSCRIPTION_CALL_ERROR";
    private Closure onResponse;
    private Closure onFailure;
    private Closure onTerminated;
    private Closure onConnected;
    private Closure onCompleted;
    private ApolloSubscriptionCall.Callback callback;
    private NeoPageContext pageContext;
    private FusionContext fusionContext;
    private RequestMonitorData rmd;
    private GraphQLSubscriptionCall graphQLSubscriptionCall;
    private Calendar calendar = DateUtils.getDefaultCalendar();

    public CFGraphQLSubscriptionCallHandler(final Closure onConnected, final Closure onResponse, final Closure onFailure, final Closure onCompleted, final Closure onTerminated, final FusionContext fusionContext, NeoPageContext neoPageContext, final GraphQLSubscriptionCall graphQLSubscriptionCall, final RequestMonitorData rmd) {
        this.onCompleted = onCompleted;
        this.onConnected = onConnected;
        this.onFailure = onFailure;
        this.onResponse = onResponse;
        this.onTerminated = onTerminated;
        this.graphQLSubscriptionCall = graphQLSubscriptionCall;
        this.rmd = rmd;
        try {
            this.pageContext = (NeoPageContext)this.pageContext.clone();
            this.fusionContext = (FusionContext)fusionContext.clone();
            this.fusionContext.hiddenScope = (Scope)fusionContext.hiddenScope.clone();
            this.pageContext.setFusionContext(this.fusionContext);
        }
        catch (Exception e) {
            this.pageContext = neoPageContext;
            this.fusionContext = fusionContext;
        }
        this.callback = new ApolloSubscriptionCall.Callback(){

            public void onResponse(@NotNull Response response) {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = response;
                    args[1] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onResponse, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onResponse]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onResponse);
                }
            }

            public void onFailure(@NotNull ApolloException apolloException) {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[1];
                try {
                    args[0] = apolloException;
                    args[1] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onFailure, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onFailure]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onFailure);
                }
            }

            public void onCompleted() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[1];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onCompleted, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onCompleted]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onCompleted);
                }
            }

            public void onTerminated() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onTerminated, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onTerminated]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onTerminated);
                }
            }

            public void onConnected() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onConnected, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onConnected]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onConnected);
                }
            }
        };
    }

    public CFGraphQLSubscriptionCallHandler(final Closure onResponse, final Closure onFailure, final Closure onCompleted, final FusionContext fusionContext, final GraphQLSubscriptionCall graphQLSubscriptionCall, NeoPageContext neoPageContext, final RequestMonitorData rmd) {
        this.onFailure = onFailure;
        this.onResponse = onResponse;
        this.onCompleted = onCompleted;
        try {
            this.pageContext = (NeoPageContext)this.pageContext.clone();
            this.fusionContext = (FusionContext)fusionContext.clone();
            this.fusionContext.hiddenScope = (Scope)fusionContext.hiddenScope.clone();
            this.pageContext.setFusionContext(this.fusionContext);
            this.rmd = rmd;
        }
        catch (Exception e) {
            this.pageContext = neoPageContext;
            this.fusionContext = fusionContext;
        }
        this.callback = new ApolloSubscriptionCall.Callback(){

            public void onResponse(@NotNull Response response) {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args = new Object[]{response, graphQLSubscriptionCall};
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onResponse, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onResponse]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onResponse);
                }
            }

            public void onFailure(@NotNull ApolloException apolloException) {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = apolloException;
                    args[1] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onFailure, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onFailure]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onFailure);
                }
            }

            public void onCompleted() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onCompleted, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onCompleted]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onCompleted);
                }
            }

            public void onTerminated() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)CFGraphQLSubscriptionCallHandler.this.onTerminated, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onTerminated]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onTerminated);
                }
            }

            public void onConnected() {
                long threadStartTime = CFGraphQLSubscriptionCallHandler.this.calendar.getTimeInMillis();
                Object[] args = new Object[2];
                try {
                    args[0] = graphQLSubscriptionCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)CFGraphQLSubscriptionCallHandler.this.onConnected, args, fusionContext, CFGraphQLSubscriptionCallHandler.this.pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)CFGraphQLSubscriptionCallHandler.GRAPHQL_SUBSCRIPTION_CALL_ERROR_ID, (Object)"[onConnected]"), ex);
                }
                finally {
                    PMTUtilsForGraphQlClient.subscriptionCallbacksMonitoring(args, rmd, threadStartTime, PMTGraphQlApis.GraphQL_Subscription_onConnected);
                }
            }
        };
    }

    public GraphQLSubscriptionCall getGraphQLCall() {
        return this.graphQLSubscriptionCall;
    }

    public ApolloSubscriptionCall.Callback getCallback() {
        return this.callback;
    }
}

