/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.security;

import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.AclConsumer;
import coldfusion.gcp.storage.consumer.DefaultAclConsumer;
import coldfusion.gcp.storage.consumer.EntityConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.EntityBuilder;
import coldfusion.runtime.Struct;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.util.List;
import java.util.Map;

public class AclSecurity {
    private static FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public static Struct createDefaultAcl(Storage storage, String bucketName, Map acl) {
        Struct response = new Struct();
        try {
            Acl.Builder aclBuilder = Acl.newBuilder(null, null);
            Map map = cast.getMapProperty((Object)acl);
            ValidatorFiller.INSTANCE.fillObject((Object)aclBuilder, map, (ConsumerMap)DefaultAclConsumer.getInstance());
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            Acl defaultAcl = bucket.createDefaultAcl(aclBuilder.build());
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"acl", (Object)defaultAcl.toString());
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct createAcl(Storage storage, String bucketName, Map acl) {
        Struct response = new Struct();
        try {
            Acl.Builder aclBuilder = Acl.newBuilder(null, null);
            Map map = cast.getMapProperty((Object)acl);
            ValidatorFiller.INSTANCE.fillObject((Object)aclBuilder, map, (ConsumerMap)AclConsumer.getInstance());
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            Acl newAcl = bucket.createAcl(aclBuilder.build());
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"acl", (Object)newAcl.toString());
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct createAcl(Storage storage, String bucketName, String blobName, Map acl) {
        Struct response = new Struct();
        try {
            Acl.Builder aclBuilder = Acl.newBuilder(null, null);
            Map map = cast.getMapProperty((Object)acl);
            ValidatorFiller.INSTANCE.fillObject((Object)aclBuilder, map, (ConsumerMap)AclConsumer.getInstance());
            Blob blob = storage.get(BlobId.of((String)bucketName, (String)blobName));
            Acl newAcl = blob.createAcl(aclBuilder.build());
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"acl", (Object)newAcl.toString());
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct deleteDefaultAcl(Storage storage, String bucketName, Map entity) {
        Struct response = new Struct();
        try {
            Map map = cast.getMapProperty((Object)entity);
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            EntityBuilder entityBuilder = new EntityBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, map, (ConsumerMap)EntityConsumer.getInstance());
            boolean deleted = bucket.deleteDefaultAcl(entityBuilder.getEntity());
            response.put((Object)"status", (Object)deleted);
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct deleteBucketAcl(Storage storage, String bucketName, Map entity) {
        Struct response = new Struct();
        try {
            Map map = cast.getMapProperty((Object)entity);
            EntityBuilder entityBuilder = new EntityBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, map, (ConsumerMap)EntityConsumer.getInstance());
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            boolean deleted = bucket.deleteAcl(entityBuilder.getEntity());
            response.put((Object)"status", (Object)deleted);
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct deleteObjectAcl(Storage storage, String bucketName, String blobName, Map entity) {
        Struct response = new Struct();
        try {
            Map map = cast.getMapProperty((Object)entity);
            EntityBuilder entityBuilder = new EntityBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, map, (ConsumerMap)EntityConsumer.getInstance());
            Blob blob = storage.get(BlobId.of((String)bucketName, (String)blobName));
            boolean deleted = blob.deleteAcl(entityBuilder.getEntity());
            response.put((Object)"status", (Object)deleted);
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct getBucketAcl(Storage storage, String bucketName, Map entity) {
        Struct response = new Struct();
        try {
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            if (entity != null) {
                Map map = cast.getMapProperty((Object)entity);
                EntityBuilder entityBuilder = new EntityBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, entity, (ConsumerMap)EntityConsumer.getInstance());
                Acl acl = bucket.getAcl(entityBuilder.getEntity());
                response.put((Object)"acl", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)acl));
            } else {
                List acl = bucket.getAcl();
                Struct aclStruct = new Struct();
                for (int i = 0; i < acl.size(); ++i) {
                    aclStruct.put((Object)(i + 1), (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson(acl.get(i)));
                }
                response.put((Object)"acl", (Object)aclStruct);
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct getObjectAcl(Storage storage, String bucketName, String blobName, Map entity) {
        Struct response = new Struct();
        try {
            Blob blob = storage.get(BlobId.of((String)bucketName, (String)blobName));
            if (entity != null) {
                Map map = cast.getMapProperty((Object)entity);
                EntityBuilder entityBuilder = new EntityBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, entity, (ConsumerMap)EntityConsumer.getInstance());
                Acl acl = blob.getAcl(entityBuilder.getEntity());
                response.put((Object)"acl", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)acl));
            } else {
                List acl = blob.getAcl();
                Struct aclStruct = new Struct();
                for (int i = 0; i < acl.size(); ++i) {
                    aclStruct.put((Object)(i + 1), (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson(acl.get(i)));
                }
                response.put((Object)"acl", (Object)aclStruct);
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }

    public static Struct getDefaultAcl(Storage storage, String bucketName, Map entity) {
        Struct response = new Struct();
        try {
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            if (entity != null) {
                Map map = cast.getMapProperty((Object)entity);
                EntityBuilder entityBuilder = new EntityBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)entityBuilder, entity, (ConsumerMap)EntityConsumer.getInstance());
                Acl acl = bucket.getDefaultAcl(entityBuilder.getEntity());
                response.put((Object)"acl", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)acl));
            } else {
                List acl = bucket.getDefaultAcl();
                Struct aclStruct = new Struct();
                for (int i = 0; i < acl.size(); ++i) {
                    aclStruct.put((Object)(i + 1), (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson(acl.get(i)));
                }
                response.put((Object)"acl", (Object)aclStruct);
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (Exception e) {
            throw new CFStorageException(e.getMessage(), e);
        }
        return response;
    }
}

