/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.BucketBoundHostNameConsumer;
import coldfusion.gcp.storage.request.BucketBoundHostNameBuilder;
import coldfusion.gcp.storage.request.SignUrlOptionBuilder;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.HttpMethod;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SignUrlOptionConsumer
extends ConsumerMap<SignUrlOptionBuilder> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static SignUrlOptionConsumer instance;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignUrlOptionConsumer getInstance() {
        if (instance != null) return instance;
        Class<SignUrlOptionConsumer> clazz = SignUrlOptionConsumer.class;
        synchronized (SignUrlOptionConsumer.class) {
            instance = new SignUrlOptionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SignUrlOptionConsumer() {
        this.put("key", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String objectName = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)objectName, (String)"key");
            signUrlOptionBuilder.setObjectName(objectName);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("duration", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            long duration = this.cast.getLongProperty(value);
            signUrlOptionBuilder.setDuration(duration);
        }, Collections.emptyList()));
        this.put("timeUnit", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String timeUnit = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)timeUnit, (String)"timeUnit");
            signUrlOptionBuilder.setTimeunit(TimeUnit.valueOf(timeUnit));
        }, Collections.emptyList()));
        this.put("httpMethod", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String httpMethod = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)httpMethod, (String)"httpMethod");
            signUrlOptionBuilder.setHttpMethod(HttpMethod.valueOf((String)httpMethod));
        }, Collections.emptyList()));
        this.put("signer", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String signer = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)signer, (String)"httpMethod");
            try {
                signUrlOptionBuilder.setSigner(ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(signer)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, Collections.emptyList()));
        this.put("withBucketBoundHostname", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            Map withBucketBoundHostName = this.cast.getMapProperty(value);
            BucketBoundHostNameBuilder builder = new BucketBoundHostNameBuilder();
            this.filler.fillObject((Object)builder, withBucketBoundHostName, (ConsumerMap)BucketBoundHostNameConsumer.getInstance());
            signUrlOptionBuilder.setWithBucketBoundHostname(builder.getBucketBoundHostName());
        }, Collections.emptyList()));
        this.put("withContentType", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            boolean withContentType = this.cast.getBooleanProperty(value);
            signUrlOptionBuilder.setWithContentType(withContentType);
        }, Collections.emptyList()));
        this.put("withExtHeaders", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            Map extHeaders = this.cast.getStringStringMapProperty(value);
            for (String key : extHeaders.keySet()) {
                String val = (String)extHeaders.get(key);
                ValidationUtil.validNonBlankString((String)key, (String)"withExtHeaders");
                ValidationUtil.validNonEmptyString((String)val, (String)"withExtHeaders");
            }
            signUrlOptionBuilder.setExtHeaders(extHeaders);
        }, Collections.emptyList()));
        this.put("hostName", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String hostName = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)hostName, (String)"hostName");
            signUrlOptionBuilder.setHostName(hostName);
        }, Collections.emptyList()));
        this.put("withMd5", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            boolean withMd5 = this.cast.getBooleanProperty(value);
            signUrlOptionBuilder.setWithMd5(withMd5);
        }, Collections.emptyList()));
        this.put("withPathStyle", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            boolean withPathStyle = this.cast.getBooleanProperty(value);
            signUrlOptionBuilder.setWithPathStyle(withPathStyle);
        }, Collections.emptyList()));
        this.put("queryParams", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            Map queryParams = this.cast.getStringStringMapProperty(value);
            for (String key : queryParams.keySet()) {
                String val = (String)queryParams.get(key);
                ValidationUtil.validNonBlankString((String)key, (String)"queryParams");
                ValidationUtil.validNonEmptyString((String)val, (String)"queryParams");
            }
            signUrlOptionBuilder.setQueryParams(queryParams);
        }, Collections.emptyList()));
        this.put("signatureVersion", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            String signatureVersion = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)signatureVersion, (String)"signatureVersion");
            signUrlOptionBuilder.setSignatureVersion(signatureVersion);
        }, Collections.emptyList()));
        this.put("withVirtualHostedStyle", new ConsumerValidator((signUrlOptionBuilder, value) -> {
            boolean withVirtualHostedStyle = this.cast.getBooleanProperty(value);
            signUrlOptionBuilder.setWithVirtualHostedStyle(withVirtualHostedStyle);
        }, Collections.emptyList()));
    }
}

