/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.ForceDeleteConsumer;
import coldfusion.gcp.storage.request.DeleteBucketRequest;
import coldfusion.gcp.storage.request.ForceDeleteBuilder;
import java.util.Collections;
import java.util.Map;

public class DeleteBucketRequestConsumer
extends ConsumerMap<DeleteBucketRequest> {
    private static final long serialVersionUID = 6141907758728112041L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static DeleteBucketRequestConsumer instance;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteBucketRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<DeleteBucketRequestConsumer> clazz = DeleteBucketRequestConsumer.class;
        synchronized (DeleteBucketRequestConsumer.class) {
            instance = new DeleteBucketRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DeleteBucketRequestConsumer() {
        this.put("bucketName", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            String bucketName = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)bucketName, (String)"bucketName");
            bucketDeleteBuilder.setBucketName(bucketName);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("metaGenerationMatch", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            long metaGenerationMatch = this.cast.getLongProperty(val);
            bucketDeleteBuilder.setMetagenerationMatch(metaGenerationMatch);
        }, Collections.emptyList()));
        this.put("metaGenerationNotMatch", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            long metaGenerationNotMatch = this.cast.getLongProperty(val);
            bucketDeleteBuilder.setMetagenerationNotMatch(metaGenerationNotMatch);
        }, Collections.emptyList()));
        this.put("versions", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            long version = this.cast.getLongProperty(val);
            bucketDeleteBuilder.setVersion(version);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            String userProject = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            bucketDeleteBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
        this.put("forceDelete", new ConsumerValidator((bucketDeleteBuilder, val) -> {
            Map map = this.cast.getStringStringMapProperty(val);
            ForceDeleteBuilder builder = new ForceDeleteBuilder();
            this.filler.fillObject((Object)builder, map, (ConsumerMap)ForceDeleteConsumer.getInstance());
            bucketDeleteBuilder.setTimeout(builder.getTimeout());
            bucketDeleteBuilder.setUnit(builder.getUnit());
        }, Collections.emptyList()));
    }
}

