/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.BlobTargetOptionBuilder;
import coldfusion.util.RB;
import java.security.Key;
import java.util.Collections;

public class BlobTargetOptionConsumer
extends ConsumerMap<BlobTargetOptionBuilder> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static BlobTargetOptionConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlobTargetOptionConsumer getInstance() {
        if (instance != null) return instance;
        Class<BlobTargetOptionConsumer> clazz = BlobTargetOptionConsumer.class;
        synchronized (BlobTargetOptionConsumer.class) {
            if (instance != null) return instance;
            instance = new BlobTargetOptionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BlobTargetOptionConsumer() {
        this.put("detectContentType", new ConsumerValidator((builder, value) -> {
            boolean detectContentType = this.cast.getBooleanProperty(value);
            builder.setDetectContentType(detectContentType);
        }, Collections.emptyList()));
        this.put("disableGzipContent", new ConsumerValidator((builder, value) -> {
            boolean disableGzipContent = this.cast.getBooleanProperty(value);
            builder.setDisableGzipContent(disableGzipContent);
        }, Collections.emptyList()));
        this.put("doesNotExist", new ConsumerValidator((builder, value) -> {
            boolean doesNotExist = this.cast.getBooleanProperty(value);
            builder.setDoesNotExist(doesNotExist);
        }, Collections.emptyList()));
        this.put("encryptionKey", new ConsumerValidator((builder, value) -> {
            if (value instanceof String) {
                String encryptionKey = this.cast.getStringProperty(value);
                ValidationUtil.validNonBlankString((String)encryptionKey, (String)"encryptionKey");
                builder.setEncryptionKey(encryptionKey);
            } else if (value instanceof Key) {
                builder.setEncryptionKey((Key)value);
            } else {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_ENCRYPTION_KEY"));
            }
        }, Collections.emptyList()));
        this.put("generationMatch", new ConsumerValidator((builder, value) -> {
            boolean generationMatch = this.cast.getBooleanProperty(value);
            builder.setGenerationMatch(generationMatch);
        }, Collections.emptyList()));
        this.put("generationNotMatch", new ConsumerValidator((builder, value) -> {
            boolean generationNotMatch = this.cast.getBooleanProperty(value);
            builder.setGenerationNotMatch(generationNotMatch);
        }, Collections.emptyList()));
        this.put("kmsKeyName", new ConsumerValidator((builder, value) -> {
            String kmsKeyName = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)kmsKeyName, (String)"kmsKeyName");
            builder.setKmsKeyName(kmsKeyName);
        }, Collections.emptyList()));
        this.put("metaGenerationMatch", new ConsumerValidator((builder, value) -> {
            boolean metagenerationMatch = this.cast.getBooleanProperty(value);
            builder.setMetagenerationMatch(metagenerationMatch);
        }, Collections.emptyList()));
        this.put("metaGenerationNotMatch", new ConsumerValidator((builder, value) -> {
            boolean metagenerationNotMatch = this.cast.getBooleanProperty(value);
            builder.setMetagenerationNotMatch(metagenerationNotMatch);
        }, Collections.emptyList()));
        this.put("acl", new ConsumerValidator((builder, value) -> {
            String acl = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)acl, (String)"acl");
            builder.setAcl(acl);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((builder, value) -> {
            String userProject = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            builder.setUserProject(userProject);
        }, Collections.emptyList()));
    }
}

