/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.CFCMetadata;
import coldfusion.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class CFCMetadataImpl
implements CFCMetadata {
    private ClassMetadata classMetaData;
    private PersistentClass mappingInfo;
    private Map<String, String> fieldNames = new CaseInsensitiveMap();
    private Map<String, String> pkFields = new CaseInsensitiveMap();
    private Map<String, Type> pkFieldVsTypes = new CaseInsensitiveMap();
    private List<String> pkFieldNames;
    private boolean hasCompositeKey;
    private List<String> colProperties;

    public CFCMetadataImpl(ClassMetadata classMetaData, PersistentClass mappingInfo) {
        this.classMetaData = classMetaData;
        this.mappingInfo = mappingInfo;
        String[] names = classMetaData.getPropertyNames();
        for (String name : names) {
            this.fieldNames.put(name, name);
        }
        this.initPKFields();
        if (this.pkFieldNames != null) {
            for (String name : this.pkFieldNames) {
                this.pkFields.put(name, name);
            }
        }
    }

    @Override
    public String getEntityName() {
        return this.classMetaData.getEntityName();
    }

    public ClassMetadata getClassMetaData() {
        return this.classMetaData;
    }

    @Override
    public String getPropertyName(String fieldName) {
        String prop = this.fieldNames.get(fieldName);
        if (prop == null) {
            prop = this.pkFields.get(fieldName);
        }
        return prop;
    }

    @Override
    public Class getPropertyType(String fieldName) {
        String prop = this.fieldNames.get(fieldName);
        Type type = prop != null ? this.classMetaData.getPropertyType(prop) : this.pkFieldVsTypes.get(fieldName);
        if (type != null) {
            return type.getReturnedClass();
        }
        return null;
    }

    @Override
    public List<String> getPKFieldNames() {
        return this.pkFieldNames;
    }

    @Override
    public List<String> getColumnPropertyNames() {
        if (this.colProperties != null) {
            return this.colProperties;
        }
        this.colProperties = new ArrayList<String>();
        String[] names = this.classMetaData.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Type type = this.classMetaData.getPropertyType(name);
            if (type instanceof EntityType || type instanceof CollectionType) continue;
            this.colProperties.add(name);
        }
        return this.colProperties;
    }

    @Override
    public List<String> getPropertyNames() {
        String[] names = this.classMetaData.getPropertyNames();
        return Arrays.asList(names);
    }

    private void initPKFields() {
        if (this.mappingInfo.hasIdentifierProperty()) {
            this.pkFieldNames = new ArrayList<String>();
            Property identifierProperty = this.mappingInfo.getIdentifierProperty();
            String pkName = identifierProperty.getName();
            this.pkFieldNames.add(pkName);
            this.pkFieldVsTypes.put(pkName, identifierProperty.getType());
        } else {
            KeyValue compositePK = this.mappingInfo.getIdentifier();
            if (compositePK != null && compositePK instanceof Component) {
                this.hasCompositeKey = true;
                this.pkFieldNames = new ArrayList<String>();
                Iterator iter = ((Component)compositePK).getPropertyIterator();
                while (iter.hasNext()) {
                    Property property = (Property)iter.next();
                    String name = property.getName();
                    this.pkFieldNames.add(name);
                    this.pkFieldVsTypes.put(name, property.getType());
                }
            }
        }
        if (this.pkFieldNames != null) {
            this.pkFieldNames = Collections.unmodifiableList(this.pkFieldNames);
        }
    }

    public boolean isPKField(String pkField) {
        return this.pkFields.containsKey(pkField);
    }

    public String getPKFieldName(String pkField) {
        return this.pkFields.get(pkField);
    }

    public boolean hasCompositePrimaryKey() {
        return this.hasCompositeKey;
    }

    public boolean isCacheEnabled() {
        return this.mappingInfo.getCacheConcurrencyStrategy() != null;
    }
}

