/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DTextNode;
import ice.storm.DynEnv;
import ice.util.alg.Bidi;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLOptionElement;

public class DOptionElement
extends DElement
implements HTMLOptionElement {
    static final int SELECTION_AS_DEFAULT = 0;
    static final int SELECTION_ON = 1;
    static final int SELECTION_OFF = 2;
    int selection_state = 0;
    private static final int Field_defaultSelected = 1;
    private static final int Field_disabled = 2;
    private static final int Field_form = 3;
    private static final int Field_index = 4;
    private static final int Field_label = 5;
    private static final int Field_selected = 6;
    private static final int Field_text = 7;
    private static final int Field_value = 8;

    protected DOptionElement(DDocument d, int id) {
        super(d, id);
    }

    protected void onDAttrValueChange(DAttr attr) {
        DSelectElement.SelectPainter sel;
        if (this.parent instanceof DSelectElement && (sel = ((DSelectElement)this.parent).getSelectPainter()) != null) {
            sel.onOptionAttrChange(this, attr);
        }
        super.onDAttrValueChange(attr);
    }

    public final HTMLFormElement getForm() {
        return this.getDForm();
    }

    protected DFormElement getDForm() {
        return DFormElement.parentForm(this);
    }

    void setAttributes(int[] names, String[] values, int num) {
        super.setAttributes(names, values, num);
        this.selection_state = 0;
    }

    public boolean getDefaultSelected() {
        return this.getAttribute(98) != null;
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.setAttribute(98, defaultSelected ? "selected" : null);
    }

    public String getText() {
        Node n = this.getFirstChild();
        if (n instanceof DTextNode) {
            DTextNode tn = (DTextNode)n;
            if (tn.doc.charsetId != 0) {
                Bidi bidi = Bidi.createBidi(tn.doc.charsetId, tn.text, 0, tn.text.length);
                return bidi.getString();
            }
            return tn.getData();
        }
        return null;
    }

    public final String getTextOrEmptyString() {
        String result = this.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    private String script_getText() {
        String result = this.getText();
        result = result != null ? result.trim() : "";
        return result;
    }

    void setText(String text) {
        DNode n = this.getFirstDChild();
        if (n instanceof DTextNode) {
            DTextNode textNode = (DTextNode)n;
            textNode.setData(text);
        } else {
            this.insertDChildBefore(this.doc.createDTextNode(text), n);
        }
    }

    public int getIndex() {
        return -1;
    }

    public void setIndex(int index) {
    }

    public boolean getDisabled() {
        return false;
    }

    public void setDisabled(boolean disabled) {
    }

    public String getLabel() {
        return this.getAttribute(52);
    }

    public void setLabel(String label) {
        this.setAttribute(52, label);
    }

    String getValueOrText() {
        String val = this.getValue();
        if (val == null) {
            val = this.getText();
        }
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public boolean getSelected() {
        boolean result = this.selection_state == 1 ? true : (this.selection_state == 2 ? false : this.getDefaultSelected());
        return result;
    }

    public String getValue() {
        return this.getAttribute(114);
    }

    private String script_getValue() {
        String result = this.getValue();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setValue(String value) {
        this.setAttribute(114, value);
    }

    public void setSelected(boolean selected) {
        DNode parent;
        boolean old = this.getSelected();
        if (old != selected && (parent = this.parent) instanceof DSelectElement) {
            DSelectElement sel = (DSelectElement)parent;
            sel.setOptionSelection(this, selected);
        }
    }

    void do_setSelected(boolean selected) {
        this.selection_state = selected ? 1 : 2;
    }

    final void setSelectionAsDefault() {
        this.selection_state = 0;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DOptionElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DOptionElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.getDefaultSelected());
            }
            case 2: {
                return env.wrapBoolean(this.getDisabled());
            }
            case 3: {
                return this.getDForm();
            }
            case 4: {
                return env.wrapInt(this.getIndex());
            }
            case 5: {
                return this.getLabel();
            }
            case 6: {
                return env.wrapBoolean(this.getSelected());
            }
            case 7: {
                return this.script_getText();
            }
            case 8: {
                return this.script_getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setDefaultSelected(env.toBoolean(value));
                return 1;
            }
            case 2: {
                this.setDisabled(env.toBoolean(value));
                return 1;
            }
            case 3: {
                break;
            }
            case 4: {
                this.setIndex(env.toInt(value));
                return 1;
            }
            case 5: {
                this.setLabel(env.toStr(value));
                return 1;
            }
            case 6: {
                this.setSelected(env.toBoolean(value));
                return 1;
            }
            case 7: {
                this.setText(env.toStr(value));
                return 1;
            }
            case 8: {
                this.setValue(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                char c = s.charAt(0);
                if (c == 'f') {
                    guess = "form";
                    id = 3;
                    break;
                }
                if (c != 't') break;
                guess = "text";
                id = 7;
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'i') {
                    guess = "index";
                    id = 4;
                    break;
                }
                if (c == 'l') {
                    guess = "label";
                    id = 5;
                    break;
                }
                if (c != 'v') break;
                guess = "value";
                id = 8;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "disabled";
                    id = 2;
                    break;
                }
                if (c != 's') break;
                guess = "selected";
                id = 6;
                break;
            }
            case 15: {
                guess = "defaultSelected";
                id = 1;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

