/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache.ehcache;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.util.CaseInsensitiveHashtable;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.management.sampled.SampledCache;
import net.sf.ehcache.statistics.StatisticsGateway;

public class GenericEhcache
extends GenericCache {
    private static final String GETAVGGETTIME = "GETAVGGETTIME";
    private static final String GETEVICTIONCOUNT = "GETEVICTIONCOUNT";
    private String configFilePath = null;
    private CacheManager cacheManager = null;
    private String applicationName = null;
    private static List<String> filteredOutProperties;
    private static Boolean filteredOutPropertiesinitialized;
    private static Method[] cacheConfigurationMethods;

    public GenericEhcache() {
    }

    public GenericEhcache(String configFilePath, String applicationName) {
        if (configFilePath != null) {
            this.configFilePath = configFilePath.trim();
        }
        this.applicationName = applicationName;
    }

    public Object get(CacheTO xObj, boolean throwError, Long within) {
        Cache cache = this.getCache(xObj, throwError);
        if (cache != null) {
            Element element = null;
            element = xObj.getQuiet ? cache.getQuiet(xObj.id) : cache.get(xObj.id);
            if (element != null && (within == null || System.currentTimeMillis() < element.getCreationTime() + within)) {
                return element.getObjectValue();
            }
        }
        return null;
    }

    public Object get(CacheTO xObj, boolean throwError) {
        Cache cache = this.getCache(xObj, throwError);
        if (cache != null) {
            Element element = null;
            element = xObj.getQuiet ? cache.getQuiet(xObj.id) : cache.get(xObj.id);
            if (element != null) {
                try {
                    if ("TEMPLATE".equalsIgnoreCase(xObj.objecttype)) {
                        String canonicalPath = FusionContext.getCurrent().getPagePath();
                        long lastModified = ServiceFactory.getRuntimeService().isTrustedCache() ? TemplateClassLoader.getCompiledTime((String)canonicalPath) : TemplateClassLoader.getLastModifiedTime((String)canonicalPath);
                        xObj.getQuiet = true;
                        long checkTime = this.getUpdateTimeOfElement(xObj);
                        if (lastModified > checkTime) {
                            return null;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return element.getObjectValue();
            }
        }
        return null;
    }

    public long getUpdateTimeOfElement(CacheTO xObj) {
        Cache cache = this.getCache(xObj, false);
        Element element = null;
        element = xObj.getQuiet ? cache.getQuiet(xObj.id) : cache.get(xObj.id);
        return element.getLastUpdateTime() == 0L ? element.getCreationTime() : element.getLastUpdateTime();
    }

    public Map getMetadata(CacheTO xObj) {
        Element element;
        CaseInsensitiveHashtable result = new CaseInsensitiveHashtable();
        Cache cache = this.getCache(xObj, true);
        if (cache != null && (element = cache.getQuiet(xObj.id)) != null) {
            StatisticsGateway stats = cache.getStatistics();
            String cacheName = cache.getName();
            if (xObj.appname != null && cacheName.startsWith(xObj.appname)) {
                cacheName = cacheName.substring(cacheName.indexOf(xObj.appname) + xObj.appname.length());
            }
            result.put("NAME", cacheName);
            result.put("TIMESPAN", new Long(element.getTimeToLive()));
            result.put("IDLETIME", new Long(element.getTimeToIdle()));
            result.put("HITCOUNT", new Long(element.getHitCount()));
            result.put("CACHE_MISSCOUNT", new Long(stats.cacheMissCount()));
            result.put("CACHE_HITCOUNT", new Long(stats.cacheHitCount()));
            result.put("SIZE", new Long(element.getSerializedSize()));
            result.put("CREATEDTIME", new OleDateTime(element.getCreationTime()));
            long lastAccessTime = element.getLastAccessTime();
            if (lastAccessTime > 0L) {
                result.put("LASTHIT", new OleDateTime(lastAccessTime));
            } else {
                result.put("LASTHIT", "");
            }
            long lastUpdateTime = element.getLastUpdateTime();
            if (lastUpdateTime > 0L) {
                result.put("LASTUPDATED", new OleDateTime(lastUpdateTime));
            } else {
                result.put("LASTUPDATED", "");
            }
        }
        return result;
    }

    public Cache getCache(final String appname, final String objecttype, final String key) {
        if (System.getSecurityManager() == null) {
            return this._getCache(appname, objecttype, key);
        }
        try {
            return (Cache)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String appN = appname;
                    String objType = objecttype;
                    return GenericEhcache.this._getCache(appN, objType, key);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (CacheException)e.getException();
        }
    }

    private Cache _getCache(String appname, String objecttype, String key) {
        String mgrKey = CacheTagHelper.getCacheKey((String)key, (String)appname, (String)objecttype, (String)this.configFilePath);
        Cache cache = null;
        CacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null) {
            String calcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
            cache = cacheManager.getCache(calcKey);
        }
        return cache;
    }

    public void removeCache(String cacheName) {
        if (cacheName != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)cacheName)) {
                throw new CacheExceptions.ImpicitCacheRegionDeletionException(cacheName);
            }
            CacheManager mgr = this.getCacheManager();
            String key = CacheTagHelper.getCacheKey((String)cacheName, (String)FusionContext.getCurrent().getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
            Cache cache = mgr.getCache(cacheName);
            if (cache == null) {
                throw new CacheExceptions.CacheNotFoundException(cacheName);
            }
            mgr.removeCache(cacheName);
        }
    }

    public boolean remove(CacheTO xObj) {
        Cache cache = this.getCache(xObj, true);
        if (cache != null) {
            if (xObj.id != null) {
                Object keyHash = xObj.id;
                if (xObj.exact && cache.isKeyInCache(keyHash)) {
                    return cache.remove(keyHash);
                }
                if (!xObj.exact && keyHash instanceof String) {
                    Object[] cacheNames;
                    boolean cacheDeleted = false;
                    Object[] objectArray = cacheNames = cache.getKeys() != null ? cache.getKeys().toArray() : null;
                    if (cacheNames != null) {
                        String matchCriteria = CacheTagHelper.createMatchCriteria((String)((String)keyHash));
                        for (int i = 0; i < cacheNames.length; ++i) {
                            if (!(cacheNames[i] instanceof String) || CFPage.REFindNoCase((String)matchCriteria, (String)CacheTagHelper.createMatchCriteria((String)((String)cacheNames[i]))) <= 0) continue;
                            cache.remove((Serializable)((Object)((String)cacheNames[i])));
                            cacheDeleted = true;
                        }
                        return cacheDeleted;
                    }
                }
            } else if (!xObj.exact) {
                cache.removeAll();
                return true;
            }
        }
        return false;
    }

    public void put(CacheTO xObj, boolean throwOnError) {
        Cache cache = this.getCache(xObj, throwOnError);
        Element element = new Element(xObj.id, xObj.value);
        CacheConfiguration config = cache.getCacheConfiguration();
        if (xObj.timetoidle > 0L) {
            element.setTimeToIdle((int)xObj.timetoidle);
        } else if (xObj.timetoidle < 0L) {
            element.setTimeToIdle((int)config.getTimeToIdleSeconds());
        }
        if (xObj.timetoLive > 0L) {
            element.setTimeToLive((int)xObj.timetoLive);
        } else if (xObj.timetoLive < 0L) {
            element.setTimeToLive((int)config.getTimeToLiveSeconds());
        }
        if (xObj.eternal) {
            element.setEternal(true);
        } else if (xObj.timetoidle == 0L && xObj.timetoLive == 0L) {
            element.setEternal(true);
        }
        cache.put(element);
    }

    private Cache getCache(final CacheTO xObj, final boolean throwError) {
        if (System.getSecurityManager() == null) {
            return this._getCache(xObj, throwError);
        }
        try {
            return (Cache)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return GenericEhcache.this._getCache(xObj, throwError);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (CacheException)e.getException();
        }
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            try {
                if (this.configFilePath != null) {
                    if (this.configFilePath.equals("")) {
                        throw new CacheExceptions.InvalidCacheConfigFileException();
                    }
                    this.configFilePath = CacheTagHelper.resolveConfigFilePath((String)this.configFilePath);
                    Configuration config = ConfigurationFactory.parseConfiguration((File)new File(this.configFilePath));
                    if (config == null) {
                        throw new CacheException();
                    }
                    if (this.applicationName != null && !this.applicationName.equals("") && (config.getName() == null || config.getName().equalsIgnoreCase("__DEFAULT__"))) {
                        config.setName(this.applicationName);
                    }
                    this.cacheManager = new CacheManager(config);
                    if (this.cacheManager == null) {
                        throw new CacheException();
                    }
                } else {
                    this.cacheManager = AccessController.doPrivileged(new PrivilegedAction<CacheManager>(){

                        @Override
                        public CacheManager run() {
                            return CacheManager.getInstance();
                        }
                    });
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
                throw new CacheExceptions.CacheInitializationException(e.getMessage());
            }
        }
        return this.cacheManager;
    }

    private Cache _getCache(CacheTO xObj, boolean throwError) {
        String mgrKey = CacheTagHelper.getCacheKey((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        Cache cache = this.getCacheManager().getCache(mgrKey);
        if (cache != null) {
            return cache;
        }
        if (cache == null && throwError && xObj.region != null && !xObj.region.equalsIgnoreCase("OBJECT") && !xObj.region.equalsIgnoreCase("QUERY") && !xObj.region.equalsIgnoreCase("TEMPLATE")) {
            throw new CacheExceptions.CacheNotFoundException(xObj.region);
        }
        cache = xObj.directory != null ? (Cache)this.createCache(xObj.region, xObj.objecttype, xObj.directory, null) : (Cache)this.createCache(xObj.region, xObj.objecttype, null, null);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createCache(String mgrKey, String objType, String diskStore, Map properties) {
        String mgrCalcKey;
        Cache cache;
        if (mgrKey != null && mgrKey.trim().length() == 0) {
            throw new CacheExceptions.InvalidCacheNameException();
        }
        CacheManager cacheManager = this.getCacheManager();
        String appName = null;
        FusionContext context = FusionContext.getCurrent();
        if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        if ((cache = cacheManager.getCache(mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)(mgrKey = CacheTagHelper.getCacheKey((String)mgrKey, (String)appName, (String)objType, (String)this.configFilePath))))) == null) {
            CacheManager cacheManager2 = cacheManager;
            synchronized (cacheManager2) {
                cache = cacheManager.getCache(mgrCalcKey);
                if (cache == null) {
                    cacheManager.addCache(mgrCalcKey);
                    cache = cacheManager.getCache(mgrCalcKey);
                    if (diskStore != null || properties != null) {
                        CacheConfiguration config = cache.getCacheConfiguration();
                        Cache newCache = new Cache(cache.getName(), config.getMaxElementsInMemory(), config.isOverflowToDisk(), config.isEternal(), config.getTimeToLiveSeconds(), config.getTimeToIdleSeconds());
                        if (diskStore != null) {
                            CacheConfiguration newConfig = newCache.getCacheConfiguration();
                            if (properties == null) {
                                this.setOldConfiguration(newConfig, config);
                            }
                        }
                        if (properties != null) {
                            this.setPropertyOnCache(newCache, null, properties);
                        }
                        cacheManager.removeCache(mgrCalcKey);
                        cacheManager.addCache(newCache);
                        this.createEvictHandler(newCache);
                        return newCache;
                    }
                    this.createEvictHandler(cache);
                }
            }
        } else if (properties != null) {
            CacheConfiguration config = cache.getCacheConfiguration();
            this.setPropertyOnCache(cache, null, properties);
        }
        return cache;
    }

    private void createEvictHandler(Cache cache) {
        final Cache finalCache = cache;
        Runnable CacheEvictionHandler = new Runnable(){

            @Override
            public void run() {
                finalCache.evictExpiredElements();
            }
        };
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(CacheEvictionHandler, 0L, 240L, TimeUnit.SECONDS);
    }

    public boolean cacheExists(String region) {
        CacheManager cacheManager = this.getCacheManager();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey((String)region, (String)fContext.getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
        }
        return cacheManager.getCache(region) != null;
    }

    private void setOldConfiguration(CacheConfiguration newConfig, CacheConfiguration config) {
        newConfig.setEternal(config.isEternal());
        newConfig.setDiskPersistent(config.isDiskPersistent());
        newConfig.setMaxElementsOnDisk(config.getMaxElementsOnDisk());
        newConfig.setDiskSpoolBufferSizeMB(config.getDiskSpoolBufferSizeMB());
        newConfig.setDiskExpiryThreadIntervalSeconds(config.getDiskExpiryThreadIntervalSeconds());
        newConfig.setMemoryStoreEvictionPolicy(config.getMemoryStoreEvictionPolicy().toString());
    }

    public List getAllCacheIds(CacheTO xObj, boolean accurate) {
        Cache cache = this.getCache(xObj, true);
        if (cache != null) {
            List res = null;
            res = accurate ? cache.getKeysWithExpiryCheck() : cache.getKeys();
            if (res.size() == 0) {
                cache.putQuiet(new Element((Serializable)((Object)"test"), (Serializable)((Object)"test")));
                cache.removeQuiet((Serializable)((Object)"test"));
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    public Object getMetadata() {
        return null;
    }

    public List getObjectCacheMetadata(String appName) {
        ArrayList<Struct> result = new ArrayList<Struct>();
        if (appName != null) {
            Cache cache = this.getCache(appName, "OBJECT", null);
            result.add(this.populatePerAppMetadata(cache, appName));
            return result;
        }
        String[] cacheNames = this.getCacheManager().getCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("OBJECT"));
            Cache cache = this.getCache(appName, "OBJECT", null);
            result.add(this.populatePerAppMetadata(cache, appName));
        }
        return result;
    }

    public Struct populatePerAppMetadata(Cache cache, String appName) {
        Struct resultObj = new Struct();
        if (cache != null) {
            StatisticsGateway stats = cache.getStatistics();
            resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
            long cacheHits = stats.cacheHitCount();
            long missCountNotFound = stats.cacheMissCount();
            if (cacheHits == 0L) {
                resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
            } else {
                resultObj.put((Object)"HITRATIO", (Object)new Double((double)cacheHits / (double)(missCountNotFound + cacheHits)));
            }
            resultObj.put((Object)"CACHE_MISSCOUNT", (Object)new Long(missCountNotFound));
            resultObj.put((Object)"CACHE_HITCOUNT", (Object)new Long(cacheHits));
            long cummSize = 0L;
            ArrayList<Struct> objects = new ArrayList<Struct>();
            List objKeys = cache.getKeys();
            if (objKeys != null) {
                for (int i = 0; i < objKeys.size(); ++i) {
                    Element e = cache.getQuiet(objKeys.get(i));
                    if (e == null) continue;
                    Struct objMeta = new Struct();
                    objMeta.put((Object)"ID", (Object)e.getKey());
                    objMeta.put((Object)"SIZE", (Object)new Long(e.getSerializedSize()));
                    objMeta.put((Object)"HITCOUNT", (Object)new Long(e.getHitCount()));
                    objects.add(objMeta);
                    cummSize += e.getSerializedSize();
                }
            }
            resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
            resultObj.put((Object)"NUMBER", (Object)new Long(objects.size()));
            resultObj.put((Object)"OBJECTS", objects);
        }
        return resultObj;
    }

    public List getTemplateCacheMetadata(String appName) {
        ArrayList<Struct> result = new ArrayList<Struct>();
        if (appName != null) {
            appName = appName.trim();
            Cache cache = this.getCache(appName, "TEMPLATE", null);
            result.add(this.populatePerAppTemplateMetadata(cache, appName));
            return result;
        }
        String[] cacheNames = this.getCacheManager().getCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("TEMPLATE") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("TEMPLATE"));
            Cache cache = this.getCache(appName, "TEMPLATE", null);
            result.add(this.populatePerAppTemplateMetadata(cache, appName));
        }
        return result;
    }

    private Struct populatePerAppTemplateMetadata(Cache cache, String appName) {
        Struct resultObj = new Struct();
        if (cache != null) {
            StatisticsGateway stats = cache.getStatistics();
            resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
            long cacheHits = stats.cacheHitCount();
            long missCountNotFound = stats.cacheMissCount();
            if (cacheHits == 0L) {
                resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
            } else {
                resultObj.put((Object)"HITRATIO", (Object)new Double((double)cacheHits / (double)(missCountNotFound + cacheHits)));
            }
            resultObj.put((Object)"CACHE_MISSCOUNT", (Object)new Long(missCountNotFound));
            resultObj.put((Object)"CACHE_HITCOUNT", (Object)new Long(cacheHits));
            resultObj.put((Object)"NUMBER", (Object)new Long(cache.getSize()));
            long cummSize = 0L;
            List objKeys = cache.getKeys();
            if (objKeys != null) {
                for (int i = 0; i < objKeys.size(); ++i) {
                    Element e = cache.getQuiet(objKeys.get(i));
                    if (e == null) continue;
                    cummSize += e.getSerializedSize();
                }
            }
            resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
        }
        return resultObj;
    }

    public void setCacheProperties(Map map, String region) {
        if (map != null && map instanceof Struct) {
            String appName = FusionContext.getCurrent().getApplicationName();
            String objectType = this.toStringValue(map.get("OBJECTTYPE"), "ALL").trim();
            String cacheName = null;
            if (region == null && CacheTagHelper.isStandardCacheRegion((String)objectType)) {
                region = objectType;
            }
            if (region == null && "ALL".equalsIgnoreCase(objectType)) {
                Cache cache = null;
                cacheName = CacheTagHelper.getCacheKey(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
                cacheName = CacheTagHelper.getCacheKey(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
                cacheName = CacheTagHelper.getCacheKey(null, (String)appName, (String)"QUERY", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
            } else {
                Cache cache = null;
                if (region != null && (region.equalsIgnoreCase("OBJECT") || region.equalsIgnoreCase("QUERY") || region.equalsIgnoreCase("TEMPLATE"))) {
                    region = region.toUpperCase();
                    cacheName = CacheTagHelper.getCacheKey((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                } else {
                    cacheName = CacheTagHelper.getCacheKey((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                    cache = this.getCacheManager().getCache(cacheName);
                    if (cache == null) {
                        throw new CacheExceptions.CacheNotFoundException(region);
                    }
                }
                this.setPropertyOnCache(cache, cacheName, map);
            }
        }
    }

    public void setMaxElementsInMemory(String cacheKey, int count) {
        if (this.getCacheManager().getCache(cacheKey) != null) {
            this.getCacheManager().getCache(cacheKey).getCacheConfiguration().setMaxElementsInMemory(count);
        }
    }

    private void setPropertyOnCache(Cache cacheObj, String cacheName, Map map) {
        String mgrCalcKey;
        CacheManager cacheManager;
        Cache cache = cacheObj;
        if (cache == null && cacheName != null && (cache = (cacheManager = this.getCacheManager()).getCache(mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)cacheName))) == null) {
            cacheManager.addCache(mgrCalcKey);
            cache = cacheManager.getCache(mgrCalcKey);
        }
        if (cache != null && map != null) {
            CacheConfiguration cacheConfig;
            Method[] methods;
            Object val = (map = new CaseInsensitiveHashtable(map)).get("MEMORYEVICTIONPOLICY");
            if (val != null) {
                map.put("MEMORYSTOREEVICTIONPOLICY", val);
                map.remove("MEMORYEVICTIONPOLICY");
            }
            if ((val = map.get("DISKSTORE")) != null) {
                map.put("DISKSTOREPATH", val);
                map.remove("DISKSTORE");
            }
            if (map.get("MAXENTRIESLOCALHEAP") != null) {
                map.put("MAXELEMENTSINMEMORY", map.get("MAXENTRIESLOCALHEAP"));
            }
            if ((methods = this.getCacheConfigurationMethods(cacheConfig = cache.getCacheConfiguration())) != null) {
                Set keys = map.keySet();
                HashMap<String, String> keyMap = new HashMap<String, String>();
                if (keys != null) {
                    Iterator itr = keys.iterator();
                    String keyName = null;
                    while (itr.hasNext()) {
                        keyName = (String)itr.next();
                        keyMap.put(keyName.toUpperCase(), keyName);
                    }
                }
                for (Method method : methods) {
                    String methodName = method.getName();
                    if (!methodName.startsWith("set")) continue;
                    methodName = methodName.substring(3);
                    if (GenericEhcache.getPopertiesToFilterOut().contains(methodName.toUpperCase()) || keyMap.get(methodName.toUpperCase()) == null) continue;
                    try {
                        Method getter = null;
                        Object oldVal = null;
                        try {
                            getter = method.getParameterTypes()[0].getSimpleName().equalsIgnoreCase("boolean") ? cacheConfig.getClass().getMethod("is" + methodName, null) : cacheConfig.getClass().getMethod("get" + methodName, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (getter != null) {
                            oldVal = getter.invoke((Object)cacheConfig, null);
                        }
                        String keyName = (String)keyMap.get(methodName.toUpperCase());
                        Object value = null;
                        value = methodName.equalsIgnoreCase("MEMORYSTOREEVICTIONPOLICY") ? (Object)map.get("MEMORYSTOREEVICTIONPOLICY") : (methodName.equalsIgnoreCase("DISKSTOREPATH") ? this.toStringValue(map.get("DISKSTOREPATH"), null) : this.getCastedValue(map.get(keyName), method.getParameterTypes()[0], oldVal));
                        if (value == null) continue;
                        if (oldVal != null) {
                            if ((oldVal = this.getCastedValue(oldVal, method.getParameterTypes()[0], oldVal)) != null && (oldVal == null || oldVal.equals(value))) continue;
                            method.invoke((Object)cacheConfig, value);
                            continue;
                        }
                        method.invoke((Object)cacheConfig, value);
                    }
                    catch (Exception e) {
                        CacheExceptions.throwInvalidCacheSettingsException((Exception)e);
                    }
                }
            }
        }
    }

    private Map<String, Object> getCacheProperties(CacheConfiguration config) {
        Method[] methods;
        HashMap<String, Object> cacheConfigMap = new HashMap<String, Object>();
        if (config != null && (methods = this.getCacheConfigurationMethods(config)) != null) {
            String methodName = null;
            boolean getterMethodFound = false;
            for (Method method : methods) {
                methodName = method.getName();
                getterMethodFound = false;
                if (methodName.startsWith("is")) {
                    methodName = methodName.substring(2);
                    if (!GenericEhcache.getPopertiesToFilterOut().contains(methodName.toUpperCase())) {
                        getterMethodFound = true;
                    }
                } else if (methodName.startsWith("get")) {
                    methodName = methodName.substring(3);
                    if (!GenericEhcache.getPopertiesToFilterOut().contains(methodName.toUpperCase())) {
                        getterMethodFound = true;
                    }
                }
                if (!getterMethodFound) continue;
                try {
                    Object value = method.invoke((Object)config, null);
                    if (value == null) continue;
                    cacheConfigMap.put(methodName.toUpperCase(), value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return cacheConfigMap;
    }

    private Object getCastedValue(Object newVal, Class<?> type, Object oldVal) {
        Object value = newVal;
        if (type.getSimpleName().equalsIgnoreCase("boolean")) {
            value = this.toBooleanValue(newVal, oldVal);
        } else if (type.getSimpleName().equalsIgnoreCase("int")) {
            value = this.toIntValue(newVal, oldVal);
        } else if (type.getSimpleName().equalsIgnoreCase("long")) {
            value = this.toLongValue(newVal, oldVal);
        } else if (type.getSimpleName().equalsIgnoreCase("float")) {
            value = this.toFloatValue(newVal, oldVal);
        } else if (type.getSimpleName().equalsIgnoreCase("String")) {
            value = this.toStringValue(newVal, oldVal);
        }
        return value;
    }

    public List getCacheProperties(String region) {
        ArrayList result = new ArrayList();
        String appName = FusionContext.getCurrent().getApplicationName();
        if (region == null) {
            this.populateCacheProperties(appName, null, "OBJECT", result);
            this.populateCacheProperties(appName, null, "TEMPLATE", result);
            this.populateCacheProperties(appName, null, "QUERY", result);
        } else {
            this.populateCacheProperties(appName, null, region, result);
        }
        return result;
    }

    private void populateCacheProperties(String appName, String objType, String region, ArrayList result) {
        String mgrCalcKey;
        if (objType == null) {
            objType = "OBJECT";
        }
        String mgrKey = CacheTagHelper.getCacheKey((String)region, (String)appName, (String)objType, (String)this.configFilePath);
        CacheManager cacheManager = this.getCacheManager();
        Cache cacheObj = cacheManager.getCache(mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey));
        if (cacheObj == null) {
            if (!CacheTagHelper.isStandardCacheRegion((String)region)) {
                throw new CacheExceptions.CacheNotFoundException(region);
            }
            cacheManager.addCache(mgrCalcKey);
            cacheObj = cacheManager.getCache(mgrCalcKey);
        }
        objType = !CacheTagHelper.isStandardCacheRegion((String)region) ? "ANY" : region.toUpperCase();
        Struct objSettings = new Struct();
        CacheConfiguration config = cacheObj.getCacheConfiguration();
        Map<String, Object> properties = this.getCacheProperties(config);
        if (properties != null && properties.size() > 0) {
            Object[] keys = properties.keySet().toArray();
            Arrays.sort(keys);
            for (Object o : keys) {
                objSettings.put(o, properties.get(o));
            }
            objSettings.put((Object)"OBJECTTYPE", (Object)objType);
            Object objVal = objSettings.get((Object)"MEMORYSTOREEVICTIONPOLICY");
            if (objVal != null) {
                objSettings.put((Object)"MEMORYEVICTIONPOLICY", (Object)objVal.toString());
                objSettings.remove((Object)"MEMORYSTOREEVICTIONPOLICY");
            }
            if ((objVal = objSettings.get((Object)"DISKSTOREPATH")) != null) {
                objSettings.put((Object)"DISKSTORE", (Object)objVal.toString());
                objSettings.remove((Object)"DISKSTOREPATH");
            }
            String cacheName = cacheObj.getName();
            if (appName != null && cacheName.startsWith(appName)) {
                cacheName = cacheName.substring(cacheName.indexOf(appName) + appName.length());
            }
            objSettings.put((Object)"NAME", (Object)cacheName);
        }
        result.add(objSettings);
    }

    public String[] getAllCacheNames() {
        return this.getCacheManager().getCacheNames();
    }

    public Struct getAllCacheMetadataForMonitoring(String region) {
        Cache cache;
        Struct resultObj = new Struct();
        if (this.cacheManager != null && (cache = this.cacheManager.getCache(region)) != null) {
            StatisticsGateway stats = cache.getStatistics();
            resultObj.put((Object)"APPLICATIONNAME", (Object)region);
            resultObj.put((Object)"ENGINE", (Object)this.getEngine());
            if (stats != null) {
                long cacheHits = stats.cacheHitCount();
                long missCountNotFound = stats.cacheMissCount();
                if (cacheHits == 0L) {
                    resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                } else {
                    resultObj.put((Object)"HITRATIO", (Object)new Double((double)cacheHits / (double)(missCountNotFound + cacheHits)));
                }
                resultObj.put((Object)"CACHE_MISSCOUNT", (Object)new Long(missCountNotFound));
                resultObj.put((Object)"CACHE_HITCOUNT", (Object)new Long(cacheHits));
                resultObj.put((Object)"CACHESIZE", (Object)new Long(cache.calculateInMemorySize()));
                resultObj.put((Object)"NUMBER", (Object)new Long(cache.getSize()));
                resultObj.put((Object)GETEVICTIONCOUNT, (Object)stats.cacheEvictedCount());
            }
            try {
                SampledCache sc = new SampledCache((Ehcache)cache);
                resultObj.put((Object)GETAVGGETTIME, (Object)Float.toString(sc.getAverageGetTime()));
            }
            catch (NotCompliantMBeanException e) {
                resultObj.put((Object)GETAVGGETTIME, (Object)"0.0");
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPopertiesToFilterOut() {
        if (!filteredOutPropertiesinitialized.booleanValue()) {
            Boolean bl = filteredOutPropertiesinitialized;
            synchronized (bl) {
                if (filteredOutProperties == null) {
                    filteredOutProperties = new ArrayList<String>();
                    filteredOutProperties.add("CACHELOADERCONFIGURATIONS");
                    filteredOutProperties.add("CLASS");
                    filteredOutProperties.add("COPYSTRATEGY");
                    filteredOutProperties.add("LOCALTRANSACTIONAL");
                    filteredOutProperties.add("FROZEN");
                    filteredOutProperties.add("CACHEWRITERCONFIGURATION");
                    filteredOutProperties.add("XATRANSACTIONAL");
                    filteredOutProperties.add("COUNTBASEDTUNED");
                    filteredOutProperties.add("ELEMENTVALUECOMPARATORCONFIGURATION");
                    filteredOutProperties.add("CACHEEXTENSIONCONFIGURATIONS");
                    filteredOutProperties.add("XASTRICTTRANSACTIONAL");
                    filteredOutProperties.add("CACHEEVENTLISTENERCONFIGURATIONS");
                    filteredOutProperties.add("COPYSTRATEGYCONFIGURATION");
                    filteredOutProperties.add("CACHEDECORATORCONFIGURATIONS");
                    filteredOutProperties.add("SEARCHATTRIBUTES");
                    filteredOutProperties.add("SEARCHABLE");
                    filteredOutProperties.add("TERRACOTTACLUSTERED");
                    filteredOutProperties.add("TRANSACTIONALMODE");
                    filteredOutPropertiesinitialized = true;
                }
            }
        }
        return filteredOutProperties;
    }

    private Method[] getCacheConfigurationMethods(CacheConfiguration config) {
        if (cacheConfigurationMethods == null) {
            cacheConfigurationMethods = config.getClass().getMethods();
        }
        return cacheConfigurationMethods;
    }

    public void clearCache(String region) {
        CacheManager mgr = this.getCacheManager();
        Cache regionCache = mgr.getCache(region);
        List<Cache> allCaches = this.getApplicationRegionCaches(region, mgr);
        if (regionCache != null) {
            allCaches.add(regionCache);
        }
        for (Cache cache : allCaches) {
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    private List<Cache> getApplicationRegionCaches(String region, CacheManager mgr) {
        Enumeration appNames;
        ArrayList<Cache> caches = new ArrayList<Cache>();
        if (!this.isApplicationSpecificCache() && CacheTagHelper.isStandardCacheRegion((String)region) && (appNames = ApplicationScopeTracker.getApplicationKeys()) != null) {
            while (appNames.hasMoreElements()) {
                String cacheKey = CacheTagHelper.getCacheKey((String)region, (String)((String)appNames.nextElement()), null, (String)this.configFilePath);
                Cache cache = mgr.getCache(cacheKey);
                if (cache == null) continue;
                caches.add(cache);
            }
        }
        return caches;
    }

    public boolean isApplicationSpecificCache() {
        return this.configFilePath != null;
    }

    public ArrayList getAllCacheMetadataForMonitoring(boolean server) {
        String[] regions = this.getAllCacheNames();
        ArrayList<Struct> appr = new ArrayList<Struct>();
        for (String region : regions) {
            Struct resultObj = new Struct();
            if (region.endsWith("authtokenmappingcache") || region.endsWith("authcache") || this.isApplicationSpecificCache() && server || !this.isApplicationSpecificCache() && !server) continue;
            resultObj = this.getAllCacheMetadataForMonitoring(region);
            appr.add(resultObj);
        }
        return appr;
    }

    public void reset() {
        this.cacheManager.shutdown();
        this.cacheManager = null;
    }

    public String getEngine() {
        return "Ehcache";
    }

    static {
        ServiceFactory.getSchedulerService().scheduleForShutDown((Runnable)new CacheCleanUpAgent());
        filteredOutProperties = null;
        filteredOutPropertiesinitialized = new Boolean(false);
        cacheConfigurationMethods = null;
    }

    static final class CacheCleanUpAgent
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheManager mgr;
            CacheManager cacheManager = mgr = CacheManager.getInstance();
            synchronized (cacheManager) {
                if (mgr.getStatus().equals(Status.STATUS_ALIVE)) {
                    this.shutdown(mgr);
                }
            }
            Map appSpecificCacheMap = GenericCacheFactory.getCacheManagerMap();
            if (appSpecificCacheMap != null) {
                for (GenericCache engine : appSpecificCacheMap.values()) {
                    if (!(engine instanceof GenericEhcache)) continue;
                    GenericEhcache cache = (GenericEhcache)engine;
                    CacheManager cacheManager2 = mgr = cache.getCacheManager();
                    synchronized (cacheManager2) {
                        if (mgr.getStatus().equals(Status.STATUS_ALIVE)) {
                            this.shutdown(mgr);
                        }
                    }
                }
            }
        }

        private void shutdown(CacheManager mgr) {
            try {
                mgr.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

