/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileReader
extends RandomAccessReader {
    @NotNull
    private final RandomAccessFile _file;
    private final long _length;
    private int _currentIndex;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public RandomAccessFileReader(@NotNull RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile == null) {
            throw new NullPointerException();
        }
        this._file = randomAccessFile;
        this._length = this._file.length();
    }

    public long getLength() {
        return this._length;
    }

    protected byte getByte(int n) throws IOException {
        int n2;
        if (n != this._currentIndex) {
            this.seek(n);
        }
        if ((n2 = this._file.read()) < 0) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        assert (n2 <= 255);
        ++this._currentIndex;
        return (byte)n2;
    }

    @NotNull
    public byte[] getBytes(int n, int n2) throws IOException {
        this.validateIndex(n, n2);
        if (n != this._currentIndex) {
            this.seek(n);
        }
        byte[] byArray = new byte[n2];
        int n3 = this._file.read(byArray);
        this._currentIndex += n3;
        if (n3 != n2) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        return byArray;
    }

    private void seek(int n) throws IOException {
        if (n == this._currentIndex) {
            return;
        }
        this._file.seek(n);
        this._currentIndex = n;
    }

    protected boolean isValidIndex(int n, int n2) throws IOException {
        return n2 >= 0 && n >= 0 && (long)n + (long)n2 - 1L < this._length;
    }

    protected void validateIndex(int n, int n2) throws IOException {
        if (!this.isValidIndex(n, n2)) {
            throw new BufferBoundsException(n, n2, this._length);
        }
    }
}

