/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.gcp.storage.request.ListBucketRequest;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListBucketRequestConsumer
extends ConsumerMap<ListBucketRequest> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public ListBucketRequestConsumer() {
        this.put("fields", new ConsumerValidator((listBucketRequest, value) -> {
            List fieldsArray = this.cast.getStringListProperty(value);
            Iterator itr = fieldsArray.iterator();
            ArrayList<Storage.BucketField> bfield = new ArrayList<Storage.BucketField>();
            while (itr.hasNext()) {
                bfield.add(Storage.BucketField.valueOf((String)((String)itr.next())));
            }
            Storage.BucketField[] bucketField = bfield.toArray(new Storage.BucketField[bfield.size()]);
            listBucketRequest.setFields(bucketField);
        }, Collections.singletonList(new EmptyListValidator("fields"))));
        this.put("pageSize", new ConsumerValidator((listBucketRequest, value) -> {
            long pageSize = this.cast.getLongProperty(value);
            listBucketRequest.setPageSize(pageSize);
        }, Collections.emptyList()));
        this.put("pageToken", new ConsumerValidator((listBucketRequest, value) -> {
            String pageToken = this.cast.getStringProperty(value);
            listBucketRequest.setPageToken(pageToken);
        }, Collections.emptyList()));
        this.put("prefix", new ConsumerValidator((listBucketRequest, value) -> {
            String prefix = this.cast.getStringProperty(value);
            listBucketRequest.setPrefix(prefix);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((listBucketRequest, value) -> {
            String userProject = this.cast.getStringProperty(value);
            listBucketRequest.setUserProject(userProject);
        }, Collections.emptyList()));
    }
}

