/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import com.google.api.client.util.DateTime;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.StorageClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LifecycleConditionConsumer
extends ConsumerMap<BucketInfo.LifecycleRule.LifecycleCondition.Builder> {
    private static final long serialVersionUID = 6128560750236379265L;
    private static LifecycleConditionConsumer instance;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifecycleConditionConsumer getInstance() {
        if (instance != null) return instance;
        Class<LifecycleConditionConsumer> clazz = LifecycleConditionConsumer.class;
        synchronized (LifecycleConditionConsumer.class) {
            if (instance != null) return instance;
            instance = new LifecycleConditionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LifecycleConditionConsumer() {
        this.put("age", new ConsumerValidator((builder, value) -> {
            Integer age = this.cast.getIntegerProperty(value);
            builder.setAge(age);
        }, Collections.emptyList()));
        this.put("createdBefore", new ConsumerValidator((builder, value) -> builder.setCreatedBefore(new DateTime(this.cast.getDateProperty(value))), Collections.emptyList()));
        this.put("customTimeBefore", new ConsumerValidator((builder, value) -> builder.setCustomTimeBefore(new DateTime(this.cast.getDateProperty(value))), Collections.emptyList()));
        this.put("daysSinceCustomTime", new ConsumerValidator((builder, value) -> {
            Integer daysSinceCustomTime = this.cast.getIntegerProperty(value);
            builder.setDaysSinceCustomTime(daysSinceCustomTime);
        }, Collections.emptyList()));
        this.put("daysSinceNoncurrentTime", new ConsumerValidator((builder, value) -> {
            Integer daysSinceNoncurrentTime = this.cast.getIntegerProperty(value);
            builder.setDaysSinceNoncurrentTime(daysSinceNoncurrentTime);
        }, Collections.emptyList()));
        this.put("IsLive", new ConsumerValidator((builder, value) -> {
            Boolean live = this.cast.getBooleanProperty(value);
            builder.setIsLive(live);
        }, Collections.emptyList()));
        this.put("matchesPrefix", new ConsumerValidator((builder, value) -> {
            List matchesPrefix = this.cast.getStringListProperty(value);
            builder.setMatchesPrefix(matchesPrefix);
        }, Collections.singletonList(new EmptyListValidator("matchesPrefix"))));
        this.put("matchesStorageClass", new ConsumerValidator((builder, value) -> {
            List val = this.cast.getStringListProperty(value);
            ArrayList<StorageClass> list = new ArrayList<StorageClass>();
            for (int i = 0; i < val.size(); ++i) {
                list.add(StorageClass.valueOfStrict((String)((String)val.get(i))));
            }
            builder.setMatchesStorageClass(list);
        }, Collections.singletonList(new EmptyListValidator("matchesStorageClass"))));
        this.put("matchesSuffix", new ConsumerValidator((builder, value) -> {
            List matchesSuffix = this.cast.getStringListProperty(value);
            builder.setMatchesSuffix(matchesSuffix);
        }, Collections.singletonList(new EmptyListValidator("matchesSuffix"))));
        this.put("noncurrentTimeBefore", new ConsumerValidator((builder, value) -> builder.setNoncurrentTimeBefore(new DateTime(this.cast.getDateProperty(value))), Collections.emptyList()));
        this.put("numberOfNewerVersions", new ConsumerValidator((builder, value) -> {
            Integer numberOfNewerVersions = this.cast.getIntegerProperty(value);
            builder.setNumberOfNewerVersions(numberOfNewerVersions);
        }, Collections.emptyList()));
    }
}

