/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ui.gui.swing;

import com.zerog.util.ZGUtil;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public class OSXUtility {
    public static final String OSX_BUNDLE_VERSION = "version";
    public static final String OSX_BUNDLE_SHORT_VERSION = "shortVersion";
    public static final String OSX_HUMAN_READABLE_COPYRIGHT = "copyright";
    public static boolean libraryLoaded = false;
    private static String libName = "IAMac";

    public static void prepareGetInfoDialog(Map<String, String> map) {
        if (!libraryLoaded) {
            return;
        }
        if (map.get(OSX_BUNDLE_VERSION) != null) {
            OSXUtility.setBundleVersion(map.get(OSX_BUNDLE_VERSION));
        }
        if (map.get(OSX_BUNDLE_SHORT_VERSION) != null) {
            OSXUtility.setBundleShortVersion(map.get(OSX_BUNDLE_SHORT_VERSION));
        }
        if (map.get(OSX_HUMAN_READABLE_COPYRIGHT) != null) {
            OSXUtility.setHumanReadableCopyright(map.get(OSX_HUMAN_READABLE_COPYRIGHT));
        }
    }

    private static void LoadMacUtilityLibrary() {
        String string = System.getProperty("java.library.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            File file2;
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.isEmpty()) continue;
            if (string2.indexOf("\"") >= 0) {
                string2 = string2.replace("\"", "");
            }
            if (!(file2 = new File(string2)).exists() || !(file = new File(file2.getAbsolutePath() + File.separator + libName + ".dylib")).exists()) continue;
            System.load(file.getAbsolutePath());
            return;
        }
        throw new UnsatisfiedLinkError("no " + libName + " in java.library.path");
    }

    private static native void setBundleVersion(String var0);

    private static native void setBundleShortVersion(String var0);

    private static native void setHumanReadableCopyright(String var0);

    static {
        if (!ZGUtil.isThisGenericUnixRunningOnOSX()) {
            try {
                Flexeraavd.ag("Trying to load library " + libName);
                OSXUtility.LoadMacUtilityLibrary();
                Flexeraavd.ag("IAMac utility library loaded");
                libraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                libraryLoaded = false;
                Flexeraavd.ag("Error trying to load library " + unsatisfiedLinkError.getMessage());
            }
        }
    }
}

