/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.internal.bindery;

import com.apple.mrj.internal.bindery.FSOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class BindryHelper {
    private static boolean debug = false;
    static String zipName = ".zip";
    static String jarName = ".jar";

    private static native boolean fileProgress0(String var0);

    private static void fileProgress(String string) throws IOException {
        if (!BindryHelper.fileProgress0(string)) {
            throw new IOException("Terminated by user");
        }
    }

    static String newName(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            if (debug) {
                System.out.println("can't find index of " + string2 + " in path " + string);
            }
            return "";
        }
        return String.valueOf(string3) + string.substring(string2.length());
    }

    static String newZipName(String string, String string2) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return String.valueOf(string2) + "/" + string;
    }

    static long calcCRC(InputStream inputStream) throws IOException {
        CRC32 cRC32;
        block4: {
            cRC32 = new CRC32();
            try {
                byte[] byArray = new byte[8192];
                int n = 0;
                if (debug) {
                    System.out.println("calcCRC, InputStream= " + inputStream);
                }
                while ((n = inputStream.read(byArray)) != -1) {
                    cRC32.update(byArray, 0, n);
                    if (!debug) continue;
                    System.out.println("   len= " + n);
                }
                if (!debug) break block4;
                System.out.println(" done reading input stream buffer ");
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                inputStream.close();
                throw throwable;
            }
        }
        Object var3_4 = null;
        inputStream.close();
        return cRC32.getValue();
    }

    static long calcCRC(File file) throws IOException {
        return BindryHelper.calcCRC(new FileInputStream(file));
    }

    static void writeNextEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws IOException {
        BindryHelper.fileProgress(zipEntry.getName());
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (ZipException zipException) {
            if (debug) {
                System.out.println("Can't Put Entry " + zipEntry.getName() + ": " + zipException);
            }
            zipException.printStackTrace();
            return;
        }
        try {
            if (inputStream != null) {
                block9: {
                    try {
                        if (zipEntry.getSize() <= 0L) break block9;
                        byte[] byArray = new byte[1024];
                        int n = 0;
                        while ((n = inputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        inputStream.close();
                        throw throwable;
                    }
                }
                Object var6_7 = null;
                inputStream.close();
            }
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            zipOutputStream.closeEntry();
            throw throwable;
        }
        zipOutputStream.closeEntry();
    }

    static void writeFile(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        long l = file.isDirectory() ? 0L : file.length();
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        zipEntry.setMethod(0);
        zipEntry.setSize(l);
        FileInputStream fileInputStream = null;
        if (l == 0L) {
            zipEntry.setCrc(0L);
        } else {
            zipEntry.setCrc(BindryHelper.calcCRC(file));
            fileInputStream = new FileInputStream(file);
        }
        BindryHelper.writeNextEntry(zipOutputStream, zipEntry, fileInputStream);
    }

    static void writeZipFile(ZipOutputStream zipOutputStream, File file, String string, String string2) throws IOException {
        if (debug) {
            System.out.println("[Expanding Zip: " + file.getAbsolutePath() + "]");
        }
        String string3 = file.getAbsolutePath();
        ZipFile zipFile = new ZipFile(string3);
        String string4 = string3.substring(string2.length());
        String string5 = String.valueOf(string) + string4.substring(0, string4.length() - file.getName().length());
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ZipEntry zipEntry2 = new ZipEntry(String.valueOf(string5) + zipEntry.getName());
                zipEntry2.setTime(zipEntry.getTime());
                zipEntry2.setSize(zipEntry.getSize());
                if (debug) {
                    System.out.println(" Size= " + zipEntry.getSize());
                }
                zipEntry2.setCrc(BindryHelper.calcCRC(zipFile.getInputStream(zipEntry)));
                BindryHelper.writeNextEntry(zipOutputStream, zipEntry2, zipFile.getInputStream(zipEntry));
            }
        }
        finally {
            Object var9_11 = null;
            zipFile.close();
        }
    }

    static boolean isZipFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(zipName) || string.endsWith(jarName);
    }

    static void writeFolder(ZipOutputStream zipOutputStream, File file, String string, String string2, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new IOException("writeFolder: folder not found for " + file);
        }
        if (file.isFile()) {
            throw new IOException("writeFolder: file expected for " + file);
        }
        String[] stringArray = file.list();
        String string3 = file.getAbsolutePath();
        if (debug) {
            System.out.println("absPath = " + string3);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("Foobles")) {
                File file2 = new File(string3, stringArray[n]);
                if (!file2.exists()) {
                    if (debug) {
                        System.out.println("File: " + file2 + " doesn't exist!");
                    }
                } else {
                    if (bl && BindryHelper.isZipFile(file2)) {
                        BindryHelper.writeZipFile(zipOutputStream, file2, string, string2);
                    } else {
                        BindryHelper.writeFile(zipOutputStream, file2, BindryHelper.newName(file2.getAbsolutePath(), string2, string));
                    }
                    if (file2.isDirectory()) {
                        BindryHelper.writeFolder(zipOutputStream, file2, string, string2, bl);
                    }
                }
            }
            ++n;
        }
    }

    static String folderTrim(String string) {
        int n = string.length();
        if (string.charAt(n - 1) == '/') {
            string = string.substring(0, n - 1);
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        return string;
    }

    static int writeBindings0(int n, String string, String string2, boolean bl) throws IOException {
        string = BindryHelper.folderTrim(string);
        string2 = BindryHelper.folderTrim(string2);
        if (debug) {
            System.out.println("in writeBindings");
            System.out.println("VFS Name: " + string);
            System.out.println("Src Name: " + string2);
            System.out.println("Expand Zips: " + bl);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FSOutputStream(n));
        try {
            zipOutputStream.setMethod(0);
            zipOutputStream.setLevel(0);
            File file = new File(string2);
            BindryHelper.writeFolder(zipOutputStream, file, string, string2, bl);
        }
        finally {
            Object var6_6 = null;
            zipOutputStream.close();
        }
        return 0;
    }

    static int writeBindings(int n, String string, String string2, boolean bl) throws Exception {
        int n2 = 0;
        try {
            n2 = BindryHelper.writeBindings0(n, string, string2, bl);
        }
        catch (Exception exception) {
            System.out.println("Got Exception: " + exception);
            exception.printStackTrace();
            throw exception;
        }
        catch (Error error) {
            System.out.println("Got Error: " + error);
            error.printStackTrace();
            throw error;
        }
        return n2;
    }

    public static void main() throws IOException {
        String string = "/$@VFS";
        String string2 = "/dev/TestArc";
        boolean bl = true;
        if (debug) {
            System.out.println("in writeBindings");
            System.out.println("VFS Name: " + string);
            System.out.println("Src Name: " + string2);
            System.out.println("Expand Zips: " + bl);
        }
        FileOutputStream fileOutputStream = new FileOutputStream("/$APPLICATION/Foobles");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream, 10240));
        try {
            zipOutputStream.setMethod(0);
            zipOutputStream.setLevel(0);
            File file = new File(string2);
            try {
                BindryHelper.writeFolder(zipOutputStream, file, string, string2, bl);
            }
            catch (Exception exception) {
                System.out.println("Got Exception: " + exception);
                exception.printStackTrace();
            }
            catch (Error error) {
                System.out.println("Got Error: " + error);
                error.printStackTrace();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            zipOutputStream.close();
            throw throwable;
        }
        zipOutputStream.close();
        System.out.println("Done");
    }
}

