/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.datatransfer;

import com.apple.mrj.datatransfer.FlaggedTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

public class Transfer
implements FlaggedTransferable {
    private Vector fFlavors = new Vector(1);
    private Vector fData = new Vector(1);
    private Vector fFlags;
    private boolean fFrozen;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;

    public synchronized void addFlavor(DataFlavor dataFlavor, Object object) {
        if (this.fFrozen) {
            throw new IllegalStateException("This Transfer object cannot be modified");
        }
        if (this.isDataFlavorSupported(dataFlavor)) {
            throw new IllegalArgumentException("Duplicate flavor");
        }
        if (object != null && !this.verifyFlavorData(dataFlavor, object)) {
            throw new IllegalArgumentException("Data's class is not compatible with DataFlavor");
        }
        this.fFlavors.addElement(dataFlavor);
        this.fData.addElement(object);
    }

    private boolean verifyFlavorData(DataFlavor dataFlavor, Object object) {
        Class clazz = object.getClass();
        Class<?> clazz2 = dataFlavor.getRepresentationClass();
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == (array$B != null ? array$B : (array$B = Transfer.class$("[B")))) {
            if (clazz2 == (class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = Transfer.class$("java.io.InputStream")))) {
                return true;
            }
            clazz = class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = Transfer.class$("java.io.InputStream"));
        }
        return clazz == (class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = Transfer.class$("java.io.InputStream"))) && (dataFlavor.equals(DataFlavor.plainTextFlavor) || dataFlavor.getMimeType().startsWith("application/x-java-serialized-object") || dataFlavor.getRepresentationClass() == (class$java$io$Reader != null ? class$java$io$Reader : (class$java$io$Reader = Transfer.class$("java.io.Reader"))));
    }

    public void addPromiseFlavor(DataFlavor dataFlavor) {
        this.addFlavor(dataFlavor, null);
    }

    public synchronized void setDataFlavorFlags(DataFlavor dataFlavor, int n) throws UnsupportedFlavorException {
        if (this.fFrozen) {
            throw new IllegalStateException("This DataFlavor cannot be modified");
        }
        int n2 = this.findFlavor(dataFlavor);
        if (n2 < 0) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (this.fFlags == null) {
            if (n == 0) {
                return;
            }
            this.fFlags = new Vector();
        }
        if (n2 >= this.fFlags.size()) {
            if (n == 0) {
                return;
            }
            this.fFlags.setSize(n2 + 1);
        }
        this.fFlags.setElementAt(new Integer(n), n2);
    }

    public synchronized void freeze() {
        this.fFrozen = true;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        int n = this.fFlavors.size();
        Object[] objectArray = new DataFlavor[n];
        this.fFlavors.copyInto(objectArray);
        return objectArray;
    }

    public synchronized boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.findFlavor(dataFlavor) >= 0;
    }

    public synchronized boolean isDataAvailable(DataFlavor dataFlavor) {
        int n = this.findFlavor(dataFlavor);
        return n >= 0 && this.fData.elementAt(n) != null;
    }

    public synchronized Object getRawTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        int n = this.findFlavor(dataFlavor);
        if (n < 0) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.fData.elementAt(n);
    }

    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.getTransferData(dataFlavor, true);
    }

    private synchronized Object getTransferData(DataFlavor dataFlavor, boolean bl) throws UnsupportedFlavorException, IOException {
        Object object = this.getRawTransferData(dataFlavor);
        if (object == null && !((object = this.getPromiseData(dataFlavor)) instanceof InputStream) && !(object instanceof Reader)) {
            this.fData.setElementAt(object, this.findFlavor(dataFlavor));
        }
        if (bl) {
            if (dataFlavor.getRepresentationClass() != (array$B != null ? array$B : (array$B = Transfer.class$("[B"))) && object instanceof byte[]) {
                object = new ByteArrayInputStream((byte[])object);
            }
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                    object = this.createStringReader(inputStream);
                } else if (dataFlavor.getMimeType().startsWith("application/x-java-serialized-object")) {
                    object = this.createDeserializedObject(inputStream);
                } else if (dataFlavor.getRepresentationClass() == (class$java$io$Reader != null ? class$java$io$Reader : (class$java$io$Reader = Transfer.class$("java.io.Reader")))) {
                    object = new InputStreamReader(inputStream);
                }
            }
        }
        return object;
    }

    private StringReader createStringReader(InputStream inputStream) throws IOException {
        StringReader stringReader;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            char[] cArray = new char[1000];
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                stringWriter.write(cArray, 0, n);
            }
            stringReader = new StringReader(stringWriter.toString());
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            stringWriter.close();
            inputStreamReader.close();
            inputStream.close();
            throw throwable;
        }
        stringWriter.close();
        inputStreamReader.close();
        inputStream.close();
        return stringReader;
    }

    private Object createDeserializedObject(InputStream inputStream) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Can't deserialize object: " + classNotFoundException.getMessage());
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            objectInputStream.close();
            inputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        inputStream.close();
        return object;
    }

    protected Object getPromiseData(DataFlavor dataFlavor) throws IOException {
        throw new IOException("Promised data flavor was never supplied by subclass of Transfer");
    }

    public synchronized int getDataFlavorFlags(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Integer n;
        int n2 = this.findFlavor(dataFlavor);
        if (n2 < 0) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (this.fFlags != null && n2 < this.fFlags.size() && (n = (Integer)this.fFlags.elementAt(n2)) != null) {
            return n;
        }
        return 0;
    }

    private int findFlavor(DataFlavor dataFlavor) {
        int n = this.fFlavors.size() - 1;
        while (n >= 0) {
            if (dataFlavor.equals((DataFlavor)this.fFlavors.elementAt(n))) {
                return n;
            }
            --n;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

