/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.memory.HandleObject;
import com.apple.memory.MemoryObject;
import java.util.Vector;

public class Handle
extends HandleObject {
    protected Handle owner;
    protected Vector registryList;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public Handle(int n, boolean bl) {
        super(0);
        this.handle = this.AllocateHandle(n, bl);
    }

    public Handle(HandleObject handleObject) {
        super(handleObject.getHandle());
        if (Handle.HandToHand(this) != 0 || this.handle == 0) {
            throw new OutOfMemoryError();
        }
    }

    protected Handle(int n) {
        super(n);
    }

    protected Handle() {
        super(0);
    }

    protected Handle(int n, Handle handle) {
        super(n);
        if (handle != null) {
            this.owner = handle;
            this.owner.register(this);
        } else {
            this.owner = this;
        }
    }

    private void register(Handle handle) {
        if (this.owner == this) {
            return;
        }
        if (this.registryList != null) {
            if (this.registryList.contains(handle)) {
                return;
            }
        } else {
            this.registryList = new Vector();
        }
        this.registryList.addElement(handle);
    }

    public Object clone() {
        return new Handle(this);
    }

    public void Dispose() {
        if (this.handle != 0) {
            this.FreeHandle(this.handle);
            this.handle = 0;
        }
    }

    protected void finalize() {
        if (this.registryList != null) {
            this.registryList.removeAllElements();
        }
        if (this.owner == null) {
            this.Dispose();
        }
        this.handle = 0;
    }

    protected int AllocateHandle(int n, boolean bl) {
        int n2;
        int n3 = n2 = bl ? Handle.NewHandleClear(n) : Handle.NewHandle(n);
        if (n2 == 0) {
            throw new MacOSError(-108);
        }
        return n2;
    }

    protected void FreeHandle(int n) {
        Handle.DisposeHandle(n);
    }

    public int Munger(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        return Handle.Munger(this.handle, n, byArray, n2, byArray2, n3);
    }

    private static native int NewHandle(int var0);

    private static native int NewHandleClear(int var0);

    private static native void DisposeHandle(int var0);

    private static native short HandToHand(MemoryObject var0);

    private static native int Munger(int var0, int var1, byte[] var2, int var3, byte[] var4, int var5);
}

