/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;

public final class FlowableFromStream<T>
extends Flowable<T> {
    final Stream<T> stream;

    public FlowableFromStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        FlowableFromStream.subscribeStream(s, this.stream);
    }

    public static <T> void subscribeStream(Subscriber<? super T> s, Stream<T> stream) {
        Iterator iterator2;
        try {
            iterator2 = stream.iterator();
            if (!iterator2.hasNext()) {
                EmptySubscription.complete(s);
                FlowableFromStream.closeSafely(stream);
                return;
            }
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s);
            FlowableFromStream.closeSafely(stream);
            return;
        }
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new StreamConditionalSubscription((ConditionalSubscriber)s, iterator2, stream));
        } else {
            s.onSubscribe(new StreamSubscription<T>(s, iterator2, stream));
        }
    }

    static void closeSafely(AutoCloseable c) {
        try {
            c.close();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }

    static final class StreamConditionalSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final ConditionalSubscriber<? super T> downstream;

        StreamConditionalSubscription(ConditionalSubscriber<? super T> downstream, Iterator<T> iterator2, AutoCloseable closeable) {
            super(iterator2, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n) {
            long emitted = 0L;
            Iterator iterator2 = this.iterator;
            ConditionalSubscriber downstream = this.downstream;
            while (true) {
                block8: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator2.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (downstream.tryOnNext(next)) {
                        ++emitted;
                    }
                    if (this.cancelled) continue;
                    try {
                        if (!iterator2.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block8;
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (emitted != n || emitted != (n = this.get())) continue;
                if (this.compareAndSet(n, 0L)) break;
                n = this.get();
            }
        }
    }

    static final class StreamSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final Subscriber<? super T> downstream;

        StreamSubscription(Subscriber<? super T> downstream, Iterator<T> iterator2, AutoCloseable closeable) {
            super(iterator2, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n) {
            long emitted = 0L;
            Iterator iterator2 = this.iterator;
            Subscriber downstream = this.downstream;
            while (true) {
                block7: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator2.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    downstream.onNext(next);
                    if (this.cancelled) continue;
                    try {
                        if (!iterator2.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block7;
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (++emitted != n || emitted != (n = this.get())) continue;
                if (this.compareAndSet(n, 0L)) break;
                n = this.get();
            }
        }
    }

    static abstract class AbstractStreamSubscription<T>
    extends AtomicLong
    implements QueueSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        Iterator<T> iterator;
        AutoCloseable closeable;
        volatile boolean cancelled;
        boolean once;

        AbstractStreamSubscription(Iterator<T> iterator2, AutoCloseable closeable) {
            this.iterator = iterator2;
            this.closeable = closeable;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                this.run(n);
            }
        }

        abstract void run(long var1);

        @Override
        public void cancel() {
            this.cancelled = true;
            this.request(1L);
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.lazySet(Long.MAX_VALUE);
                return 1;
            }
            return 0;
        }

        @Override
        public boolean offer(@NonNull T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(@NonNull T v1, @NonNull T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                this.clear();
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "The Stream's Iterator.next() returned a null value");
        }

        @Override
        public boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable c = this.closeable;
            this.closeable = null;
            if (c != null) {
                FlowableFromStream.closeSafely(c);
            }
        }
    }
}

