/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CDATASectionImpl;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMImplementationImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.OMDocumentImplUtil;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.XMLChar;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends ParentNode
implements Document,
OMDocument {
    private String xmlVersion;
    private String xmlEncoding;
    private boolean xmlStandalone = false;
    private String charEncoding;
    private Vector idAttrs;
    protected Hashtable identifiers;
    private final DOMConfigurationImpl domConfig = new DOMConfigurationImpl();

    public DocumentImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    public DocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
        ((OMDOMFactory)factory).setDocument(this);
    }

    public DocumentImpl(OMFactory factory) {
        super(factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    public void setType(int nodeType) throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    public int getType() throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        this.internalSerialize(writer, cache, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    public OMNode getNextOMSibling() throws OMException {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public OMContainer getParent() throws OMException {
        throw new UnsupportedOperationException("This is the document node");
    }

    public OMNode getPreviousOMSibling() {
        throw new UnsupportedOperationException("This is the document node");
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void setNextOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public void setParent(OMContainer element) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public void setPreviousOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
        return new AttrImpl(this, name, this.factory);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        if ("xmlns".equals(localName)) {
            return this.createAttribute(localName);
        }
        this.checkQName(prefix, localName);
        NamespaceImpl namespace = namespaceURI == null ? null : new NamespaceImpl(namespaceURI, prefix == null ? "" : prefix);
        return new AttrImpl(this, localName, namespace, this.factory);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data, this.factory);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data, this.factory);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this, this.factory);
    }

    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl(this, tagName, this.factory);
    }

    public Element createElementNS(String ns, String qualifiedName) throws DOMException {
        if (ns == null) {
            ns = "";
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        this.checkQName(prefix, localName);
        if (prefix == null) {
            prefix = "";
        }
        NamespaceImpl namespace = ns.length() == 0 ? null : new NamespaceImpl(ns, prefix);
        ElementImpl element = new ElementImpl(this, localName, null, this.factory);
        element.setNamespaceWithNoFindInCurrentScope(namespace);
        return element;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return new ProcessingInstructionImpl(this, target, data, this.factory);
    }

    public Text createTextNode(String value) {
        return new TextImpl(this, value, this.factory);
    }

    public DocumentType getDoctype() {
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof DocumentType) {
                return (DocumentType)child;
            }
            if (!(child instanceof Element)) continue;
            return null;
        }
        return null;
    }

    public Element getElementById(String elementId) {
        if (this.idAttrs == null) {
            return null;
        }
        Enumeration attrEnum = this.idAttrs.elements();
        while (attrEnum.hasMoreElements()) {
            Attr tempAttr = (Attr)attrEnum.nextElement();
            if (!tempAttr.getValue().equals(elementId)) continue;
            return tempAttr.getOwnerElement();
        }
        return null;
    }

    public NodeList getElementsByTagName(String tagname) {
        throw new UnsupportedOperationException("TODO");
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("TODO");
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        Attr newAttr;
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                            newAttr = (Attr)this.importNode(attr, true);
                            newElement.setAttributeNodeNS(newAttr);
                            continue;
                        }
                        newAttr = (Attr)this.importNode(attr, true);
                        newElement.setAttributeNode(newAttr);
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if ("".equals(importedNode.getNamespaceURI()) || importedNode.getNamespaceURI() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else if ("xmlns".equals(importedNode.getNodeName())) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 9, null);
                throw new DOMException(9, msg);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            for (Node srckid = importedNode.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newNode.appendChild(this.importNode(srckid, true));
            }
        }
        return newNode;
    }

    public String getCharsetEncoding() {
        return this.charEncoding;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public String isStandalone() {
        return this.xmlStandalone ? "yes" : "no";
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charEncoding = charsetEncoding;
    }

    public void setOMDocumentElement(OMElement documentElement) {
        if (documentElement == null) {
            throw new IllegalArgumentException("documentElement must not be null");
        }
        OMElement existingDocumentElement = this.getOMDocumentElement();
        if (existingDocumentElement == null) {
            this.addChild((OMNode)documentElement);
        } else {
            OMNode nextSibling = existingDocumentElement.getNextOMSibling();
            existingDocumentElement.detach();
            if (nextSibling == null) {
                this.addChild((OMNode)documentElement);
            } else {
                nextSibling.insertSiblingBefore((OMNode)documentElement);
            }
        }
    }

    public void setStandalone(String isStandalone) {
        this.xmlStandalone = "yes".equalsIgnoreCase(isStandalone);
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize((XMLStreamWriter)writer, false);
        writer.flush();
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize((XMLStreamWriter)writer, true);
        writer.flush();
    }

    public void setXMLVersion(String version) {
        this.xmlVersion = version;
    }

    public String getXMLEncoding() {
        return this.xmlEncoding;
    }

    public void setXMLEncoding(String encoding) {
        this.xmlEncoding = encoding;
    }

    public OMElement getOMDocumentElement() {
        return this.getOMDocumentElement(true);
    }

    OMElement getOMDocumentElement(boolean build) {
        OMNode child;
        OMNode oMNode = child = build ? this.getFirstOMChild() : this.getFirstOMChildIfAvailable();
        while (child != null) {
            if (child instanceof OMElement) {
                return (OMElement)child;
            }
            child = build ? child.getNextOMSibling() : ((OMNodeEx)child).getNextOMSiblingIfAvailable();
        }
        return null;
    }

    public Element getDocumentElement() {
        return (Element)this.getOMDocumentElement();
    }

    protected final void checkQName(String prefix, String local) {
        if (prefix != null && !XMLChar.isValidNCName(prefix) || !XMLChar.isValidNCName(local)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
    }

    protected void addIdAttr(Attr attr) {
        if (this.idAttrs == null) {
            this.idAttrs = new Vector();
        }
        this.idAttrs.add(attr);
    }

    protected void removeIdAttr(Attr attr) {
        if (this.idAttrs != null) {
            this.idAttrs.remove(attr);
        }
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Node adoptNode(Node node) throws DOMException {
        if (node instanceof ChildNode) {
            ChildNode childNode = (ChildNode)node;
            if (childNode.hasParent()) {
                childNode.detach();
            }
            childNode.setOwnerDocument(this);
            return childNode;
        }
        return null;
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getXmlEncoding() {
        return this.charEncoding;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public String getXmlVersion() {
        return this.getXMLVersion();
    }

    public void normalizeDocument() {
        if (this.domConfig.isEnabled(1024) || this.domConfig.isEnabled(8192)) {
            throw new UnsupportedOperationException("TODO");
        }
        this.normalize(this.domConfig);
    }

    public Node renameNode(Node node, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlStandalone(boolean standalone) throws DOMException {
        this.xmlStandalone = standalone;
    }

    public void setXmlVersion(String version) throws DOMException {
        this.setXMLVersion(version);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        OMDocumentImplUtil.internalSerialize(this, writer, cache, includeXMLDeclaration);
    }
}

