/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.Image;
import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CFFileServlet;
import coldfusion.util.IOUtils;
import coldfusion.vfs.VFSFileFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Random;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossless;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

public class ExifMetaDataHelper {
    private static final ExifRewriter exifWriter = new ExifRewriter();
    private static boolean imgCleanupInitialized = false;
    private static final Random rand = new Random();
    public static final String TEMP_IMAGE_FOLDER = "CFFileServlet/_cf_image";
    private static final boolean lossless = !Boolean.getBoolean("coldfusion.image.exif.lossless");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyExifMetadata(Image img, File destination, String formatName) {
        InputStream in = null;
        try {
            in = img.getInputStreamFromSource(null);
            ExifMetaDataHelper.copyExifMetadata(ExifMetaDataHelper.getOutputSet(in), destination, formatName);
        }
        catch (Exception e) {
            try {
                CFLogs.APPLICATION_LOG.debug((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.closeSilently((Closeable[])new Closeable[]{in});
        }
        IOUtils.closeSilently((Closeable[])new Closeable[]{in});
    }

    static void copyExifMetadata(final TiffOutputSet sourceSet, final File destination, final String formatName) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                File tempFile;
                FileOutputStream tempStream;
                block11: {
                    tempStream = null;
                    tempFile = null;
                    try {
                        tempFile = ExifMetaDataHelper._getTempImageFile();
                        tempStream = new FileOutputStream(tempFile);
                        if (formatName.equals("jpeg") || formatName.equals("jpg")) {
                            if (lossless) {
                                exifWriter.updateExifMetadataLossless(destination, (OutputStream)tempStream, sourceSet);
                            } else {
                                exifWriter.updateExifMetadataLossy(destination, (OutputStream)tempStream, sourceSet);
                            }
                        } else {
                            InputStream istream = VFSFileFactory.getInputStream((File)destination);
                            byte[] fileBytes = IOUtils.toByteArray((InputStream)istream);
                            new TiffImageWriterLossless(sourceSet.byteOrder, fileBytes).write((OutputStream)tempStream, sourceSet);
                        }
                        IOUtils.closeSilently((Closeable[])new Closeable[]{tempStream});
                        if (!destination.delete()) break block11;
                        IOUtils.copyFile((File)tempFile, (File)destination);
                    }
                    catch (Exception e) {
                        try {
                            CFLogs.APPLICATION_LOG.debug((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeSilently((Closeable[])new Closeable[]{tempStream});
                            if (tempFile != null) {
                                CFFileServlet.submitTaskForCleanup((File)tempFile, (int)0);
                            }
                            throw throwable;
                        }
                        IOUtils.closeSilently((Closeable[])new Closeable[]{tempStream});
                        if (tempFile != null) {
                            CFFileServlet.submitTaskForCleanup((File)tempFile, (int)0);
                        }
                    }
                }
                IOUtils.closeSilently((Closeable[])new Closeable[]{tempStream});
                if (tempFile != null) {
                    CFFileServlet.submitTaskForCleanup((File)tempFile, (int)0);
                }
                return null;
            }
        });
    }

    public static TiffOutputSet getOutputSet(Image img) {
        InputStream in = null;
        try {
            in = img.getInputStreamFromSource(null);
            return ExifMetaDataHelper.getOutputSet(in);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.debug((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiffOutputSet getOutputSet(InputStream source) {
        TiffOutputSet outputSet;
        block8: {
            TiffImageMetadata exif;
            block9: {
                if (source == null) {
                    return null;
                }
                outputSet = null;
                ImageMetadata metaData = Imaging.getMetadata((InputStream)source, null);
                if (metaData == null) break block8;
                exif = null;
                if (metaData instanceof JpegImageMetadata) {
                    JpegImageMetadata jpegImageMetaData = (JpegImageMetadata)metaData;
                    exif = jpegImageMetaData.getExif();
                    break block9;
                }
                if (metaData instanceof TiffImageMetadata) {
                    exif = (TiffImageMetadata)metaData;
                    break block9;
                }
                TiffOutputSet tiffOutputSet = null;
                IOUtils.closeSilently((Closeable[])new Closeable[]{source});
                return tiffOutputSet;
            }
            try {
                if (exif == null) break block8;
                outputSet = exif.getOutputSet();
            }
            catch (Exception e) {
                try {
                    CFLogs.APPLICATION_LOG.debug((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeSilently((Closeable[])new Closeable[]{source});
                    throw throwable;
                }
                IOUtils.closeSilently((Closeable[])new Closeable[]{source});
            }
        }
        IOUtils.closeSilently((Closeable[])new Closeable[]{source});
        return outputSet;
    }

    private static File _getTempImageFile() {
        String imgFileName;
        File imgFile;
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_IMAGE_FOLDER);
        if (!imgCleanupInitialized) {
            CFFileServlet.cleanupTempCache((File)tempDir, (int)ExifMetaDataHelper.getTempImgExpiryTime());
            tempDir.mkdirs();
            imgCleanupInitialized = true;
        }
        while ((imgFile = new File(tempDir, imgFileName = "_cfimg" + rand.nextLong())).exists()) {
        }
        return imgFile;
    }

    private static int getTempImgExpiryTime() {
        return ServiceFactory.getRuntimeService().getCFImageExpiryTime();
    }

    public static TiffOutputSet appendMetadata(TiffOutputSet sourceOutputSet, TiffOutputSet destOutputSet, String formatName) {
        if (sourceOutputSet != null) {
            List sourceDirectories = sourceOutputSet.getDirectories();
            for (int i = 0; i < sourceDirectories.size(); ++i) {
                TiffOutputDirectory sourceDirectory = (TiffOutputDirectory)sourceDirectories.get(i);
                TiffOutputDirectory destinationDirectory = null;
                if (formatName.equals("tiff") || formatName.equals("tif")) {
                    destinationDirectory = ExifMetaDataHelper.getOrCreateDirectory(destOutputSet, sourceDirectory);
                } else if (formatName.equals("jpeg") || formatName.equals("jpg")) {
                    destinationDirectory = ExifMetaDataHelper.getOrCreateDirectory(destOutputSet, sourceDirectory);
                }
                if (destinationDirectory == null) continue;
                List sourceFields = sourceDirectory.getFields();
                for (int j = 0; j < sourceFields.size(); ++j) {
                    TiffOutputField sourceField = (TiffOutputField)sourceFields.get(j);
                    if (destinationDirectory.findField(sourceField.tag) != null) continue;
                    destinationDirectory.add(sourceField);
                }
            }
        }
        return destOutputSet;
    }

    private static TiffOutputDirectory getOrCreateDirectory(TiffOutputSet outputSet, TiffOutputDirectory outputDirectory) {
        TiffOutputDirectory result = outputSet.findDirectory(outputDirectory.type);
        if (result != null) {
            return result;
        }
        result = new TiffOutputDirectory(outputDirectory.type, outputSet.byteOrder);
        try {
            outputSet.addDirectory(result);
        }
        catch (ImageWriteException e) {
            return null;
        }
        return result;
    }
}

