/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.slf4j.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Marker;
import macromedia.jdbc.sqlserver.externals.org.slf4j.event.LoggingEvent;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.FormattingTuple;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MarkerIgnoringBase;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MessageFormatter;
import macromedia.jdbc.sqlserver.externals.org.slf4j.spi.LocationAwareLogger;

public final class JDK14LoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    private static final long serialVersionUID = -8053026990503422791L;
    final transient Logger logger;
    static String SELF = JDK14LoggerAdapter.class.getName();
    static String SUPER = MarkerIgnoringBase.class.getName();

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String string) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(SELF, Level.FINEST, string, null);
        }
    }

    @Override
    public void trace(String string, Object object) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.log(SELF, Level.FINEST, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.log(SELF, Level.FINEST, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.log(SELF, Level.FINEST, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(SELF, Level.FINEST, string, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String string) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, string, null);
        }
    }

    @Override
    public void debug(String string, Object object) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.log(SELF, Level.FINE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.log(SELF, Level.FINE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.log(SELF, Level.FINE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, string, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String string) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(SELF, Level.INFO, string, null);
        }
    }

    @Override
    public void info(String string, Object object) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.log(SELF, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.log(SELF, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.log(SELF, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(SELF, Level.INFO, string, throwable);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String string) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, string, null);
        }
    }

    @Override
    public void warn(String string, Object object) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.log(SELF, Level.WARNING, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.log(SELF, Level.WARNING, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.log(SELF, Level.WARNING, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, string, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String string) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, string, null);
        }
    }

    @Override
    public void error(String string, Object object) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.log(SELF, Level.SEVERE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String string, Object object, Object object2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.log(SELF, Level.SEVERE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String string, Object ... objectArray) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.log(SELF, Level.SEVERE, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, string, throwable);
        }
    }

    private void log(String string, Level level, String string2, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setLoggerName(this.getName());
        logRecord.setThrown(throwable);
        this.fillCallerData(string, logRecord);
        this.logger.log(logRecord);
    }

    private final void fillCallerData(String string, LogRecord logRecord) {
        int n2;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n3 = -1;
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            String string2 = stackTraceElementArray[n2].getClassName();
            if (!string2.equals(string) && !string2.equals(SUPER)) continue;
            n3 = n2;
            break;
        }
        n2 = -1;
        for (int i2 = n3 + 1; i2 < stackTraceElementArray.length; ++i2) {
            String string3 = stackTraceElementArray[i2].getClassName();
            if (string3.equals(string) || string3.equals(SUPER)) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
    }

    @Override
    public void log(Marker marker, String string, int n2, String string2, Object[] objectArray, Throwable throwable) {
        Level level = this.slf4jLevelIntToJULLevel(n2);
        if (this.logger.isLoggable(level)) {
            this.log(string, level, string2, throwable);
        }
    }

    private Level slf4jLevelIntToJULLevel(int n2) {
        Level level;
        switch (n2) {
            case 0: {
                level = Level.FINEST;
                break;
            }
            case 10: {
                level = Level.FINE;
                break;
            }
            case 20: {
                level = Level.INFO;
                break;
            }
            case 30: {
                level = Level.WARNING;
                break;
            }
            case 40: {
                level = Level.SEVERE;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + n2 + " is not recognized.");
            }
        }
        return level;
    }

    public void log(LoggingEvent loggingEvent) {
        Level level = this.slf4jLevelIntToJULLevel(loggingEvent.getLevel().toInt());
        if (this.logger.isLoggable(level)) {
            LogRecord logRecord = this.eventToRecord(loggingEvent, level);
            this.logger.log(logRecord);
        }
    }

    private LogRecord eventToRecord(LoggingEvent loggingEvent, Level level) {
        Object[] objectArray;
        String string = loggingEvent.getMessage();
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray = loggingEvent.getArgumentArray());
        if (formattingTuple.getThrowable() != null && loggingEvent.getThrowable() != null) {
            throw new IllegalArgumentException("both last element in argument array and last argument are of type Throwable");
        }
        Throwable throwable = loggingEvent.getThrowable();
        if (formattingTuple.getThrowable() != null) {
            throwable = formattingTuple.getThrowable();
            throw new IllegalStateException("fix above code");
        }
        LogRecord logRecord = new LogRecord(level, formattingTuple.getMessage());
        logRecord.setLoggerName(loggingEvent.getLoggerName());
        logRecord.setMillis(loggingEvent.getTimeStamp());
        logRecord.setSourceClassName("NA/SubstituteLogger");
        logRecord.setSourceMethodName("NA/SubstituteLogger");
        logRecord.setThrown(throwable);
        return logRecord;
    }
}

