/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.BackChannelTokenDeliveryMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.RegistrationError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.SubjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.HashAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.SectorID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class OIDCClientMetadata
extends ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private ApplicationType applicationType;
    private SubjectType subjectType;
    private URI sectorIDURI;
    private JWSAlgorithm idTokenJWSAlg;
    private JWEAlgorithm idTokenJWEAlg;
    private EncryptionMethod idTokenJWEEnc;
    private JWSAlgorithm userInfoJWSAlg;
    private JWEAlgorithm userInfoJWEAlg;
    private EncryptionMethod userInfoJWEEnc;
    private int defaultMaxAge = -1;
    private boolean requiresAuthTime;
    private List<ACR> defaultACRs;
    private URI initiateLoginURI;
    private Set<URI> postLogoutRedirectURIs;
    private URI frontChannelLogoutURI;
    private boolean frontChannelLogoutSessionRequired = false;
    private URI backChannelLogoutURI;
    private boolean backChannelLogoutSessionRequired = false;
    private HashAlgorithm attachmentDigestAlg;

    public OIDCClientMetadata() {
    }

    public OIDCClientMetadata(ClientMetadata clientMetadata) {
        super(clientMetadata);
    }

    public OIDCClientMetadata(OIDCClientMetadata oIDCClientMetadata) {
        super(oIDCClientMetadata);
        this.applicationType = oIDCClientMetadata.getApplicationType();
        this.subjectType = oIDCClientMetadata.getSubjectType();
        this.sectorIDURI = oIDCClientMetadata.getSectorIDURI();
        this.idTokenJWSAlg = oIDCClientMetadata.getIDTokenJWSAlg();
        this.idTokenJWEAlg = oIDCClientMetadata.getIDTokenJWEAlg();
        this.idTokenJWEEnc = oIDCClientMetadata.getIDTokenJWEEnc();
        this.userInfoJWSAlg = oIDCClientMetadata.getUserInfoJWSAlg();
        this.userInfoJWEAlg = oIDCClientMetadata.getUserInfoJWEAlg();
        this.userInfoJWEEnc = oIDCClientMetadata.getUserInfoJWEEnc();
        this.defaultMaxAge = oIDCClientMetadata.getDefaultMaxAge();
        this.requiresAuthTime = oIDCClientMetadata.requiresAuthTime();
        this.defaultACRs = oIDCClientMetadata.getDefaultACRs();
        this.initiateLoginURI = oIDCClientMetadata.getInitiateLoginURI();
        this.postLogoutRedirectURIs = oIDCClientMetadata.getPostLogoutRedirectionURIs();
        this.frontChannelLogoutURI = oIDCClientMetadata.getFrontChannelLogoutURI();
        this.frontChannelLogoutSessionRequired = oIDCClientMetadata.requiresFrontChannelLogoutSession();
        this.backChannelLogoutURI = oIDCClientMetadata.getBackChannelLogoutURI();
        this.backChannelLogoutSessionRequired = oIDCClientMetadata.requiresBackChannelLogoutSession();
        this.attachmentDigestAlg = oIDCClientMetadata.getAttachmentDigestAlg();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URI getSectorIDURI() {
        return this.sectorIDURI;
    }

    public void setSectorIDURI(URI uRI) {
        if (uRI != null && !"urn".equalsIgnoreCase(uRI.getScheme())) {
            SectorID.ensureHTTPScheme(uRI);
            SectorID.ensureHostComponent(uRI);
        }
        this.sectorIDURI = uRI;
    }

    public SectorID resolveSectorID() {
        if (!SubjectType.PAIRWISE.equals((Object)this.getSubjectType())) {
            return null;
        }
        if (this.getSectorIDURI() != null) {
            return new SectorID(this.getSectorIDURI());
        }
        if (CollectionUtils.isNotEmpty(this.getRedirectionURIs()) && this.getBackChannelTokenDeliveryMode() != null) {
            throw new IllegalStateException("Couldn't resolve sector ID: A sector_identifier_uri is required when both redirect_uris and CIBA backchannel_token_delivery_mode are present");
        }
        if (CollectionUtils.isNotEmpty(this.getRedirectionURIs())) {
            if (this.getRedirectionURIs().size() > 1) {
                throw new IllegalStateException("Couldn't resolve sector ID: More than one URI in redirect_uris, sector_identifier_uri not specified");
            }
            return new SectorID(this.getRedirectionURIs().iterator().next());
        }
        if (BackChannelTokenDeliveryMode.POLL.equals(this.getBackChannelTokenDeliveryMode()) || BackChannelTokenDeliveryMode.PING.equals(this.getBackChannelTokenDeliveryMode())) {
            if (this.getJWKSetURI() == null) {
                throw new IllegalStateException("Couldn't resolve sector ID: A jwks_uri is required for CIBA poll or ping backchannel_token_delivery_mode");
            }
            return new SectorID(this.getJWKSetURI());
        }
        if (BackChannelTokenDeliveryMode.PUSH.equals(this.getBackChannelTokenDeliveryMode())) {
            if (this.getBackChannelClientNotificationEndpoint() == null) {
                throw new IllegalStateException("Couldn't resolve sector ID: A backchannel_client_notification_endpoint is required for CIBA push backchannel_token_delivery_mode");
            }
            return new SectorID(this.getBackChannelClientNotificationEndpoint());
        }
        throw new IllegalStateException("Couldn't resolve sector ID");
    }

    public JWSAlgorithm getIDTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.idTokenJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getIDTokenJWEAlg() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.idTokenJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getIDTokenJWEEnc() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEnc(EncryptionMethod encryptionMethod) {
        this.idTokenJWEEnc = encryptionMethod;
    }

    public JWSAlgorithm getUserInfoJWSAlg() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.userInfoJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getUserInfoJWEAlg() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.userInfoJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getUserInfoJWEEnc() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEnc(EncryptionMethod encryptionMethod) {
        this.userInfoJWEEnc = encryptionMethod;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int n2) {
        this.defaultMaxAge = n2;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean bl2) {
        this.requiresAuthTime = bl2;
    }

    public List<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(List<ACR> list) {
        this.defaultACRs = list;
    }

    public URI getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPS(uRI);
        this.initiateLoginURI = uRI;
    }

    public Set<URI> getPostLogoutRedirectionURIs() {
        return this.postLogoutRedirectURIs;
    }

    public void setPostLogoutRedirectionURIs(Set<URI> set) {
        if (set != null) {
            for (URI uRI : set) {
                URIUtils.ensureSchemeIsNotProhibited(uRI, PROHIBITED_REDIRECT_URI_SCHEMES);
            }
        }
        this.postLogoutRedirectURIs = set;
    }

    public URI getFrontChannelLogoutURI() {
        return this.frontChannelLogoutURI;
    }

    public void setFrontChannelLogoutURI(URI uRI) {
        if (uRI != null && uRI.getScheme() == null) {
            throw new IllegalArgumentException("Missing URI scheme");
        }
        this.frontChannelLogoutURI = uRI;
    }

    public boolean requiresFrontChannelLogoutSession() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void requiresFrontChannelLogoutSession(boolean bl2) {
        this.frontChannelLogoutSessionRequired = bl2;
    }

    public URI getBackChannelLogoutURI() {
        return this.backChannelLogoutURI;
    }

    public void setBackChannelLogoutURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.backChannelLogoutURI = uRI;
    }

    public boolean requiresBackChannelLogoutSession() {
        return this.backChannelLogoutSessionRequired;
    }

    public void requiresBackChannelLogoutSession(boolean bl2) {
        this.backChannelLogoutSessionRequired = bl2;
    }

    public HashAlgorithm getAttachmentDigestAlg() {
        return this.attachmentDigestAlg;
    }

    public void setAttachmentDigestAlg(HashAlgorithm hashAlgorithm) {
        this.attachmentDigestAlg = hashAlgorithm;
    }

    @Override
    public void applyDefaults() {
        super.applyDefaults();
        if (this.applicationType == null) {
            this.applicationType = ApplicationType.WEB;
        }
        if (this.idTokenJWSAlg == null) {
            this.idTokenJWSAlg = JWSAlgorithm.RS256;
        }
    }

    @Override
    public JSONObject toJSONObject(boolean bl2) {
        JSONArray jSONArray;
        JSONObject jSONObject = super.toJSONObject(bl2);
        jSONObject.putAll(this.getCustomFields());
        if (this.applicationType != null) {
            jSONObject.put("application_type", this.applicationType.toString());
        }
        if (this.subjectType != null) {
            jSONObject.put("subject_type", this.subjectType.toString());
        }
        if (this.sectorIDURI != null) {
            jSONObject.put("sector_identifier_uri", this.sectorIDURI.toString());
        }
        if (this.idTokenJWSAlg != null) {
            jSONObject.put("id_token_signed_response_alg", this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            jSONObject.put("id_token_encrypted_response_alg", this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            jSONObject.put("id_token_encrypted_response_enc", this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            jSONObject.put("userinfo_signed_response_alg", this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            jSONObject.put("userinfo_encrypted_response_alg", this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            jSONObject.put("userinfo_encrypted_response_enc", this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            jSONObject.put("default_max_age", this.defaultMaxAge);
        }
        if (this.requiresAuthTime()) {
            jSONObject.put("require_auth_time", this.requiresAuthTime);
        }
        if (this.defaultACRs != null) {
            jSONArray = new JSONArray();
            for (ACR comparable : this.defaultACRs) {
                jSONArray.add(comparable.getValue());
            }
            jSONObject.put("default_acr_values", jSONArray);
        }
        if (this.initiateLoginURI != null) {
            jSONObject.put("initiate_login_uri", this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURIs != null) {
            jSONArray = new JSONArray();
            for (URI uRI : this.postLogoutRedirectURIs) {
                jSONArray.add(uRI.toString());
            }
            jSONObject.put("post_logout_redirect_uris", jSONArray);
        }
        if (this.frontChannelLogoutURI != null) {
            jSONObject.put("frontchannel_logout_uri", this.frontChannelLogoutURI.toString());
            jSONObject.put("frontchannel_logout_session_required", this.frontChannelLogoutSessionRequired);
        }
        if (this.backChannelLogoutURI != null) {
            jSONObject.put("backchannel_logout_uri", this.backChannelLogoutURI.toString());
            jSONObject.put("backchannel_logout_session_required", this.backChannelLogoutSessionRequired);
        }
        if (this.attachmentDigestAlg != null) {
            jSONObject.put("digest_algorithm", this.attachmentDigestAlg.getValue());
        }
        return jSONObject;
    }

    public static OIDCClientMetadata parse(JSONObject jSONObject) throws ParseException {
        ClientMetadata clientMetadata = ClientMetadata.parse(jSONObject);
        OIDCClientMetadata oIDCClientMetadata = new OIDCClientMetadata(clientMetadata);
        JSONObject jSONObject2 = clientMetadata.getCustomFields();
        try {
            LinkedList<ACR> linkedList;
            if (jSONObject.get("application_type") != null) {
                oIDCClientMetadata.setApplicationType(JSONObjectUtils.getEnum(jSONObject, "application_type", ApplicationType.class));
                jSONObject2.remove("application_type");
            }
            if (jSONObject.get("subject_type") != null) {
                oIDCClientMetadata.setSubjectType(JSONObjectUtils.getEnum(jSONObject, "subject_type", SubjectType.class));
                jSONObject2.remove("subject_type");
            }
            if (jSONObject.get("sector_identifier_uri") != null) {
                try {
                    oIDCClientMetadata.setSectorIDURI(JSONObjectUtils.getURI(jSONObject, "sector_identifier_uri"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid sector_identifier_uri parameter: " + illegalArgumentException.getMessage());
                }
                jSONObject2.remove("sector_identifier_uri");
            }
            if (jSONObject.get("id_token_signed_response_alg") != null) {
                oIDCClientMetadata.setIDTokenJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "id_token_signed_response_alg")));
                jSONObject2.remove("id_token_signed_response_alg");
            }
            if (jSONObject.get("id_token_encrypted_response_alg") != null) {
                oIDCClientMetadata.setIDTokenJWEAlg(JWEAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "id_token_encrypted_response_alg")));
                jSONObject2.remove("id_token_encrypted_response_alg");
            }
            if (jSONObject.get("id_token_encrypted_response_enc") != null) {
                oIDCClientMetadata.setIDTokenJWEEnc(EncryptionMethod.parse(JSONObjectUtils.getString(jSONObject, "id_token_encrypted_response_enc")));
                jSONObject2.remove("id_token_encrypted_response_enc");
            }
            if (jSONObject.get("userinfo_signed_response_alg") != null) {
                oIDCClientMetadata.setUserInfoJWSAlg(JWSAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "userinfo_signed_response_alg")));
                jSONObject2.remove("userinfo_signed_response_alg");
            }
            if (jSONObject.get("userinfo_encrypted_response_alg") != null) {
                oIDCClientMetadata.setUserInfoJWEAlg(JWEAlgorithm.parse(JSONObjectUtils.getString(jSONObject, "userinfo_encrypted_response_alg")));
                jSONObject2.remove("userinfo_encrypted_response_alg");
            }
            if (jSONObject.get("userinfo_encrypted_response_enc") != null) {
                oIDCClientMetadata.setUserInfoJWEEnc(EncryptionMethod.parse(JSONObjectUtils.getString(jSONObject, "userinfo_encrypted_response_enc")));
                jSONObject2.remove("userinfo_encrypted_response_enc");
            }
            if (jSONObject.get("default_max_age") != null) {
                oIDCClientMetadata.setDefaultMaxAge(JSONObjectUtils.getInt(jSONObject, "default_max_age"));
                jSONObject2.remove("default_max_age");
            }
            if (jSONObject.get("require_auth_time") != null) {
                oIDCClientMetadata.requiresAuthTime(JSONObjectUtils.getBoolean(jSONObject, "require_auth_time"));
                jSONObject2.remove("require_auth_time");
            }
            if (jSONObject.get("default_acr_values") != null) {
                linkedList = new LinkedList();
                for (String string : JSONObjectUtils.getStringArray(jSONObject, "default_acr_values")) {
                    linkedList.add(new ACR(string));
                }
                oIDCClientMetadata.setDefaultACRs(linkedList);
                jSONObject2.remove("default_acr_values");
            }
            if (jSONObject.get("initiate_login_uri") != null) {
                try {
                    oIDCClientMetadata.setInitiateLoginURI(JSONObjectUtils.getURI(jSONObject, "initiate_login_uri"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid initiate_login_uri parameter: " + illegalArgumentException.getMessage());
                }
                jSONObject2.remove("initiate_login_uri");
            }
            if (jSONObject.get("post_logout_redirect_uris") != null) {
                linkedList = new LinkedHashSet();
                for (String string : JSONObjectUtils.getStringArray(jSONObject, "post_logout_redirect_uris")) {
                    try {
                        linkedList.add((ACR)((Object)new URI(string)));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ParseException("Invalid post_logout_redirect_uris parameter");
                    }
                }
                try {
                    oIDCClientMetadata.setPostLogoutRedirectionURIs((Set<URI>)((Object)linkedList));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid post_logout_redirect_uris parameter: " + illegalArgumentException.getMessage());
                }
                jSONObject2.remove("post_logout_redirect_uris");
            }
            if (jSONObject.get("frontchannel_logout_uri") != null) {
                try {
                    oIDCClientMetadata.setFrontChannelLogoutURI(JSONObjectUtils.getURI(jSONObject, "frontchannel_logout_uri"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid frontchannel_logout_uri parameter: " + illegalArgumentException.getMessage());
                }
                jSONObject2.remove("frontchannel_logout_uri");
                if (jSONObject.get("frontchannel_logout_session_required") != null) {
                    oIDCClientMetadata.requiresFrontChannelLogoutSession(JSONObjectUtils.getBoolean(jSONObject, "frontchannel_logout_session_required"));
                    jSONObject2.remove("frontchannel_logout_session_required");
                }
            }
            if (jSONObject.get("backchannel_logout_uri") != null) {
                try {
                    oIDCClientMetadata.setBackChannelLogoutURI(JSONObjectUtils.getURI(jSONObject, "backchannel_logout_uri"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid backchannel_logout_uri parameter: " + illegalArgumentException.getMessage());
                }
                jSONObject2.remove("backchannel_logout_uri");
                if (jSONObject.get("backchannel_logout_session_required") != null) {
                    oIDCClientMetadata.requiresBackChannelLogoutSession(JSONObjectUtils.getBoolean(jSONObject, "backchannel_logout_session_required"));
                    jSONObject2.remove("backchannel_logout_session_required");
                }
            }
            if (jSONObject.get("digest_algorithm") != null) {
                oIDCClientMetadata.setAttachmentDigestAlg(new HashAlgorithm(JSONObjectUtils.getString(jSONObject, "digest_algorithm")));
                jSONObject2.remove("digest_algorithm");
            }
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + parseException.getMessage()), parseException.getCause());
        }
        oIDCClientMetadata.setCustomFields(jSONObject2);
        return oIDCClientMetadata;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        hashSet.add("application_type");
        hashSet.add("subject_type");
        hashSet.add("sector_identifier_uri");
        hashSet.add("id_token_signed_response_alg");
        hashSet.add("id_token_encrypted_response_alg");
        hashSet.add("id_token_encrypted_response_enc");
        hashSet.add("userinfo_signed_response_alg");
        hashSet.add("userinfo_encrypted_response_alg");
        hashSet.add("userinfo_encrypted_response_enc");
        hashSet.add("default_max_age");
        hashSet.add("require_auth_time");
        hashSet.add("default_acr_values");
        hashSet.add("initiate_login_uri");
        hashSet.add("post_logout_redirect_uris");
        hashSet.add("frontchannel_logout_uri");
        hashSet.add("frontchannel_logout_session_required");
        hashSet.add("backchannel_logout_uri");
        hashSet.add("backchannel_logout_session_required");
        hashSet.add("digest_algorithm");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

