/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.factories;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicyEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.factories.PolicyFormulationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.factories.RPMetadataPolicyFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.ValueOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@ThreadSafe
public class DefaultRPMetadataPolicyFactory
implements RPMetadataPolicyFactory {
    @Override
    public MetadataPolicy create(OIDCClientMetadata oIDCClientMetadata, OIDCClientInformation oIDCClientInformation) throws PolicyFormulationException {
        MetadataPolicy metadataPolicy = new MetadataPolicy();
        JSONObject jSONObject = oIDCClientMetadata.toJSONObject();
        for (Map.Entry<String, Object> entry : oIDCClientInformation.toJSONObject().entrySet()) {
            if (entry.equals(new AbstractMap.SimpleImmutableEntry(entry.getKey(), jSONObject.get(entry.getKey())))) continue;
            MetadataPolicyEntry metadataPolicyEntry = new MetadataPolicyEntry((String)entry.getKey(), Collections.singletonList(DefaultRPMetadataPolicyFactory.createValueOperation(entry)));
            metadataPolicy.put(metadataPolicyEntry);
        }
        return metadataPolicy;
    }

    private static ValueOperation createValueOperation(Map.Entry<String, Object> entry) throws PolicyFormulationException {
        ValueOperation valueOperation = new ValueOperation();
        if (entry.getValue() instanceof String) {
            valueOperation.configure((String)entry.getValue());
        } else if (entry.getValue() instanceof Boolean) {
            valueOperation.configure((Boolean)entry.getValue());
        } else if (entry.getValue() instanceof Number) {
            valueOperation.configure((Number)entry.getValue());
        } else if (entry.getValue() instanceof List) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Object e2 : (List)entry.getValue()) {
                if (e2 instanceof String) {
                    linkedList.add((String)e2);
                    continue;
                }
                linkedList.add(null);
            }
            valueOperation.configure(linkedList);
        } else if (entry.getValue() == null) {
            valueOperation.configure((String)null);
        } else {
            throw new PolicyFormulationException("Unsupported type for " + entry.getKey() + ": " + entry.getValue().getClass() + ": " + entry.getValue());
        }
        return valueOperation;
    }
}

