/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.CountryCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class Address
extends ClaimsSet {
    public static final String FORMATTED_CLAIM_NAME = "formatted";
    public static final String STREET_ADDRESS_CLAIM_NAME = "street_address";
    public static final String LOCALITY_CLAIM_NAME = "locality";
    public static final String REGION_CLAIM_NAME = "region";
    public static final String POSTAL_CODE_CLAIM_NAME = "postal_code";
    public static final String COUNTRY_CLAIM_NAME = "country";
    public static final String COUNTRY_CODE_CLAIM_NAME = "country_code";
    private static final Set<String> stdClaimNames = new LinkedHashSet<String>();

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public Address() {
    }

    public Address(JSONObject jSONObject) {
        super(jSONObject);
    }

    public void setFormatted(String string) {
        this.setClaim(FORMATTED_CLAIM_NAME, string);
    }

    public String getFormatted() {
        return this.getStringClaim(FORMATTED_CLAIM_NAME);
    }

    public void setStreetAddress(String string) {
        this.setClaim(STREET_ADDRESS_CLAIM_NAME, string);
    }

    public String getStreetAddress() {
        return this.getStringClaim(STREET_ADDRESS_CLAIM_NAME);
    }

    public void setLocality(String string) {
        this.setClaim(LOCALITY_CLAIM_NAME, string);
    }

    public String getLocality() {
        return this.getStringClaim(LOCALITY_CLAIM_NAME);
    }

    public void setRegion(String string) {
        this.setClaim(REGION_CLAIM_NAME, string);
    }

    public String getRegion() {
        return this.getStringClaim(REGION_CLAIM_NAME);
    }

    public void setPostalCode(String string) {
        this.setClaim(POSTAL_CODE_CLAIM_NAME, string);
    }

    public String getPostalCode() {
        return this.getStringClaim(POSTAL_CODE_CLAIM_NAME);
    }

    public void setCountry(String string) {
        this.setClaim(COUNTRY_CLAIM_NAME, string);
    }

    public String getCountry() {
        return this.getStringClaim(COUNTRY_CLAIM_NAME);
    }

    public void setCountryCode(CountryCode countryCode) {
        String string = countryCode != null ? countryCode.getValue() : null;
        this.setClaim(COUNTRY_CODE_CLAIM_NAME, string);
    }

    public CountryCode getCountryCode() {
        String string = this.getStringClaim(COUNTRY_CODE_CLAIM_NAME);
        if (string == null) {
            return null;
        }
        try {
            return CountryCode.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Address parse(String string) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse(string);
        try {
            return new Address(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    static {
        stdClaimNames.add(FORMATTED_CLAIM_NAME);
        stdClaimNames.add(STREET_ADDRESS_CLAIM_NAME);
        stdClaimNames.add(LOCALITY_CLAIM_NAME);
        stdClaimNames.add(REGION_CLAIM_NAME);
        stdClaimNames.add(POSTAL_CODE_CLAIM_NAME);
        stdClaimNames.add(COUNTRY_CLAIM_NAME);
        stdClaimNames.add(COUNTRY_CODE_CLAIM_NAME);
    }
}

