/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class Tokens {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public Tokens(AccessToken accessToken, RefreshToken refreshToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public BearerAccessToken getBearerAccessToken() {
        if (this.accessToken instanceof BearerAccessToken) {
            return (BearerAccessToken)this.accessToken;
        }
        if (AccessTokenType.BEARER.equals(this.accessToken.getType())) {
            return new BearerAccessToken(this.accessToken.getValue(), this.accessToken.getLifetime(), this.accessToken.getScope(), this.accessToken.getIssuedTokenType());
        }
        return null;
    }

    public DPoPAccessToken getDPoPAccessToken() {
        if (this.accessToken instanceof DPoPAccessToken) {
            return (DPoPAccessToken)this.accessToken;
        }
        if (AccessTokenType.DPOP.equals(this.accessToken.getType())) {
            return new DPoPAccessToken(this.accessToken.getValue(), this.accessToken.getLifetime(), this.accessToken.getScope(), this.accessToken.getIssuedTokenType());
        }
        return null;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getParameterNames() {
        Set<String> set = this.accessToken.getParameterNames();
        if (this.refreshToken != null) {
            set.addAll(this.refreshToken.getParameterNames());
        }
        return Collections.unmodifiableSet(set);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            jSONObject.putAll(this.refreshToken.toJSONObject());
        }
        return jSONObject;
    }

    public OIDCTokens toOIDCTokens() {
        return (OIDCTokens)this;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static Tokens parse(JSONObject jSONObject) throws ParseException {
        return new Tokens(AccessToken.parse(jSONObject), RefreshToken.parse(jSONObject));
    }
}

