/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;

public abstract class TokenSchemeError
extends ErrorObject {
    private static final long serialVersionUID = -1132784406578139418L;
    static final Pattern REALM_PATTERN = Pattern.compile("realm=\"(([^\\\\\"]|\\\\.){0,256})\"");
    static final Pattern ERROR_PATTERN = Pattern.compile("error=(\"([\\w\\_-]+)\"|([\\w\\_-]+))");
    static final Pattern ERROR_DESCRIPTION_PATTERN = Pattern.compile("error_description=\"([^\"]+)\"");
    static final Pattern ERROR_URI_PATTERN = Pattern.compile("error_uri=\"([^\"]+)\"");
    static final Pattern SCOPE_PATTERN = Pattern.compile("scope=\"([^\"]+)");
    private final AccessTokenType scheme;
    private final String realm;
    private final Scope scope;

    public static boolean isScopeWithValidChars(Scope scope) {
        return ErrorObject.isLegal(scope.toString());
    }

    protected TokenSchemeError(AccessTokenType accessTokenType, String string, String string2, int n2, URI uRI, String string3, Scope scope) {
        super(string, string2, n2, uRI);
        if (accessTokenType == null) {
            throw new IllegalArgumentException("The token scheme must not be null");
        }
        this.scheme = accessTokenType;
        this.realm = string3;
        this.scope = scope;
        if (scope != null && !TokenSchemeError.isScopeWithValidChars(scope)) {
            throw new IllegalArgumentException("The scope contains illegal characters, see RFC 6750, section 3");
        }
    }

    public AccessTokenType getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.realm;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public abstract TokenSchemeError setDescription(String var1);

    @Override
    public abstract TokenSchemeError appendDescription(String var1);

    @Override
    public abstract TokenSchemeError setHTTPStatusCode(int var1);

    @Override
    public abstract TokenSchemeError setURI(URI var1);

    public abstract TokenSchemeError setRealm(String var1);

    public abstract TokenSchemeError setScope(Scope var1);

    public String toWWWAuthenticateHeader() {
        StringBuilder stringBuilder = new StringBuilder(this.getScheme().getValue());
        int n2 = 0;
        if (this.getRealm() != null) {
            stringBuilder.append(" realm=\"");
            stringBuilder.append(this.getRealm().replaceAll("\"", "\\\\\""));
            stringBuilder.append('\"');
            ++n2;
        }
        if (this.getCode() != null) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" error=\"");
            stringBuilder.append(this.getCode());
            stringBuilder.append('\"');
            ++n2;
            if (this.getDescription() != null) {
                stringBuilder.append(',');
                stringBuilder.append(" error_description=\"");
                stringBuilder.append(this.getDescription());
                stringBuilder.append('\"');
                ++n2;
            }
            if (this.getURI() != null) {
                stringBuilder.append(',');
                stringBuilder.append(" error_uri=\"");
                stringBuilder.append(this.getURI().toString());
                stringBuilder.append('\"');
                ++n2;
            }
        }
        if (this.getScope() != null) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" scope=\"");
            stringBuilder.append(this.getScope().toString());
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    static TokenSchemeError parse(String string, AccessTokenType accessTokenType) throws ParseException {
        if (!string.regionMatches(true, 0, accessTokenType.getValue(), 0, accessTokenType.getValue().length())) {
            throw new ParseException("WWW-Authenticate scheme must be OAuth 2.0 DPoP");
        }
        Matcher matcher = REALM_PATTERN.matcher(string);
        String string2 = null;
        if (matcher.find()) {
            string2 = matcher.group(1);
        }
        if (string2 != null) {
            string2 = string2.replace("\\\"", "\"");
        }
        String string3 = null;
        String string4 = null;
        URI uRI = null;
        matcher = ERROR_PATTERN.matcher(string);
        if (matcher.find()) {
            String string5 = string3 = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
            if (!ErrorObject.isLegal(string3)) {
                string3 = null;
            }
            if ((matcher = ERROR_DESCRIPTION_PATTERN.matcher(string)).find()) {
                string4 = matcher.group(1);
            }
            if ((matcher = ERROR_URI_PATTERN.matcher(string)).find()) {
                try {
                    uRI = new URI(matcher.group(1));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        Scope scope = null;
        matcher = SCOPE_PATTERN.matcher(string);
        if (matcher.find()) {
            scope = Scope.parse(matcher.group(1));
        }
        return new TokenSchemeError(AccessTokenType.UNKNOWN, string3, string4, 0, uRI, string2, scope){
            private static final long serialVersionUID = -1629382220440634919L;

            @Override
            public TokenSchemeError setDescription(String string) {
                return null;
            }

            @Override
            public TokenSchemeError appendDescription(String string) {
                return null;
            }

            @Override
            public TokenSchemeError setHTTPStatusCode(int n2) {
                return null;
            }

            @Override
            public TokenSchemeError setURI(URI uRI) {
                return null;
            }

            @Override
            public TokenSchemeError setRealm(String string) {
                return null;
            }

            @Override
            public TokenSchemeError setScope(Scope scope) {
                return null;
            }
        };
    }
}

