/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;

public final class JARMUtils {
    public static final Set<ResponseMode> RESPONSE_MODES = new HashSet<ResponseMode>(Arrays.asList(ResponseMode.JWT, ResponseMode.QUERY_JWT, ResponseMode.FRAGMENT_JWT, ResponseMode.FORM_POST_JWT));

    public static boolean supportsJARM(AuthorizationServerMetadata authorizationServerMetadata) {
        if (CollectionUtils.isEmpty(authorizationServerMetadata.getAuthorizationJWSAlgs())) {
            return false;
        }
        if (CollectionUtils.isEmpty(authorizationServerMetadata.getResponseModes())) {
            return false;
        }
        for (ResponseMode responseMode : RESPONSE_MODES) {
            if (!authorizationServerMetadata.getResponseModes().contains(responseMode)) continue;
            return true;
        }
        return false;
    }

    public static JWTClaimsSet toJWTClaimsSet(Issuer issuer, ClientID clientID, Date date, AuthorizationResponse authorizationResponse) {
        if (date == null) {
            throw new IllegalArgumentException("The expiration time must not be null");
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(issuer.getValue()).audience(clientID.getValue()).expirationTime(date);
        for (Map.Entry<String, String> entry : MultivaluedMapUtils.toSingleValuedMap(authorizationResponse.toParameters()).entrySet()) {
            if ("response".equals(entry.getKey())) continue;
            if ("iss".equals(entry.getKey()) && !issuer.getValue().equals(entry.getValue())) {
                throw new IllegalArgumentException("Authorization response iss doesn't match JWT iss claim: " + entry.getValue());
            }
            builder = builder.claim(entry.getKey(), entry.getValue() + "");
        }
        return builder.build();
    }

    public static Map<String, List<String>> toMultiValuedStringParameters(JWTClaimsSet jWTClaimsSet) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : jWTClaimsSet.getClaims().entrySet()) {
            hashMap.put(entry.getKey(), Collections.singletonList(entry.getValue() + ""));
        }
        return hashMap;
    }

    public static boolean impliesAuthorizationErrorResponse(String string) throws ParseException {
        try {
            return JARMUtils.impliesAuthorizationErrorResponse(JWTParser.parse(string));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid JWT-secured authorization response: " + parseException.getMessage(), parseException);
        }
    }

    public static boolean impliesAuthorizationErrorResponse(JWT jWT) throws ParseException {
        if (jWT instanceof PlainJWT) {
            throw new ParseException("Invalid JWT-secured authorization response: The JWT must not be plain (unsecured)");
        }
        if (jWT instanceof EncryptedJWT) {
            return false;
        }
        if (jWT instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jWT;
            try {
                return signedJWT.getJWTClaimsSet().getStringClaim("error") != null;
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid JWT claims set: " + parseException.getMessage());
            }
        }
        throw new ParseException("Unexpected JWT type");
    }

    private JARMUtils() {
    }
}

