/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers;

import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.singleuse.AlreadyUsedException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class DPoPProofClaimsSetVerifier
extends DefaultJWTClaimsVerifier<DPoPProofContext> {
    private final long maxClockSkewSeconds;
    private final SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker;

    public DPoPProofClaimsSetVerifier(String string, URI uRI, long l2, boolean bl2, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        super(new JWTClaimsSet.Builder().claim("htm", string).claim("htu", URIUtils.getBaseURI(uRI).toString()).build(), new HashSet<String>(bl2 ? Arrays.asList("jti", "iat", "ath") : Arrays.asList("jti", "iat")));
        this.maxClockSkewSeconds = l2;
        this.singleUseChecker = singleUseChecker;
    }

    @Override
    public void verify(JWTClaimsSet jWTClaimsSet, DPoPProofContext dPoPProofContext) throws BadJWTException {
        Serializable serializable;
        super.verify(jWTClaimsSet, dPoPProofContext);
        Date date = jWTClaimsSet.getIssueTime();
        Date date2 = new Date();
        Date date3 = new Date(date2.getTime() - this.maxClockSkewSeconds * 1000L);
        Date date4 = new Date(date2.getTime() + this.maxClockSkewSeconds * 1000L);
        if (date.before(date3)) {
            throw new BadJWTException("The JWT iat claim is behind the current time by more than " + this.maxClockSkewSeconds + " seconds");
        }
        if (date.after(date4)) {
            throw new BadJWTException("The JWT iat claim is ahead of the current time by more than " + this.maxClockSkewSeconds + " seconds");
        }
        if (this.singleUseChecker != null) {
            serializable = new JWTID(jWTClaimsSet.getJWTID());
            try {
                this.singleUseChecker.markAsUsed(new AbstractMap.SimpleImmutableEntry<DPoPIssuer, JWTID>(dPoPProofContext.getIssuer(), (JWTID)serializable));
            }
            catch (AlreadyUsedException alreadyUsedException) {
                throw new BadJWTException("The jti was used before: " + serializable);
            }
        }
        if (this.getRequiredClaims().contains("ath")) {
            try {
                serializable = new Base64URL(jWTClaimsSet.getStringClaim("ath"));
            }
            catch (ParseException parseException) {
                throw new BadJWTException("Invalid ath claim: " + parseException.getMessage(), parseException);
            }
            dPoPProofContext.setAccessTokenHash((Base64URL)serializable);
        }
    }
}

