/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class CIBAPingCallback
extends ProtectedResourceRequest {
    private final AuthRequestID authRequestID;

    public CIBAPingCallback(URI uRI, BearerAccessToken bearerAccessToken, AuthRequestID authRequestID) {
        super(uRI, bearerAccessToken);
        if (authRequestID == null) {
            throw new IllegalArgumentException("The auth_req_id must not be null");
        }
        this.authRequestID = authRequestID;
    }

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setFollowRedirects(false);
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("auth_req_id", this.getAuthRequestID().getValue());
        hTTPRequest.setQuery(jSONObject.toJSONString());
        return hTTPRequest;
    }

    public static CIBAPingCallback parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_JSON);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse(hTTPRequest);
        AuthRequestID authRequestID = new AuthRequestID(JSONObjectUtils.getString(hTTPRequest.getQueryAsJSONObject(), "auth_req_id"));
        return new CIBAPingCallback(uRI, bearerAccessToken, authRequestID);
    }
}

