/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class X509CertificateConfirmation {
    private final Base64URL x5tS256;

    public X509CertificateConfirmation(Base64URL base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The X.509 certificate thumbprint must not be null");
        }
        this.x5tS256 = base64URL;
    }

    public Base64URL getValue() {
        return this.x5tS256;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        Map.Entry<String, JSONObject> entry = this.toJWTClaim();
        jSONObject.put(entry.getKey(), entry.getValue());
        return jSONObject;
    }

    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x5t#S256", this.x5tS256.toString());
        return new AbstractMap.SimpleImmutableEntry<String, JSONObject>("cnf", jSONObject);
    }

    public JWTClaimsSet applyTo(JWTClaimsSet jWTClaimsSet) {
        Map.Entry<String, JSONObject> entry = this.toJWTClaim();
        return new JWTClaimsSet.Builder(jWTClaimsSet).claim(entry.getKey(), entry.getValue()).build();
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CertificateConfirmation)) {
            return false;
        }
        X509CertificateConfirmation x509CertificateConfirmation = (X509CertificateConfirmation)object;
        return this.x5tS256.equals(x509CertificateConfirmation.x5tS256);
    }

    public int hashCode() {
        return Objects.hash(this.x5tS256);
    }

    public static X509CertificateConfirmation parse(JWTClaimsSet jWTClaimsSet) {
        Map<String, Object> map;
        try {
            map = jWTClaimsSet.getJSONObjectClaim("cnf");
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
        if (map == null) {
            return null;
        }
        return X509CertificateConfirmation.parseFromConfirmationJSONObject(new JSONObject(map));
    }

    public static X509CertificateConfirmation parse(JSONObject jSONObject) {
        if (!jSONObject.containsKey("cnf")) {
            return null;
        }
        try {
            return X509CertificateConfirmation.parseFromConfirmationJSONObject(JSONObjectUtils.getJSONObject(jSONObject, "cnf"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static X509CertificateConfirmation parseFromConfirmationJSONObject(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            String string = JSONObjectUtils.getString(jSONObject, "x5t#S256");
            return new X509CertificateConfirmation(new Base64URL(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static X509CertificateConfirmation of(X509Certificate x509Certificate) {
        return new X509CertificateConfirmation(X509CertUtils.computeSHA256Thumbprint(x509Certificate));
    }
}

