/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.BadSAML2AssertionException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetailsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ThreadSafe
public class SAML2AssertionValidator {
    private final SAML2AssertionDetailsVerifier detailsVerifier;

    public SAML2AssertionValidator(SAML2AssertionDetailsVerifier sAML2AssertionDetailsVerifier) {
        if (sAML2AssertionDetailsVerifier == null) {
            throw new IllegalArgumentException("The SAML 2.0 assertion details verifier must not be null");
        }
        this.detailsVerifier = sAML2AssertionDetailsVerifier;
    }

    public SAML2AssertionDetailsVerifier getDetailsVerifier() {
        return this.detailsVerifier;
    }

    public static Assertion parse(String string) throws ParseException {
        XMLObject xMLObject;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))));
            Element element = document.getDocumentElement();
            xMLObject = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(element).unmarshall(element);
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException throwable) {
            throw new ParseException("SAML 2.0 assertion parsing failed: " + throwable.getMessage(), throwable);
        }
        if (!(xMLObject instanceof Assertion)) {
            throw new ParseException("Top-level XML element not a SAML 2.0 assertion");
        }
        return (Assertion)xMLObject;
    }

    public static void verifySignature(Signature signature, Key key) throws BadSAML2AssertionException {
        BasicCredential basicCredential;
        SAMLSignatureProfileValidator sAMLSignatureProfileValidator = new SAMLSignatureProfileValidator();
        try {
            sAMLSignatureProfileValidator.validate(signature);
        }
        catch (SignatureException signatureException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 signature format: " + signatureException.getMessage(), signatureException);
        }
        if (key instanceof SecretKey) {
            basicCredential = new BasicCredential((SecretKey)key);
        } else if (key instanceof PublicKey) {
            basicCredential = new BasicCredential((PublicKey)key);
            basicCredential.setUsageType(UsageType.SIGNING);
        } else {
            throw new BadSAML2AssertionException("Unsupported key type: " + key.getAlgorithm());
        }
        try {
            SignatureValidator.validate((Signature)signature, (Credential)basicCredential);
        }
        catch (SignatureException signatureException) {
            throw new BadSAML2AssertionException("Bad SAML 2.0 signature: " + signatureException.getMessage(), signatureException);
        }
    }

    public Assertion validate(Assertion assertion, Issuer issuer, Key key) throws BadSAML2AssertionException {
        SAML2AssertionDetails sAML2AssertionDetails;
        try {
            sAML2AssertionDetails = SAML2AssertionDetails.parse(assertion);
        }
        catch (ParseException parseException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + parseException.getMessage(), parseException);
        }
        this.detailsVerifier.verify(sAML2AssertionDetails);
        if (!issuer.equals(sAML2AssertionDetails.getIssuer())) {
            throw new BadSAML2AssertionException("Unexpected issuer: " + sAML2AssertionDetails.getIssuer());
        }
        if (!assertion.isSigned()) {
            throw new BadSAML2AssertionException("Missing XML signature");
        }
        SAML2AssertionValidator.verifySignature(assertion.getSignature(), key);
        return assertion;
    }

    public Assertion validate(String string, Issuer issuer, Key key) throws BadSAML2AssertionException {
        Assertion assertion;
        try {
            assertion = SAML2AssertionValidator.parse(string);
        }
        catch (ParseException parseException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + parseException.getMessage(), parseException);
        }
        return this.validate(assertion, issuer, key);
    }

    static {
        try {
            InitializationService.initialize();
        }
        catch (InitializationException initializationException) {
            throw new RuntimeException(initializationException.getMessage(), initializationException);
        }
    }
}

