/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2Utils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class SAML2AssertionFactory {
    public static Assertion create(SAML2AssertionDetails sAML2AssertionDetails, String string, Credential credential) {
        Assertion assertion = sAML2AssertionDetails.toSAML2Assertion();
        Signature signature = SAML2Utils.buildSAMLObject(Signature.class);
        signature.setSigningCredential(credential);
        signature.setSignatureAlgorithm(string);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        assertion.setSignature(signature);
        try {
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException | SignatureException throwable) {
            throw new SerializeException(throwable.getMessage(), throwable);
        }
        return assertion;
    }

    public static Element createAsElement(SAML2AssertionDetails sAML2AssertionDetails, String string, Credential credential) {
        Assertion assertion = SAML2AssertionFactory.create(sAML2AssertionDetails, string, credential);
        try {
            return XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion);
        }
        catch (MarshallingException marshallingException) {
            throw new SerializeException(marshallingException.getMessage(), marshallingException);
        }
    }

    public static String createAsString(SAML2AssertionDetails sAML2AssertionDetails, String string, Credential credential) {
        Element element = SAML2AssertionFactory.createAsElement(sAML2AssertionDetails, string, credential);
        String string2 = SerializeSupport.nodeToString((Node)element);
        String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        if (string2.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            string2 = string2.substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length());
        }
        return string2;
    }

    public static String createAsString(SAML2AssertionDetails sAML2AssertionDetails, RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) {
        BasicCredential basicCredential = new BasicCredential((PublicKey)rSAPublicKey, (PrivateKey)rSAPrivateKey);
        basicCredential.setUsageType(UsageType.SIGNING);
        return SAML2AssertionFactory.createAsString(sAML2AssertionDetails, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Credential)basicCredential);
    }

    private SAML2AssertionFactory() {
    }
}

