/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.MACSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSASSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;

public class JWTAssertionFactory {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet<JWSAlgorithm> hashSet = new HashSet<JWSAlgorithm>();
        hashSet.addAll(JWSAlgorithm.Family.HMAC_SHA);
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        hashSet.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(hashSet);
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jWSAlgorithm), jWTAssertionDetails.toJWTClaimsSet());
        signedJWT.sign(new MACSigner(secret.getValueBytes()));
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jWSAlgorithm).keyID(string).build(), jWTAssertionDetails.toJWTClaimsSet());
        RSASSASigner rSASSASigner = new RSASSASigner(rSAPrivateKey);
        if (provider != null) {
            rSASSASigner.getJCAContext().setProvider(provider);
        }
        signedJWT.sign(rSASSASigner);
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jWSAlgorithm).keyID(string).build(), jWTAssertionDetails.toJWTClaimsSet());
        ECDSASigner eCDSASigner = new ECDSASigner(eCPrivateKey);
        if (provider != null) {
            eCDSASigner.getJCAContext().setProvider(provider);
        }
        signedJWT.sign(eCDSASigner);
        return signedJWT;
    }

    private JWTAssertionFactory() {
    }
}

