/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PKITLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.SelfSignedTLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Deprecated
@Immutable
public final class RequestObjectPOSTRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final JWT requestObject;
    private final JSONObject requestJSONObject;

    public RequestObjectPOSTRequest(URI uRI, JWT jWT) {
        super(uRI, null);
        if (jWT == null) {
            throw new IllegalArgumentException("The request object must not be null");
        }
        if (jWT instanceof PlainJWT) {
            throw new IllegalArgumentException("The request object must not be an unsecured JWT (alg=none)");
        }
        this.requestObject = jWT;
        this.requestJSONObject = null;
    }

    public RequestObjectPOSTRequest(URI uRI, TLSClientAuthentication tLSClientAuthentication, JSONObject jSONObject) {
        super(uRI, tLSClientAuthentication);
        if (tLSClientAuthentication == null) {
            throw new IllegalArgumentException("The mutual TLS client authentication must not be null");
        }
        if (jSONObject == null) {
            throw new IllegalArgumentException("The request JSON object must not be null");
        }
        this.requestJSONObject = jSONObject;
        this.requestObject = null;
    }

    public JWT getRequestObject() {
        return this.requestObject;
    }

    public JSONObject getRequestJSONObject() {
        return this.requestJSONObject;
    }

    public TLSClientAuthentication getTLSClientAuthentication() {
        return (TLSClientAuthentication)this.getClientAuthentication();
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        if (this.getRequestObject() != null) {
            hTTPRequest.setEntityContentType(ContentType.APPLICATION_JWT);
            hTTPRequest.setQuery(this.getRequestObject().serialize());
        } else if (this.getRequestJSONObject() != null) {
            hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
            hTTPRequest.setQuery(this.getRequestJSONObject().toJSONString());
            this.getTLSClientAuthentication().applyTo(hTTPRequest);
        }
        return hTTPRequest;
    }

    public static RequestObjectPOSTRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        if (hTTPRequest.getEntityContentType() == null) {
            throw new ParseException("Missing Content-Type");
        }
        if (ContentType.APPLICATION_JOSE.matches(hTTPRequest.getEntityContentType()) || ContentType.APPLICATION_JWT.matches(hTTPRequest.getEntityContentType())) {
            JWT jWT;
            try {
                jWT = JWTParser.parse(hTTPRequest.getQuery());
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid request object JWT: " + parseException.getMessage());
            }
            if (jWT instanceof PlainJWT) {
                throw new ParseException("The request object is an unsecured JWT (alg=none)");
            }
            return new RequestObjectPOSTRequest(hTTPRequest.getURI(), jWT);
        }
        if (ContentType.APPLICATION_JSON.matches(hTTPRequest.getEntityContentType())) {
            TLSClientAuthentication tLSClientAuthentication;
            JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
            if (jSONObject.get("client_id") == null) {
                throw new ParseException("Missing client_id in JSON object");
            }
            ClientID clientID = new ClientID(JSONObjectUtils.getString(jSONObject, "client_id"));
            if (hTTPRequest.getClientX509Certificate() != null && hTTPRequest.getClientX509CertificateSubjectDN() != null && hTTPRequest.getClientX509CertificateSubjectDN().equals(hTTPRequest.getClientX509CertificateRootDN())) {
                tLSClientAuthentication = new SelfSignedTLSClientAuthentication(clientID, hTTPRequest.getClientX509Certificate());
            } else if (hTTPRequest.getClientX509Certificate() != null) {
                tLSClientAuthentication = new PKITLSClientAuthentication(clientID, hTTPRequest.getClientX509Certificate());
            } else {
                throw new ParseException("Missing mutual TLS client authentication");
            }
            return new RequestObjectPOSTRequest(hTTPRequest.getURI(), tLSClientAuthentication, jSONObject);
        }
        throw new ParseException("Unexpected Content-Type: " + hTTPRequest.getEntityContentType());
    }
}

